/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.devops.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.devops.model.PullRequest;
import com.oracle.bmc.devops.model.SortOrder;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class ListPullRequestsRequest
extends BmcRequest<Void> {
    private String compartmentId;
    private PullRequest.LifecycleState lifecycleState;
    private PullRequest.LifecycleDetails lifecycleDetails;
    private String repositoryId;
    private String displayName;
    private String id;
    private String createdBy;
    private String destinationBranch;
    private String sourceBranch;
    private String reviewerPrincipalId;
    private String sourceRepositoryId;
    private Integer limit;
    private String page;
    private SortOrder sortOrder;
    private SortBy sortBy;
    private String opcRequestId;

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public PullRequest.LifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public PullRequest.LifecycleDetails getLifecycleDetails() {
        return this.lifecycleDetails;
    }

    public String getRepositoryId() {
        return this.repositoryId;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getId() {
        return this.id;
    }

    public String getCreatedBy() {
        return this.createdBy;
    }

    public String getDestinationBranch() {
        return this.destinationBranch;
    }

    public String getSourceBranch() {
        return this.sourceBranch;
    }

    public String getReviewerPrincipalId() {
        return this.reviewerPrincipalId;
    }

    public String getSourceRepositoryId() {
        return this.sourceRepositoryId;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getPage() {
        return this.page;
    }

    public SortOrder getSortOrder() {
        return this.sortOrder;
    }

    public SortBy getSortBy() {
        return this.sortBy;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().compartmentId(this.compartmentId).lifecycleState(this.lifecycleState).lifecycleDetails(this.lifecycleDetails).repositoryId(this.repositoryId).displayName(this.displayName).id(this.id).createdBy(this.createdBy).destinationBranch(this.destinationBranch).sourceBranch(this.sourceBranch).reviewerPrincipalId(this.reviewerPrincipalId).sourceRepositoryId(this.sourceRepositoryId).limit(this.limit).page(this.page).sortOrder(this.sortOrder).sortBy(this.sortBy).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(",lifecycleState=").append(String.valueOf((Object)this.lifecycleState));
        sb.append(",lifecycleDetails=").append(String.valueOf((Object)this.lifecycleDetails));
        sb.append(",repositoryId=").append(String.valueOf(this.repositoryId));
        sb.append(",displayName=").append(String.valueOf(this.displayName));
        sb.append(",id=").append(String.valueOf(this.id));
        sb.append(",createdBy=").append(String.valueOf(this.createdBy));
        sb.append(",destinationBranch=").append(String.valueOf(this.destinationBranch));
        sb.append(",sourceBranch=").append(String.valueOf(this.sourceBranch));
        sb.append(",reviewerPrincipalId=").append(String.valueOf(this.reviewerPrincipalId));
        sb.append(",sourceRepositoryId=").append(String.valueOf(this.sourceRepositoryId));
        sb.append(",limit=").append(String.valueOf(this.limit));
        sb.append(",page=").append(String.valueOf(this.page));
        sb.append(",sortOrder=").append(String.valueOf((Object)this.sortOrder));
        sb.append(",sortBy=").append(String.valueOf((Object)this.sortBy));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ListPullRequestsRequest)) {
            return false;
        }
        ListPullRequestsRequest other = (ListPullRequestsRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals((Object)this.lifecycleState, (Object)other.lifecycleState) && Objects.equals((Object)this.lifecycleDetails, (Object)other.lifecycleDetails) && Objects.equals(this.repositoryId, other.repositoryId) && Objects.equals(this.displayName, other.displayName) && Objects.equals(this.id, other.id) && Objects.equals(this.createdBy, other.createdBy) && Objects.equals(this.destinationBranch, other.destinationBranch) && Objects.equals(this.sourceBranch, other.sourceBranch) && Objects.equals(this.reviewerPrincipalId, other.reviewerPrincipalId) && Objects.equals(this.sourceRepositoryId, other.sourceRepositoryId) && Objects.equals(this.limit, other.limit) && Objects.equals(this.page, other.page) && Objects.equals((Object)this.sortOrder, (Object)other.sortOrder) && Objects.equals((Object)this.sortBy, (Object)other.sortBy) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.lifecycleState == null ? 43 : this.lifecycleState.hashCode());
        result = result * 59 + (this.lifecycleDetails == null ? 43 : this.lifecycleDetails.hashCode());
        result = result * 59 + (this.repositoryId == null ? 43 : this.repositoryId.hashCode());
        result = result * 59 + (this.displayName == null ? 43 : this.displayName.hashCode());
        result = result * 59 + (this.id == null ? 43 : this.id.hashCode());
        result = result * 59 + (this.createdBy == null ? 43 : this.createdBy.hashCode());
        result = result * 59 + (this.destinationBranch == null ? 43 : this.destinationBranch.hashCode());
        result = result * 59 + (this.sourceBranch == null ? 43 : this.sourceBranch.hashCode());
        result = result * 59 + (this.reviewerPrincipalId == null ? 43 : this.reviewerPrincipalId.hashCode());
        result = result * 59 + (this.sourceRepositoryId == null ? 43 : this.sourceRepositoryId.hashCode());
        result = result * 59 + (this.limit == null ? 43 : this.limit.hashCode());
        result = result * 59 + (this.page == null ? 43 : this.page.hashCode());
        result = result * 59 + (this.sortOrder == null ? 43 : this.sortOrder.hashCode());
        result = result * 59 + (this.sortBy == null ? 43 : this.sortBy.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<ListPullRequestsRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String compartmentId = null;
        private PullRequest.LifecycleState lifecycleState = null;
        private PullRequest.LifecycleDetails lifecycleDetails = null;
        private String repositoryId = null;
        private String displayName = null;
        private String id = null;
        private String createdBy = null;
        private String destinationBranch = null;
        private String sourceBranch = null;
        private String reviewerPrincipalId = null;
        private String sourceRepositoryId = null;
        private Integer limit = null;
        private String page = null;
        private SortOrder sortOrder = null;
        private SortBy sortBy = null;
        private String opcRequestId = null;

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            return this;
        }

        public Builder lifecycleState(PullRequest.LifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            return this;
        }

        public Builder lifecycleDetails(PullRequest.LifecycleDetails lifecycleDetails) {
            this.lifecycleDetails = lifecycleDetails;
            return this;
        }

        public Builder repositoryId(String repositoryId) {
            this.repositoryId = repositoryId;
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder createdBy(String createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        public Builder destinationBranch(String destinationBranch) {
            this.destinationBranch = destinationBranch;
            return this;
        }

        public Builder sourceBranch(String sourceBranch) {
            this.sourceBranch = sourceBranch;
            return this;
        }

        public Builder reviewerPrincipalId(String reviewerPrincipalId) {
            this.reviewerPrincipalId = reviewerPrincipalId;
            return this;
        }

        public Builder sourceRepositoryId(String sourceRepositoryId) {
            this.sourceRepositoryId = sourceRepositoryId;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        public Builder sortBy(SortBy sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListPullRequestsRequest o) {
            this.compartmentId(o.getCompartmentId());
            this.lifecycleState(o.getLifecycleState());
            this.lifecycleDetails(o.getLifecycleDetails());
            this.repositoryId(o.getRepositoryId());
            this.displayName(o.getDisplayName());
            this.id(o.getId());
            this.createdBy(o.getCreatedBy());
            this.destinationBranch(o.getDestinationBranch());
            this.sourceBranch(o.getSourceBranch());
            this.reviewerPrincipalId(o.getReviewerPrincipalId());
            this.sourceRepositoryId(o.getSourceRepositoryId());
            this.limit(o.getLimit());
            this.page(o.getPage());
            this.sortOrder(o.getSortOrder());
            this.sortBy(o.getSortBy());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListPullRequestsRequest build() {
            ListPullRequestsRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public ListPullRequestsRequest buildWithoutInvocationCallback() {
            ListPullRequestsRequest request = new ListPullRequestsRequest();
            request.compartmentId = this.compartmentId;
            request.lifecycleState = this.lifecycleState;
            request.lifecycleDetails = this.lifecycleDetails;
            request.repositoryId = this.repositoryId;
            request.displayName = this.displayName;
            request.id = this.id;
            request.createdBy = this.createdBy;
            request.destinationBranch = this.destinationBranch;
            request.sourceBranch = this.sourceBranch;
            request.reviewerPrincipalId = this.reviewerPrincipalId;
            request.sourceRepositoryId = this.sourceRepositoryId;
            request.limit = this.limit;
            request.page = this.page;
            request.sortOrder = this.sortOrder;
            request.sortBy = this.sortBy;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }

    public static enum SortBy implements BmcEnum
    {
        TimeCreated("timeCreated"),
        DisplayName("displayName");

        private final String value;
        private static Map<String, SortBy> map;

        private SortBy(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortBy create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortBy: " + key);
        }

        static {
            map = new HashMap<String, SortBy>();
            for (SortBy v : SortBy.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

