/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.devops.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.devops.model.MergePullRequestDetails;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class MergePullRequestRequest
extends BmcRequest<MergePullRequestDetails> {
    private String pullRequestId;
    private MergePullRequestDetails mergePullRequestDetails;
    private String ifMatch;
    private String opcRequestId;
    private String opcRetryToken;

    public String getPullRequestId() {
        return this.pullRequestId;
    }

    public MergePullRequestDetails getMergePullRequestDetails() {
        return this.mergePullRequestDetails;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    @InternalSdk
    public MergePullRequestDetails getBody$() {
        return this.mergePullRequestDetails;
    }

    public Builder toBuilder() {
        return new Builder().pullRequestId(this.pullRequestId).mergePullRequestDetails(this.mergePullRequestDetails).ifMatch(this.ifMatch).opcRequestId(this.opcRequestId).opcRetryToken(this.opcRetryToken);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",pullRequestId=").append(String.valueOf(this.pullRequestId));
        sb.append(",mergePullRequestDetails=").append(String.valueOf((Object)this.mergePullRequestDetails));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",opcRetryToken=").append(String.valueOf(this.opcRetryToken));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MergePullRequestRequest)) {
            return false;
        }
        MergePullRequestRequest other = (MergePullRequestRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.pullRequestId, other.pullRequestId) && Objects.equals((Object)this.mergePullRequestDetails, (Object)other.mergePullRequestDetails) && Objects.equals(this.ifMatch, other.ifMatch) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.opcRetryToken, other.opcRetryToken);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.pullRequestId == null ? 43 : this.pullRequestId.hashCode());
        result = result * 59 + (this.mergePullRequestDetails == null ? 43 : this.mergePullRequestDetails.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.opcRetryToken == null ? 43 : this.opcRetryToken.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<MergePullRequestRequest, MergePullRequestDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String pullRequestId = null;
        private MergePullRequestDetails mergePullRequestDetails = null;
        private String ifMatch = null;
        private String opcRequestId = null;
        private String opcRetryToken = null;

        public Builder pullRequestId(String pullRequestId) {
            this.pullRequestId = pullRequestId;
            return this;
        }

        public Builder mergePullRequestDetails(MergePullRequestDetails mergePullRequestDetails) {
            this.mergePullRequestDetails = mergePullRequestDetails;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(MergePullRequestRequest o) {
            this.pullRequestId(o.getPullRequestId());
            this.mergePullRequestDetails(o.getMergePullRequestDetails());
            this.ifMatch(o.getIfMatch());
            this.opcRequestId(o.getOpcRequestId());
            this.opcRetryToken(o.getOpcRetryToken());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public MergePullRequestRequest build() {
            MergePullRequestRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(MergePullRequestDetails body) {
            this.mergePullRequestDetails(body);
            return this;
        }

        public MergePullRequestRequest buildWithoutInvocationCallback() {
            MergePullRequestRequest request = new MergePullRequestRequest();
            request.pullRequestId = this.pullRequestId;
            request.mergePullRequestDetails = this.mergePullRequestDetails;
            request.ifMatch = this.ifMatch;
            request.opcRequestId = this.opcRequestId;
            request.opcRetryToken = this.opcRetryToken;
            return request;
        }
    }
}

