/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.devops.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.devops.model.PatchPullRequestDetails;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class PatchPullRequestRequest
extends BmcRequest<PatchPullRequestDetails> {
    private String pullRequestId;
    private PatchPullRequestDetails patchPullRequestDetails;
    private String ifMatch;
    private String opcRequestId;

    public String getPullRequestId() {
        return this.pullRequestId;
    }

    public PatchPullRequestDetails getPatchPullRequestDetails() {
        return this.patchPullRequestDetails;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    @InternalSdk
    public PatchPullRequestDetails getBody$() {
        return this.patchPullRequestDetails;
    }

    public Builder toBuilder() {
        return new Builder().pullRequestId(this.pullRequestId).patchPullRequestDetails(this.patchPullRequestDetails).ifMatch(this.ifMatch).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",pullRequestId=").append(String.valueOf(this.pullRequestId));
        sb.append(",patchPullRequestDetails=").append(String.valueOf((Object)this.patchPullRequestDetails));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PatchPullRequestRequest)) {
            return false;
        }
        PatchPullRequestRequest other = (PatchPullRequestRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.pullRequestId, other.pullRequestId) && Objects.equals((Object)this.patchPullRequestDetails, (Object)other.patchPullRequestDetails) && Objects.equals(this.ifMatch, other.ifMatch) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.pullRequestId == null ? 43 : this.pullRequestId.hashCode());
        result = result * 59 + (this.patchPullRequestDetails == null ? 43 : this.patchPullRequestDetails.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<PatchPullRequestRequest, PatchPullRequestDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String pullRequestId = null;
        private PatchPullRequestDetails patchPullRequestDetails = null;
        private String ifMatch = null;
        private String opcRequestId = null;

        public Builder pullRequestId(String pullRequestId) {
            this.pullRequestId = pullRequestId;
            return this;
        }

        public Builder patchPullRequestDetails(PatchPullRequestDetails patchPullRequestDetails) {
            this.patchPullRequestDetails = patchPullRequestDetails;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(PatchPullRequestRequest o) {
            this.pullRequestId(o.getPullRequestId());
            this.patchPullRequestDetails(o.getPatchPullRequestDetails());
            this.ifMatch(o.getIfMatch());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public PatchPullRequestRequest build() {
            PatchPullRequestRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(PatchPullRequestDetails body) {
            this.patchPullRequestDetails(body);
            return this;
        }

        public PatchPullRequestRequest buildWithoutInvocationCallback() {
            PatchPullRequestRequest request = new PatchPullRequestRequest();
            request.pullRequestId = this.pullRequestId;
            request.patchPullRequestDetails = this.patchPullRequestDetails;
            request.ifMatch = this.ifMatch;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

