/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.devops.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.devops.model.SummarizeProjectRepositoryAnalyticsDetails;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class SummarizeProjectRepositoryAnalyticsRequest
extends BmcRequest<SummarizeProjectRepositoryAnalyticsDetails> {
    private String projectId;
    private SummarizeProjectRepositoryAnalyticsDetails summarizeProjectRepositoryAnalyticsDetails;
    private Integer limit;
    private String page;
    private String opcRequestId;

    public String getProjectId() {
        return this.projectId;
    }

    public SummarizeProjectRepositoryAnalyticsDetails getSummarizeProjectRepositoryAnalyticsDetails() {
        return this.summarizeProjectRepositoryAnalyticsDetails;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getPage() {
        return this.page;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    @InternalSdk
    public SummarizeProjectRepositoryAnalyticsDetails getBody$() {
        return this.summarizeProjectRepositoryAnalyticsDetails;
    }

    public Builder toBuilder() {
        return new Builder().projectId(this.projectId).summarizeProjectRepositoryAnalyticsDetails(this.summarizeProjectRepositoryAnalyticsDetails).limit(this.limit).page(this.page).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",projectId=").append(String.valueOf(this.projectId));
        sb.append(",summarizeProjectRepositoryAnalyticsDetails=").append(String.valueOf((Object)this.summarizeProjectRepositoryAnalyticsDetails));
        sb.append(",limit=").append(String.valueOf(this.limit));
        sb.append(",page=").append(String.valueOf(this.page));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SummarizeProjectRepositoryAnalyticsRequest)) {
            return false;
        }
        SummarizeProjectRepositoryAnalyticsRequest other = (SummarizeProjectRepositoryAnalyticsRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.projectId, other.projectId) && Objects.equals((Object)this.summarizeProjectRepositoryAnalyticsDetails, (Object)other.summarizeProjectRepositoryAnalyticsDetails) && Objects.equals(this.limit, other.limit) && Objects.equals(this.page, other.page) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.projectId == null ? 43 : this.projectId.hashCode());
        result = result * 59 + (this.summarizeProjectRepositoryAnalyticsDetails == null ? 43 : this.summarizeProjectRepositoryAnalyticsDetails.hashCode());
        result = result * 59 + (this.limit == null ? 43 : this.limit.hashCode());
        result = result * 59 + (this.page == null ? 43 : this.page.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<SummarizeProjectRepositoryAnalyticsRequest, SummarizeProjectRepositoryAnalyticsDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String projectId = null;
        private SummarizeProjectRepositoryAnalyticsDetails summarizeProjectRepositoryAnalyticsDetails = null;
        private Integer limit = null;
        private String page = null;
        private String opcRequestId = null;

        public Builder projectId(String projectId) {
            this.projectId = projectId;
            return this;
        }

        public Builder summarizeProjectRepositoryAnalyticsDetails(SummarizeProjectRepositoryAnalyticsDetails summarizeProjectRepositoryAnalyticsDetails) {
            this.summarizeProjectRepositoryAnalyticsDetails = summarizeProjectRepositoryAnalyticsDetails;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(SummarizeProjectRepositoryAnalyticsRequest o) {
            this.projectId(o.getProjectId());
            this.summarizeProjectRepositoryAnalyticsDetails(o.getSummarizeProjectRepositoryAnalyticsDetails());
            this.limit(o.getLimit());
            this.page(o.getPage());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public SummarizeProjectRepositoryAnalyticsRequest build() {
            SummarizeProjectRepositoryAnalyticsRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(SummarizeProjectRepositoryAnalyticsDetails body) {
            this.summarizeProjectRepositoryAnalyticsDetails(body);
            return this;
        }

        public SummarizeProjectRepositoryAnalyticsRequest buildWithoutInvocationCallback() {
            SummarizeProjectRepositoryAnalyticsRequest request = new SummarizeProjectRepositoryAnalyticsRequest();
            request.projectId = this.projectId;
            request.summarizeProjectRepositoryAnalyticsDetails = this.summarizeProjectRepositoryAnalyticsDetails;
            request.limit = this.limit;
            request.page = this.page;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

