/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.devops.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.devops.model.SummarizeRepositoryAnalyticsDetails;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class SummarizeRepositoryAnalyticsRequest
extends BmcRequest<SummarizeRepositoryAnalyticsDetails> {
    private String repositoryId;
    private SummarizeRepositoryAnalyticsDetails summarizeRepositoryAnalyticsDetails;
    private Integer limit;
    private String page;
    private String opcRequestId;

    public String getRepositoryId() {
        return this.repositoryId;
    }

    public SummarizeRepositoryAnalyticsDetails getSummarizeRepositoryAnalyticsDetails() {
        return this.summarizeRepositoryAnalyticsDetails;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getPage() {
        return this.page;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    @InternalSdk
    public SummarizeRepositoryAnalyticsDetails getBody$() {
        return this.summarizeRepositoryAnalyticsDetails;
    }

    public Builder toBuilder() {
        return new Builder().repositoryId(this.repositoryId).summarizeRepositoryAnalyticsDetails(this.summarizeRepositoryAnalyticsDetails).limit(this.limit).page(this.page).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",repositoryId=").append(String.valueOf(this.repositoryId));
        sb.append(",summarizeRepositoryAnalyticsDetails=").append(String.valueOf((Object)this.summarizeRepositoryAnalyticsDetails));
        sb.append(",limit=").append(String.valueOf(this.limit));
        sb.append(",page=").append(String.valueOf(this.page));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SummarizeRepositoryAnalyticsRequest)) {
            return false;
        }
        SummarizeRepositoryAnalyticsRequest other = (SummarizeRepositoryAnalyticsRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.repositoryId, other.repositoryId) && Objects.equals((Object)this.summarizeRepositoryAnalyticsDetails, (Object)other.summarizeRepositoryAnalyticsDetails) && Objects.equals(this.limit, other.limit) && Objects.equals(this.page, other.page) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.repositoryId == null ? 43 : this.repositoryId.hashCode());
        result = result * 59 + (this.summarizeRepositoryAnalyticsDetails == null ? 43 : this.summarizeRepositoryAnalyticsDetails.hashCode());
        result = result * 59 + (this.limit == null ? 43 : this.limit.hashCode());
        result = result * 59 + (this.page == null ? 43 : this.page.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<SummarizeRepositoryAnalyticsRequest, SummarizeRepositoryAnalyticsDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String repositoryId = null;
        private SummarizeRepositoryAnalyticsDetails summarizeRepositoryAnalyticsDetails = null;
        private Integer limit = null;
        private String page = null;
        private String opcRequestId = null;

        public Builder repositoryId(String repositoryId) {
            this.repositoryId = repositoryId;
            return this;
        }

        public Builder summarizeRepositoryAnalyticsDetails(SummarizeRepositoryAnalyticsDetails summarizeRepositoryAnalyticsDetails) {
            this.summarizeRepositoryAnalyticsDetails = summarizeRepositoryAnalyticsDetails;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(SummarizeRepositoryAnalyticsRequest o) {
            this.repositoryId(o.getRepositoryId());
            this.summarizeRepositoryAnalyticsDetails(o.getSummarizeRepositoryAnalyticsDetails());
            this.limit(o.getLimit());
            this.page(o.getPage());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public SummarizeRepositoryAnalyticsRequest build() {
            SummarizeRepositoryAnalyticsRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(SummarizeRepositoryAnalyticsDetails body) {
            this.summarizeRepositoryAnalyticsDetails(body);
            return this;
        }

        public SummarizeRepositoryAnalyticsRequest buildWithoutInvocationCallback() {
            SummarizeRepositoryAnalyticsRequest request = new SummarizeRepositoryAnalyticsRequest();
            request.repositoryId = this.repositoryId;
            request.summarizeRepositoryAnalyticsDetails = this.summarizeRepositoryAnalyticsDetails;
            request.limit = this.limit;
            request.page = this.page;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

