/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.devops.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.devops.model.SyncRepositoryDetails;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class SyncRepositoryRequest
extends BmcRequest<SyncRepositoryDetails> {
    private String repositoryId;
    private SyncMergeStrategy syncMergeStrategy;
    private SyncRepositoryDetails syncRepositoryDetails;
    private String ifMatch;
    private String opcRequestId;
    private String opcRetryToken;

    public String getRepositoryId() {
        return this.repositoryId;
    }

    public SyncMergeStrategy getSyncMergeStrategy() {
        return this.syncMergeStrategy;
    }

    public SyncRepositoryDetails getSyncRepositoryDetails() {
        return this.syncRepositoryDetails;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    @InternalSdk
    public SyncRepositoryDetails getBody$() {
        return this.syncRepositoryDetails;
    }

    public Builder toBuilder() {
        return new Builder().repositoryId(this.repositoryId).syncMergeStrategy(this.syncMergeStrategy).syncRepositoryDetails(this.syncRepositoryDetails).ifMatch(this.ifMatch).opcRequestId(this.opcRequestId).opcRetryToken(this.opcRetryToken);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",repositoryId=").append(String.valueOf(this.repositoryId));
        sb.append(",syncMergeStrategy=").append(String.valueOf((Object)this.syncMergeStrategy));
        sb.append(",syncRepositoryDetails=").append(String.valueOf((Object)this.syncRepositoryDetails));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",opcRetryToken=").append(String.valueOf(this.opcRetryToken));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SyncRepositoryRequest)) {
            return false;
        }
        SyncRepositoryRequest other = (SyncRepositoryRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.repositoryId, other.repositoryId) && Objects.equals((Object)this.syncMergeStrategy, (Object)other.syncMergeStrategy) && Objects.equals((Object)this.syncRepositoryDetails, (Object)other.syncRepositoryDetails) && Objects.equals(this.ifMatch, other.ifMatch) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.opcRetryToken, other.opcRetryToken);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.repositoryId == null ? 43 : this.repositoryId.hashCode());
        result = result * 59 + (this.syncMergeStrategy == null ? 43 : this.syncMergeStrategy.hashCode());
        result = result * 59 + (this.syncRepositoryDetails == null ? 43 : this.syncRepositoryDetails.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.opcRetryToken == null ? 43 : this.opcRetryToken.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<SyncRepositoryRequest, SyncRepositoryDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String repositoryId = null;
        private SyncMergeStrategy syncMergeStrategy = null;
        private SyncRepositoryDetails syncRepositoryDetails = null;
        private String ifMatch = null;
        private String opcRequestId = null;
        private String opcRetryToken = null;

        public Builder repositoryId(String repositoryId) {
            this.repositoryId = repositoryId;
            return this;
        }

        public Builder syncMergeStrategy(SyncMergeStrategy syncMergeStrategy) {
            this.syncMergeStrategy = syncMergeStrategy;
            return this;
        }

        public Builder syncRepositoryDetails(SyncRepositoryDetails syncRepositoryDetails) {
            this.syncRepositoryDetails = syncRepositoryDetails;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(SyncRepositoryRequest o) {
            this.repositoryId(o.getRepositoryId());
            this.syncMergeStrategy(o.getSyncMergeStrategy());
            this.syncRepositoryDetails(o.getSyncRepositoryDetails());
            this.ifMatch(o.getIfMatch());
            this.opcRequestId(o.getOpcRequestId());
            this.opcRetryToken(o.getOpcRetryToken());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public SyncRepositoryRequest build() {
            SyncRepositoryRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(SyncRepositoryDetails body) {
            this.syncRepositoryDetails(body);
            return this;
        }

        public SyncRepositoryRequest buildWithoutInvocationCallback() {
            SyncRepositoryRequest request = new SyncRepositoryRequest();
            request.repositoryId = this.repositoryId;
            request.syncMergeStrategy = this.syncMergeStrategy;
            request.syncRepositoryDetails = this.syncRepositoryDetails;
            request.ifMatch = this.ifMatch;
            request.opcRequestId = this.opcRequestId;
            request.opcRetryToken = this.opcRetryToken;
            return request;
        }
    }

    public static enum SyncMergeStrategy implements BmcEnum
    {
        FetchAndMerge("FETCH_AND_MERGE"),
        Discard("DISCARD");

        private final String value;
        private static Map<String, SyncMergeStrategy> map;

        private SyncMergeStrategy(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SyncMergeStrategy create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SyncMergeStrategy: " + key);
        }

        static {
            map = new HashMap<String, SyncMergeStrategy>();
            for (SyncMergeStrategy v : SyncMergeStrategy.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

