/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.devops.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.devops.model.UpdatePullRequestCommentDetails;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class UpdatePullRequestCommentRequest
extends BmcRequest<UpdatePullRequestCommentDetails> {
    private String pullRequestId;
    private String commentId;
    private UpdatePullRequestCommentDetails updatePullRequestCommentDetails;
    private String ifMatch;
    private String opcRequestId;

    public String getPullRequestId() {
        return this.pullRequestId;
    }

    public String getCommentId() {
        return this.commentId;
    }

    public UpdatePullRequestCommentDetails getUpdatePullRequestCommentDetails() {
        return this.updatePullRequestCommentDetails;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    @InternalSdk
    public UpdatePullRequestCommentDetails getBody$() {
        return this.updatePullRequestCommentDetails;
    }

    public Builder toBuilder() {
        return new Builder().pullRequestId(this.pullRequestId).commentId(this.commentId).updatePullRequestCommentDetails(this.updatePullRequestCommentDetails).ifMatch(this.ifMatch).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",pullRequestId=").append(String.valueOf(this.pullRequestId));
        sb.append(",commentId=").append(String.valueOf(this.commentId));
        sb.append(",updatePullRequestCommentDetails=").append(String.valueOf((Object)this.updatePullRequestCommentDetails));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UpdatePullRequestCommentRequest)) {
            return false;
        }
        UpdatePullRequestCommentRequest other = (UpdatePullRequestCommentRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.pullRequestId, other.pullRequestId) && Objects.equals(this.commentId, other.commentId) && Objects.equals((Object)this.updatePullRequestCommentDetails, (Object)other.updatePullRequestCommentDetails) && Objects.equals(this.ifMatch, other.ifMatch) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.pullRequestId == null ? 43 : this.pullRequestId.hashCode());
        result = result * 59 + (this.commentId == null ? 43 : this.commentId.hashCode());
        result = result * 59 + (this.updatePullRequestCommentDetails == null ? 43 : this.updatePullRequestCommentDetails.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<UpdatePullRequestCommentRequest, UpdatePullRequestCommentDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String pullRequestId = null;
        private String commentId = null;
        private UpdatePullRequestCommentDetails updatePullRequestCommentDetails = null;
        private String ifMatch = null;
        private String opcRequestId = null;

        public Builder pullRequestId(String pullRequestId) {
            this.pullRequestId = pullRequestId;
            return this;
        }

        public Builder commentId(String commentId) {
            this.commentId = commentId;
            return this;
        }

        public Builder updatePullRequestCommentDetails(UpdatePullRequestCommentDetails updatePullRequestCommentDetails) {
            this.updatePullRequestCommentDetails = updatePullRequestCommentDetails;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(UpdatePullRequestCommentRequest o) {
            this.pullRequestId(o.getPullRequestId());
            this.commentId(o.getCommentId());
            this.updatePullRequestCommentDetails(o.getUpdatePullRequestCommentDetails());
            this.ifMatch(o.getIfMatch());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public UpdatePullRequestCommentRequest build() {
            UpdatePullRequestCommentRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(UpdatePullRequestCommentDetails body) {
            this.updatePullRequestCommentDetails(body);
            return this;
        }

        public UpdatePullRequestCommentRequest buildWithoutInvocationCallback() {
            UpdatePullRequestCommentRequest request = new UpdatePullRequestCommentRequest();
            request.pullRequestId = this.pullRequestId;
            request.commentId = this.commentId;
            request.updatePullRequestCommentDetails = this.updatePullRequestCommentDetails;
            request.ifMatch = this.ifMatch;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

