/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.devops.responses;

import com.oracle.bmc.devops.model.PullRequestAttachment;
import com.oracle.bmc.responses.BmcResponse;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class CreatePullRequestAttachmentResponse
extends BmcResponse {
    private String contentLocation;
    private String location;
    private String opcRequestId;
    private String etag;
    private PullRequestAttachment pullRequestAttachment;

    public String getContentLocation() {
        return this.contentLocation;
    }

    public String getLocation() {
        return this.location;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getEtag() {
        return this.etag;
    }

    public PullRequestAttachment getPullRequestAttachment() {
        return this.pullRequestAttachment;
    }

    @ConstructorProperties(value={"__httpStatusCode__", "headers", "contentLocation", "location", "opcRequestId", "etag", "pullRequestAttachment"})
    private CreatePullRequestAttachmentResponse(int __httpStatusCode__, Map<String, List<String>> headers, String contentLocation, String location, String opcRequestId, String etag, PullRequestAttachment pullRequestAttachment) {
        super(__httpStatusCode__, headers);
        this.contentLocation = contentLocation;
        this.location = location;
        this.opcRequestId = opcRequestId;
        this.etag = etag;
        this.pullRequestAttachment = pullRequestAttachment;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",contentLocation=").append(String.valueOf(this.contentLocation));
        sb.append(",location=").append(String.valueOf(this.location));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",etag=").append(String.valueOf(this.etag));
        sb.append(",pullRequestAttachment=").append(String.valueOf((Object)this.pullRequestAttachment));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CreatePullRequestAttachmentResponse)) {
            return false;
        }
        CreatePullRequestAttachmentResponse other = (CreatePullRequestAttachmentResponse)((Object)o);
        return super.equals(o) && Objects.equals(this.contentLocation, other.contentLocation) && Objects.equals(this.location, other.location) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.etag, other.etag) && Objects.equals((Object)this.pullRequestAttachment, (Object)other.pullRequestAttachment);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.contentLocation == null ? 43 : this.contentLocation.hashCode());
        result = result * 59 + (this.location == null ? 43 : this.location.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.etag == null ? 43 : this.etag.hashCode());
        result = result * 59 + (this.pullRequestAttachment == null ? 43 : this.pullRequestAttachment.hashCode());
        return result;
    }

    public static class Builder
    implements BmcResponse.Builder<CreatePullRequestAttachmentResponse> {
        private int __httpStatusCode__;
        private Map<String, List<String>> headers;
        private String contentLocation;
        private String location;
        private String opcRequestId;
        private String etag;
        private PullRequestAttachment pullRequestAttachment;

        public Builder __httpStatusCode__(int __httpStatusCode__) {
            this.__httpStatusCode__ = __httpStatusCode__;
            return this;
        }

        public Builder headers(Map<String, List<String>> headers) {
            this.headers = headers;
            return this;
        }

        public Builder contentLocation(String contentLocation) {
            this.contentLocation = contentLocation;
            return this;
        }

        public Builder location(String location) {
            this.location = location;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder etag(String etag) {
            this.etag = etag;
            return this;
        }

        public Builder pullRequestAttachment(PullRequestAttachment pullRequestAttachment) {
            this.pullRequestAttachment = pullRequestAttachment;
            return this;
        }

        public Builder copy(CreatePullRequestAttachmentResponse o) {
            this.__httpStatusCode__(o.get__httpStatusCode__());
            this.headers(o.getHeaders());
            this.contentLocation(o.getContentLocation());
            this.location(o.getLocation());
            this.opcRequestId(o.getOpcRequestId());
            this.etag(o.getEtag());
            this.pullRequestAttachment(o.getPullRequestAttachment());
            return this;
        }

        public CreatePullRequestAttachmentResponse build() {
            return new CreatePullRequestAttachmentResponse(this.__httpStatusCode__, this.headers, this.contentLocation, this.location, this.opcRequestId, this.etag, this.pullRequestAttachment);
        }
    }
}

