/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.devops.responses;

import com.oracle.bmc.devops.model.RepositoryRef;
import com.oracle.bmc.responses.BmcResponse;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class GetRefResponse
extends BmcResponse {
    private String etag;
    private String opcRequestId;
    private String sunset;
    private RepositoryRef repositoryRef;

    public String getEtag() {
        return this.etag;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getSunset() {
        return this.sunset;
    }

    public RepositoryRef getRepositoryRef() {
        return this.repositoryRef;
    }

    @ConstructorProperties(value={"__httpStatusCode__", "headers", "etag", "opcRequestId", "sunset", "repositoryRef"})
    private GetRefResponse(int __httpStatusCode__, Map<String, List<String>> headers, String etag, String opcRequestId, String sunset, RepositoryRef repositoryRef) {
        super(__httpStatusCode__, headers);
        this.etag = etag;
        this.opcRequestId = opcRequestId;
        this.sunset = sunset;
        this.repositoryRef = repositoryRef;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",etag=").append(String.valueOf(this.etag));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",sunset=").append(String.valueOf(this.sunset));
        sb.append(",repositoryRef=").append(String.valueOf((Object)this.repositoryRef));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetRefResponse)) {
            return false;
        }
        GetRefResponse other = (GetRefResponse)((Object)o);
        return super.equals(o) && Objects.equals(this.etag, other.etag) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.sunset, other.sunset) && Objects.equals((Object)this.repositoryRef, (Object)other.repositoryRef);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.etag == null ? 43 : this.etag.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.sunset == null ? 43 : this.sunset.hashCode());
        result = result * 59 + (this.repositoryRef == null ? 43 : this.repositoryRef.hashCode());
        return result;
    }

    public static class Builder
    implements BmcResponse.Builder<GetRefResponse> {
        private int __httpStatusCode__;
        private Map<String, List<String>> headers;
        private String etag;
        private String opcRequestId;
        private String sunset;
        private RepositoryRef repositoryRef;

        public Builder __httpStatusCode__(int __httpStatusCode__) {
            this.__httpStatusCode__ = __httpStatusCode__;
            return this;
        }

        public Builder headers(Map<String, List<String>> headers) {
            this.headers = headers;
            return this;
        }

        public Builder etag(String etag) {
            this.etag = etag;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder sunset(String sunset) {
            this.sunset = sunset;
            return this;
        }

        public Builder repositoryRef(RepositoryRef repositoryRef) {
            this.repositoryRef = repositoryRef;
            return this;
        }

        public Builder copy(GetRefResponse o) {
            this.__httpStatusCode__(o.get__httpStatusCode__());
            this.headers(o.getHeaders());
            this.etag(o.getEtag());
            this.opcRequestId(o.getOpcRequestId());
            this.sunset(o.getSunset());
            this.repositoryRef(o.getRepositoryRef());
            return this;
        }

        public GetRefResponse build() {
            return new GetRefResponse(this.__httpStatusCode__, this.headers, this.etag, this.opcRequestId, this.sunset, this.repositoryRef);
        }
    }
}

