/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.devops.responses;

import com.oracle.bmc.devops.model.PullRequest;
import com.oracle.bmc.responses.BmcResponse;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class MergePullRequestResponse
extends BmcResponse {
    private String contentLocation;
    private String etag;
    private String opcWorkRequestId;
    private String opcRequestId;
    private PullRequest pullRequest;

    public String getContentLocation() {
        return this.contentLocation;
    }

    public String getEtag() {
        return this.etag;
    }

    public String getOpcWorkRequestId() {
        return this.opcWorkRequestId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public PullRequest getPullRequest() {
        return this.pullRequest;
    }

    @ConstructorProperties(value={"__httpStatusCode__", "headers", "contentLocation", "etag", "opcWorkRequestId", "opcRequestId", "pullRequest"})
    private MergePullRequestResponse(int __httpStatusCode__, Map<String, List<String>> headers, String contentLocation, String etag, String opcWorkRequestId, String opcRequestId, PullRequest pullRequest) {
        super(__httpStatusCode__, headers);
        this.contentLocation = contentLocation;
        this.etag = etag;
        this.opcWorkRequestId = opcWorkRequestId;
        this.opcRequestId = opcRequestId;
        this.pullRequest = pullRequest;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",contentLocation=").append(String.valueOf(this.contentLocation));
        sb.append(",etag=").append(String.valueOf(this.etag));
        sb.append(",opcWorkRequestId=").append(String.valueOf(this.opcWorkRequestId));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",pullRequest=").append(String.valueOf((Object)this.pullRequest));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MergePullRequestResponse)) {
            return false;
        }
        MergePullRequestResponse other = (MergePullRequestResponse)((Object)o);
        return super.equals(o) && Objects.equals(this.contentLocation, other.contentLocation) && Objects.equals(this.etag, other.etag) && Objects.equals(this.opcWorkRequestId, other.opcWorkRequestId) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals((Object)this.pullRequest, (Object)other.pullRequest);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.contentLocation == null ? 43 : this.contentLocation.hashCode());
        result = result * 59 + (this.etag == null ? 43 : this.etag.hashCode());
        result = result * 59 + (this.opcWorkRequestId == null ? 43 : this.opcWorkRequestId.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.pullRequest == null ? 43 : this.pullRequest.hashCode());
        return result;
    }

    public static class Builder
    implements BmcResponse.Builder<MergePullRequestResponse> {
        private int __httpStatusCode__;
        private Map<String, List<String>> headers;
        private String contentLocation;
        private String etag;
        private String opcWorkRequestId;
        private String opcRequestId;
        private PullRequest pullRequest;

        public Builder __httpStatusCode__(int __httpStatusCode__) {
            this.__httpStatusCode__ = __httpStatusCode__;
            return this;
        }

        public Builder headers(Map<String, List<String>> headers) {
            this.headers = headers;
            return this;
        }

        public Builder contentLocation(String contentLocation) {
            this.contentLocation = contentLocation;
            return this;
        }

        public Builder etag(String etag) {
            this.etag = etag;
            return this;
        }

        public Builder opcWorkRequestId(String opcWorkRequestId) {
            this.opcWorkRequestId = opcWorkRequestId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder pullRequest(PullRequest pullRequest) {
            this.pullRequest = pullRequest;
            return this;
        }

        public Builder copy(MergePullRequestResponse o) {
            this.__httpStatusCode__(o.get__httpStatusCode__());
            this.headers(o.getHeaders());
            this.contentLocation(o.getContentLocation());
            this.etag(o.getEtag());
            this.opcWorkRequestId(o.getOpcWorkRequestId());
            this.opcRequestId(o.getOpcRequestId());
            this.pullRequest(o.getPullRequest());
            return this;
        }

        public MergePullRequestResponse build() {
            return new MergePullRequestResponse(this.__httpStatusCode__, this.headers, this.contentLocation, this.etag, this.opcWorkRequestId, this.opcRequestId, this.pullRequest);
        }
    }
}

