/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.devops.responses;

import com.oracle.bmc.devops.model.RepositorySettings;
import com.oracle.bmc.responses.BmcResponse;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class UpdateRepositorySettingsResponse
extends BmcResponse {
    private String location;
    private String etag;
    private String opcRequestId;
    private RepositorySettings repositorySettings;

    public String getLocation() {
        return this.location;
    }

    public String getEtag() {
        return this.etag;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public RepositorySettings getRepositorySettings() {
        return this.repositorySettings;
    }

    @ConstructorProperties(value={"__httpStatusCode__", "headers", "location", "etag", "opcRequestId", "repositorySettings"})
    private UpdateRepositorySettingsResponse(int __httpStatusCode__, Map<String, List<String>> headers, String location, String etag, String opcRequestId, RepositorySettings repositorySettings) {
        super(__httpStatusCode__, headers);
        this.location = location;
        this.etag = etag;
        this.opcRequestId = opcRequestId;
        this.repositorySettings = repositorySettings;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",location=").append(String.valueOf(this.location));
        sb.append(",etag=").append(String.valueOf(this.etag));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",repositorySettings=").append(String.valueOf((Object)this.repositorySettings));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UpdateRepositorySettingsResponse)) {
            return false;
        }
        UpdateRepositorySettingsResponse other = (UpdateRepositorySettingsResponse)((Object)o);
        return super.equals(o) && Objects.equals(this.location, other.location) && Objects.equals(this.etag, other.etag) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals((Object)this.repositorySettings, (Object)other.repositorySettings);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.location == null ? 43 : this.location.hashCode());
        result = result * 59 + (this.etag == null ? 43 : this.etag.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.repositorySettings == null ? 43 : this.repositorySettings.hashCode());
        return result;
    }

    public static class Builder
    implements BmcResponse.Builder<UpdateRepositorySettingsResponse> {
        private int __httpStatusCode__;
        private Map<String, List<String>> headers;
        private String location;
        private String etag;
        private String opcRequestId;
        private RepositorySettings repositorySettings;

        public Builder __httpStatusCode__(int __httpStatusCode__) {
            this.__httpStatusCode__ = __httpStatusCode__;
            return this;
        }

        public Builder headers(Map<String, List<String>> headers) {
            this.headers = headers;
            return this;
        }

        public Builder location(String location) {
            this.location = location;
            return this;
        }

        public Builder etag(String etag) {
            this.etag = etag;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder repositorySettings(RepositorySettings repositorySettings) {
            this.repositorySettings = repositorySettings;
            return this;
        }

        public Builder copy(UpdateRepositorySettingsResponse o) {
            this.__httpStatusCode__(o.get__httpStatusCode__());
            this.headers(o.getHeaders());
            this.location(o.getLocation());
            this.etag(o.getEtag());
            this.opcRequestId(o.getOpcRequestId());
            this.repositorySettings(o.getRepositorySettings());
            return this;
        }

        public UpdateRepositorySettingsResponse build() {
            return new UpdateRepositorySettingsResponse(this.__httpStatusCode__, this.headers, this.location, this.etag, this.opcRequestId, this.repositorySettings);
        }
    }
}

