/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.disasterrecovery;

import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.common.ClientBuilderBase;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.disasterrecovery.DisasterRecovery;
import com.oracle.bmc.disasterrecovery.DisasterRecoveryPaginators;
import com.oracle.bmc.disasterrecovery.DisasterRecoveryWaiters;
import com.oracle.bmc.disasterrecovery.model.DrPlan;
import com.oracle.bmc.disasterrecovery.model.DrPlanCollection;
import com.oracle.bmc.disasterrecovery.model.DrPlanExecution;
import com.oracle.bmc.disasterrecovery.model.DrPlanExecutionCollection;
import com.oracle.bmc.disasterrecovery.model.DrProtectionGroup;
import com.oracle.bmc.disasterrecovery.model.DrProtectionGroupCollection;
import com.oracle.bmc.disasterrecovery.model.WorkRequest;
import com.oracle.bmc.disasterrecovery.model.WorkRequestErrorCollection;
import com.oracle.bmc.disasterrecovery.model.WorkRequestLogEntryCollection;
import com.oracle.bmc.disasterrecovery.model.WorkRequestSummaryCollection;
import com.oracle.bmc.disasterrecovery.requests.AssociateDrProtectionGroupRequest;
import com.oracle.bmc.disasterrecovery.requests.CancelDrPlanExecutionRequest;
import com.oracle.bmc.disasterrecovery.requests.CancelWorkRequestRequest;
import com.oracle.bmc.disasterrecovery.requests.ChangeDrProtectionGroupCompartmentRequest;
import com.oracle.bmc.disasterrecovery.requests.CreateDrPlanExecutionRequest;
import com.oracle.bmc.disasterrecovery.requests.CreateDrPlanRequest;
import com.oracle.bmc.disasterrecovery.requests.CreateDrProtectionGroupRequest;
import com.oracle.bmc.disasterrecovery.requests.DeleteDrPlanExecutionRequest;
import com.oracle.bmc.disasterrecovery.requests.DeleteDrPlanRequest;
import com.oracle.bmc.disasterrecovery.requests.DeleteDrProtectionGroupRequest;
import com.oracle.bmc.disasterrecovery.requests.DisassociateDrProtectionGroupRequest;
import com.oracle.bmc.disasterrecovery.requests.GetDrPlanExecutionRequest;
import com.oracle.bmc.disasterrecovery.requests.GetDrPlanRequest;
import com.oracle.bmc.disasterrecovery.requests.GetDrProtectionGroupRequest;
import com.oracle.bmc.disasterrecovery.requests.GetWorkRequestRequest;
import com.oracle.bmc.disasterrecovery.requests.IgnoreDrPlanExecutionRequest;
import com.oracle.bmc.disasterrecovery.requests.ListDrPlanExecutionsRequest;
import com.oracle.bmc.disasterrecovery.requests.ListDrPlansRequest;
import com.oracle.bmc.disasterrecovery.requests.ListDrProtectionGroupsRequest;
import com.oracle.bmc.disasterrecovery.requests.ListWorkRequestErrorsRequest;
import com.oracle.bmc.disasterrecovery.requests.ListWorkRequestLogsRequest;
import com.oracle.bmc.disasterrecovery.requests.ListWorkRequestsRequest;
import com.oracle.bmc.disasterrecovery.requests.PauseDrPlanExecutionRequest;
import com.oracle.bmc.disasterrecovery.requests.ResumeDrPlanExecutionRequest;
import com.oracle.bmc.disasterrecovery.requests.RetryDrPlanExecutionRequest;
import com.oracle.bmc.disasterrecovery.requests.UpdateDrPlanExecutionRequest;
import com.oracle.bmc.disasterrecovery.requests.UpdateDrPlanRequest;
import com.oracle.bmc.disasterrecovery.requests.UpdateDrProtectionGroupRequest;
import com.oracle.bmc.disasterrecovery.requests.UpdateDrProtectionGroupRoleRequest;
import com.oracle.bmc.disasterrecovery.responses.AssociateDrProtectionGroupResponse;
import com.oracle.bmc.disasterrecovery.responses.CancelDrPlanExecutionResponse;
import com.oracle.bmc.disasterrecovery.responses.CancelWorkRequestResponse;
import com.oracle.bmc.disasterrecovery.responses.ChangeDrProtectionGroupCompartmentResponse;
import com.oracle.bmc.disasterrecovery.responses.CreateDrPlanExecutionResponse;
import com.oracle.bmc.disasterrecovery.responses.CreateDrPlanResponse;
import com.oracle.bmc.disasterrecovery.responses.CreateDrProtectionGroupResponse;
import com.oracle.bmc.disasterrecovery.responses.DeleteDrPlanExecutionResponse;
import com.oracle.bmc.disasterrecovery.responses.DeleteDrPlanResponse;
import com.oracle.bmc.disasterrecovery.responses.DeleteDrProtectionGroupResponse;
import com.oracle.bmc.disasterrecovery.responses.DisassociateDrProtectionGroupResponse;
import com.oracle.bmc.disasterrecovery.responses.GetDrPlanExecutionResponse;
import com.oracle.bmc.disasterrecovery.responses.GetDrPlanResponse;
import com.oracle.bmc.disasterrecovery.responses.GetDrProtectionGroupResponse;
import com.oracle.bmc.disasterrecovery.responses.GetWorkRequestResponse;
import com.oracle.bmc.disasterrecovery.responses.IgnoreDrPlanExecutionResponse;
import com.oracle.bmc.disasterrecovery.responses.ListDrPlanExecutionsResponse;
import com.oracle.bmc.disasterrecovery.responses.ListDrPlansResponse;
import com.oracle.bmc.disasterrecovery.responses.ListDrProtectionGroupsResponse;
import com.oracle.bmc.disasterrecovery.responses.ListWorkRequestErrorsResponse;
import com.oracle.bmc.disasterrecovery.responses.ListWorkRequestLogsResponse;
import com.oracle.bmc.disasterrecovery.responses.ListWorkRequestsResponse;
import com.oracle.bmc.disasterrecovery.responses.PauseDrPlanExecutionResponse;
import com.oracle.bmc.disasterrecovery.responses.ResumeDrPlanExecutionResponse;
import com.oracle.bmc.disasterrecovery.responses.RetryDrPlanExecutionResponse;
import com.oracle.bmc.disasterrecovery.responses.UpdateDrPlanExecutionResponse;
import com.oracle.bmc.disasterrecovery.responses.UpdateDrPlanResponse;
import com.oracle.bmc.disasterrecovery.responses.UpdateDrProtectionGroupResponse;
import com.oracle.bmc.disasterrecovery.responses.UpdateDrProtectionGroupRoleResponse;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.client.Method;
import com.oracle.bmc.http.internal.BaseSyncClient;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.internal.Alloy;
import com.oracle.bmc.internal.ClientThreadFactory;
import com.oracle.bmc.util.CircuitBreakerUtils;
import com.oracle.bmc.util.internal.Validate;
import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DisasterRecoveryClient
extends BaseSyncClient
implements DisasterRecovery {
    public static final Service SERVICE = Services.serviceBuilder().serviceName("DISASTERRECOVERY").serviceEndpointPrefix("").serviceEndpointTemplate("https://disaster-recovery.{region}.oci.{secondLevelDomain}").build();
    private static final Logger LOG = LoggerFactory.getLogger(DisasterRecoveryClient.class);
    private final DisasterRecoveryWaiters waiters;
    private final DisasterRecoveryPaginators paginators;

    DisasterRecoveryClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ExecutorService executorService) {
        super(builder, authenticationDetailsProvider, CircuitBreakerUtils.DEFAULT_CIRCUIT_BREAKER_CONFIGURATION);
        if (executorService == null) {
            ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(50, 50, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)ClientThreadFactory.builder().isDaemon(true).nameFormat("DisasterRecovery-waiters-%d").build());
            threadPoolExecutor.allowCoreThreadTimeOut(true);
            executorService = threadPoolExecutor;
        }
        this.waiters = new DisasterRecoveryWaiters(executorService, this);
        this.paginators = new DisasterRecoveryPaginators(this);
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setRegion(Region region) {
        super.setRegion(region);
    }

    @Override
    public void setRegion(String regionId) {
        super.setRegion(regionId);
    }

    @Override
    public AssociateDrProtectionGroupResponse associateDrProtectionGroup(AssociateDrProtectionGroupRequest request) {
        Objects.requireNonNull(request.getAssociateDrProtectionGroupDetails(), "associateDrProtectionGroupDetails is required");
        Validate.notBlank((String)request.getDrProtectionGroupId(), (String)"drProtectionGroupId must not be blank", (Object[])new Object[0]);
        return (AssociateDrProtectionGroupResponse)this.clientCall(request, AssociateDrProtectionGroupResponse::builder).logger(LOG, "associateDrProtectionGroup").serviceDetails("DisasterRecovery", "AssociateDrProtectionGroup", "https://docs.oracle.com/iaas/api/#/en/disaster-recovery/20220125/DrProtectionGroup/AssociateDrProtectionGroup").method(Method.POST).requestBuilder(AssociateDrProtectionGroupRequest::builder).basePath("/20220125").appendPathParam("drProtectionGroups").appendPathParam(request.getDrProtectionGroupId()).appendPathParam("actions").appendPathParam("associate").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().hasBody().handleResponseHeaderString("opc-work-request-id", AssociateDrProtectionGroupResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", AssociateDrProtectionGroupResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public CancelDrPlanExecutionResponse cancelDrPlanExecution(CancelDrPlanExecutionRequest request) {
        Objects.requireNonNull(request.getCancelDrPlanExecutionDetails(), "cancelDrPlanExecutionDetails is required");
        Validate.notBlank((String)request.getDrPlanExecutionId(), (String)"drPlanExecutionId must not be blank", (Object[])new Object[0]);
        return (CancelDrPlanExecutionResponse)this.clientCall(request, CancelDrPlanExecutionResponse::builder).logger(LOG, "cancelDrPlanExecution").serviceDetails("DisasterRecovery", "CancelDrPlanExecution", "https://docs.oracle.com/iaas/api/#/en/disaster-recovery/20220125/DrPlanExecution/CancelDrPlanExecution").method(Method.POST).requestBuilder(CancelDrPlanExecutionRequest::builder).basePath("/20220125").appendPathParam("drPlanExecutions").appendPathParam(request.getDrPlanExecutionId()).appendPathParam("actions").appendPathParam("cancel").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().hasBody().handleResponseHeaderString("opc-work-request-id", CancelDrPlanExecutionResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", CancelDrPlanExecutionResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public CancelWorkRequestResponse cancelWorkRequest(CancelWorkRequestRequest request) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return (CancelWorkRequestResponse)this.clientCall(request, CancelWorkRequestResponse::builder).logger(LOG, "cancelWorkRequest").serviceDetails("DisasterRecovery", "CancelWorkRequest", "https://docs.oracle.com/iaas/api/#/en/disaster-recovery/20220125/WorkRequest/CancelWorkRequest").method(Method.DELETE).requestBuilder(CancelWorkRequestRequest::builder).basePath("/20220125").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleResponseHeaderString("opc-request-id", CancelWorkRequestResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ChangeDrProtectionGroupCompartmentResponse changeDrProtectionGroupCompartment(ChangeDrProtectionGroupCompartmentRequest request) {
        Objects.requireNonNull(request.getChangeDrProtectionGroupCompartmentDetails(), "changeDrProtectionGroupCompartmentDetails is required");
        Validate.notBlank((String)request.getDrProtectionGroupId(), (String)"drProtectionGroupId must not be blank", (Object[])new Object[0]);
        return (ChangeDrProtectionGroupCompartmentResponse)this.clientCall(request, ChangeDrProtectionGroupCompartmentResponse::builder).logger(LOG, "changeDrProtectionGroupCompartment").serviceDetails("DisasterRecovery", "ChangeDrProtectionGroupCompartment", "https://docs.oracle.com/iaas/api/#/en/disaster-recovery/20220125/DrProtectionGroup/ChangeDrProtectionGroupCompartment").method(Method.POST).requestBuilder(ChangeDrProtectionGroupCompartmentRequest::builder).basePath("/20220125").appendPathParam("drProtectionGroups").appendPathParam(request.getDrProtectionGroupId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().hasBody().handleResponseHeaderString("opc-work-request-id", ChangeDrProtectionGroupCompartmentResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", ChangeDrProtectionGroupCompartmentResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public CreateDrPlanResponse createDrPlan(CreateDrPlanRequest request) {
        Objects.requireNonNull(request.getCreateDrPlanDetails(), "createDrPlanDetails is required");
        return (CreateDrPlanResponse)this.clientCall(request, CreateDrPlanResponse::builder).logger(LOG, "createDrPlan").serviceDetails("DisasterRecovery", "CreateDrPlan", "https://docs.oracle.com/iaas/api/#/en/disaster-recovery/20220125/DrPlan/CreateDrPlan").method(Method.POST).requestBuilder(CreateDrPlanRequest::builder).basePath("/20220125").appendPathParam("drPlans").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().hasBody().handleBody(DrPlan.class, CreateDrPlanResponse.Builder::drPlan).handleResponseHeaderString("location", CreateDrPlanResponse.Builder::location).handleResponseHeaderString("etag", CreateDrPlanResponse.Builder::etag).handleResponseHeaderString("opc-work-request-id", CreateDrPlanResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", CreateDrPlanResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public CreateDrPlanExecutionResponse createDrPlanExecution(CreateDrPlanExecutionRequest request) {
        Objects.requireNonNull(request.getCreateDrPlanExecutionDetails(), "createDrPlanExecutionDetails is required");
        return (CreateDrPlanExecutionResponse)this.clientCall(request, CreateDrPlanExecutionResponse::builder).logger(LOG, "createDrPlanExecution").serviceDetails("DisasterRecovery", "CreateDrPlanExecution", "https://docs.oracle.com/iaas/api/#/en/disaster-recovery/20220125/DrPlanExecution/CreateDrPlanExecution").method(Method.POST).requestBuilder(CreateDrPlanExecutionRequest::builder).basePath("/20220125").appendPathParam("drPlanExecutions").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().hasBody().handleBody(DrPlanExecution.class, CreateDrPlanExecutionResponse.Builder::drPlanExecution).handleResponseHeaderString("location", CreateDrPlanExecutionResponse.Builder::location).handleResponseHeaderString("etag", CreateDrPlanExecutionResponse.Builder::etag).handleResponseHeaderString("opc-work-request-id", CreateDrPlanExecutionResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", CreateDrPlanExecutionResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public CreateDrProtectionGroupResponse createDrProtectionGroup(CreateDrProtectionGroupRequest request) {
        Objects.requireNonNull(request.getCreateDrProtectionGroupDetails(), "createDrProtectionGroupDetails is required");
        return (CreateDrProtectionGroupResponse)this.clientCall(request, CreateDrProtectionGroupResponse::builder).logger(LOG, "createDrProtectionGroup").serviceDetails("DisasterRecovery", "CreateDrProtectionGroup", "https://docs.oracle.com/iaas/api/#/en/disaster-recovery/20220125/DrProtectionGroup/CreateDrProtectionGroup").method(Method.POST).requestBuilder(CreateDrProtectionGroupRequest::builder).basePath("/20220125").appendPathParam("drProtectionGroups").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().hasBody().handleBody(DrProtectionGroup.class, CreateDrProtectionGroupResponse.Builder::drProtectionGroup).handleResponseHeaderString("location", CreateDrProtectionGroupResponse.Builder::location).handleResponseHeaderString("etag", CreateDrProtectionGroupResponse.Builder::etag).handleResponseHeaderString("opc-work-request-id", CreateDrProtectionGroupResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", CreateDrProtectionGroupResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public DeleteDrPlanResponse deleteDrPlan(DeleteDrPlanRequest request) {
        Validate.notBlank((String)request.getDrPlanId(), (String)"drPlanId must not be blank", (Object[])new Object[0]);
        return (DeleteDrPlanResponse)this.clientCall(request, DeleteDrPlanResponse::builder).logger(LOG, "deleteDrPlan").serviceDetails("DisasterRecovery", "DeleteDrPlan", "https://docs.oracle.com/iaas/api/#/en/disaster-recovery/20220125/DrPlan/DeleteDrPlan").method(Method.DELETE).requestBuilder(DeleteDrPlanRequest::builder).basePath("/20220125").appendPathParam("drPlans").appendPathParam(request.getDrPlanId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleResponseHeaderString("opc-request-id", DeleteDrPlanResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public DeleteDrPlanExecutionResponse deleteDrPlanExecution(DeleteDrPlanExecutionRequest request) {
        Validate.notBlank((String)request.getDrPlanExecutionId(), (String)"drPlanExecutionId must not be blank", (Object[])new Object[0]);
        return (DeleteDrPlanExecutionResponse)this.clientCall(request, DeleteDrPlanExecutionResponse::builder).logger(LOG, "deleteDrPlanExecution").serviceDetails("DisasterRecovery", "DeleteDrPlanExecution", "https://docs.oracle.com/iaas/api/#/en/disaster-recovery/20220125/DrPlanExecution/DeleteDrPlanExecution").method(Method.DELETE).requestBuilder(DeleteDrPlanExecutionRequest::builder).basePath("/20220125").appendPathParam("drPlanExecutions").appendPathParam(request.getDrPlanExecutionId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleResponseHeaderString("opc-work-request-id", DeleteDrPlanExecutionResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", DeleteDrPlanExecutionResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public DeleteDrProtectionGroupResponse deleteDrProtectionGroup(DeleteDrProtectionGroupRequest request) {
        Validate.notBlank((String)request.getDrProtectionGroupId(), (String)"drProtectionGroupId must not be blank", (Object[])new Object[0]);
        return (DeleteDrProtectionGroupResponse)this.clientCall(request, DeleteDrProtectionGroupResponse::builder).logger(LOG, "deleteDrProtectionGroup").serviceDetails("DisasterRecovery", "DeleteDrProtectionGroup", "https://docs.oracle.com/iaas/api/#/en/disaster-recovery/20220125/DrProtectionGroup/DeleteDrProtectionGroup").method(Method.DELETE).requestBuilder(DeleteDrProtectionGroupRequest::builder).basePath("/20220125").appendPathParam("drProtectionGroups").appendPathParam(request.getDrProtectionGroupId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleResponseHeaderString("opc-work-request-id", DeleteDrProtectionGroupResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", DeleteDrProtectionGroupResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public DisassociateDrProtectionGroupResponse disassociateDrProtectionGroup(DisassociateDrProtectionGroupRequest request) {
        Objects.requireNonNull(request.getDisassociateDrProtectionGroupDetails(), "disassociateDrProtectionGroupDetails is required");
        Validate.notBlank((String)request.getDrProtectionGroupId(), (String)"drProtectionGroupId must not be blank", (Object[])new Object[0]);
        return (DisassociateDrProtectionGroupResponse)this.clientCall(request, DisassociateDrProtectionGroupResponse::builder).logger(LOG, "disassociateDrProtectionGroup").serviceDetails("DisasterRecovery", "DisassociateDrProtectionGroup", "https://docs.oracle.com/iaas/api/#/en/disaster-recovery/20220125/DrProtectionGroup/DisassociateDrProtectionGroup").method(Method.POST).requestBuilder(DisassociateDrProtectionGroupRequest::builder).basePath("/20220125").appendPathParam("drProtectionGroups").appendPathParam(request.getDrProtectionGroupId()).appendPathParam("actions").appendPathParam("disassociate").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().hasBody().handleResponseHeaderString("opc-work-request-id", DisassociateDrProtectionGroupResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", DisassociateDrProtectionGroupResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetDrPlanResponse getDrPlan(GetDrPlanRequest request) {
        Validate.notBlank((String)request.getDrPlanId(), (String)"drPlanId must not be blank", (Object[])new Object[0]);
        return (GetDrPlanResponse)this.clientCall(request, GetDrPlanResponse::builder).logger(LOG, "getDrPlan").serviceDetails("DisasterRecovery", "GetDrPlan", "https://docs.oracle.com/iaas/api/#/en/disaster-recovery/20220125/DrPlan/GetDrPlan").method(Method.GET).requestBuilder(GetDrPlanRequest::builder).basePath("/20220125").appendPathParam("drPlans").appendPathParam(request.getDrPlanId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(DrPlan.class, GetDrPlanResponse.Builder::drPlan).handleResponseHeaderString("etag", GetDrPlanResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetDrPlanResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetDrPlanExecutionResponse getDrPlanExecution(GetDrPlanExecutionRequest request) {
        Validate.notBlank((String)request.getDrPlanExecutionId(), (String)"drPlanExecutionId must not be blank", (Object[])new Object[0]);
        return (GetDrPlanExecutionResponse)this.clientCall(request, GetDrPlanExecutionResponse::builder).logger(LOG, "getDrPlanExecution").serviceDetails("DisasterRecovery", "GetDrPlanExecution", "https://docs.oracle.com/iaas/api/#/en/disaster-recovery/20220125/DrPlanExecution/GetDrPlanExecution").method(Method.GET).requestBuilder(GetDrPlanExecutionRequest::builder).basePath("/20220125").appendPathParam("drPlanExecutions").appendPathParam(request.getDrPlanExecutionId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(DrPlanExecution.class, GetDrPlanExecutionResponse.Builder::drPlanExecution).handleResponseHeaderString("etag", GetDrPlanExecutionResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetDrPlanExecutionResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetDrProtectionGroupResponse getDrProtectionGroup(GetDrProtectionGroupRequest request) {
        Validate.notBlank((String)request.getDrProtectionGroupId(), (String)"drProtectionGroupId must not be blank", (Object[])new Object[0]);
        return (GetDrProtectionGroupResponse)this.clientCall(request, GetDrProtectionGroupResponse::builder).logger(LOG, "getDrProtectionGroup").serviceDetails("DisasterRecovery", "GetDrProtectionGroup", "https://docs.oracle.com/iaas/api/#/en/disaster-recovery/20220125/DrProtectionGroup/GetDrProtectionGroup").method(Method.GET).requestBuilder(GetDrProtectionGroupRequest::builder).basePath("/20220125").appendPathParam("drProtectionGroups").appendPathParam(request.getDrProtectionGroupId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(DrProtectionGroup.class, GetDrProtectionGroupResponse.Builder::drProtectionGroup).handleResponseHeaderString("etag", GetDrProtectionGroupResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetDrProtectionGroupResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetWorkRequestResponse getWorkRequest(GetWorkRequestRequest request) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return (GetWorkRequestResponse)this.clientCall(request, GetWorkRequestResponse::builder).logger(LOG, "getWorkRequest").serviceDetails("DisasterRecovery", "GetWorkRequest", "https://docs.oracle.com/iaas/api/#/en/disaster-recovery/20220125/WorkRequest/GetWorkRequest").method(Method.GET).requestBuilder(GetWorkRequestRequest::builder).basePath("/20220125").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(WorkRequest.class, GetWorkRequestResponse.Builder::workRequest).handleResponseHeaderString("etag", GetWorkRequestResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetWorkRequestResponse.Builder::opcRequestId).handleResponseHeaderFloat("retry-after", GetWorkRequestResponse.Builder::retryAfter).callSync();
    }

    @Override
    public IgnoreDrPlanExecutionResponse ignoreDrPlanExecution(IgnoreDrPlanExecutionRequest request) {
        Objects.requireNonNull(request.getIgnoreDrPlanExecutionDetails(), "ignoreDrPlanExecutionDetails is required");
        Validate.notBlank((String)request.getDrPlanExecutionId(), (String)"drPlanExecutionId must not be blank", (Object[])new Object[0]);
        return (IgnoreDrPlanExecutionResponse)this.clientCall(request, IgnoreDrPlanExecutionResponse::builder).logger(LOG, "ignoreDrPlanExecution").serviceDetails("DisasterRecovery", "IgnoreDrPlanExecution", "https://docs.oracle.com/iaas/api/#/en/disaster-recovery/20220125/DrPlanExecution/IgnoreDrPlanExecution").method(Method.POST).requestBuilder(IgnoreDrPlanExecutionRequest::builder).basePath("/20220125").appendPathParam("drPlanExecutions").appendPathParam(request.getDrPlanExecutionId()).appendPathParam("actions").appendPathParam("ignore").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().hasBody().handleResponseHeaderString("opc-work-request-id", IgnoreDrPlanExecutionResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", IgnoreDrPlanExecutionResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ListDrPlanExecutionsResponse listDrPlanExecutions(ListDrPlanExecutionsRequest request) {
        Objects.requireNonNull(request.getDrProtectionGroupId(), "drProtectionGroupId is required");
        return (ListDrPlanExecutionsResponse)this.clientCall(request, ListDrPlanExecutionsResponse::builder).logger(LOG, "listDrPlanExecutions").serviceDetails("DisasterRecovery", "ListDrPlanExecutions", "https://docs.oracle.com/iaas/api/#/en/disaster-recovery/20220125/DrPlanExecution/ListDrPlanExecutions").method(Method.GET).requestBuilder(ListDrPlanExecutionsRequest::builder).basePath("/20220125").appendPathParam("drPlanExecutions").appendQueryParam("drProtectionGroupId", (Object)request.getDrProtectionGroupId()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("drPlanExecutionId", (Object)request.getDrPlanExecutionId()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(DrPlanExecutionCollection.class, ListDrPlanExecutionsResponse.Builder::drPlanExecutionCollection).handleResponseHeaderString("opc-request-id", ListDrPlanExecutionsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListDrPlanExecutionsResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public ListDrPlansResponse listDrPlans(ListDrPlansRequest request) {
        Objects.requireNonNull(request.getDrProtectionGroupId(), "drProtectionGroupId is required");
        return (ListDrPlansResponse)this.clientCall(request, ListDrPlansResponse::builder).logger(LOG, "listDrPlans").serviceDetails("DisasterRecovery", "ListDrPlans", "https://docs.oracle.com/iaas/api/#/en/disaster-recovery/20220125/DrPlan/ListDrPlans").method(Method.GET).requestBuilder(ListDrPlansRequest::builder).basePath("/20220125").appendPathParam("drPlans").appendQueryParam("drProtectionGroupId", (Object)request.getDrProtectionGroupId()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("drPlanId", (Object)request.getDrPlanId()).appendEnumQueryParam("drPlanType", (BmcEnum)request.getDrPlanType()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(DrPlanCollection.class, ListDrPlansResponse.Builder::drPlanCollection).handleResponseHeaderString("opc-request-id", ListDrPlansResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListDrPlansResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public ListDrProtectionGroupsResponse listDrProtectionGroups(ListDrProtectionGroupsRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListDrProtectionGroupsResponse)this.clientCall(request, ListDrProtectionGroupsResponse::builder).logger(LOG, "listDrProtectionGroups").serviceDetails("DisasterRecovery", "ListDrProtectionGroups", "https://docs.oracle.com/iaas/api/#/en/disaster-recovery/20220125/DrProtectionGroup/ListDrProtectionGroups").method(Method.GET).requestBuilder(ListDrProtectionGroupsRequest::builder).basePath("/20220125").appendPathParam("drProtectionGroups").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("drProtectionGroupId", (Object)request.getDrProtectionGroupId()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("role", (BmcEnum)request.getRole()).appendEnumQueryParam("lifecycleSubState", (BmcEnum)request.getLifecycleSubState()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(DrProtectionGroupCollection.class, ListDrProtectionGroupsResponse.Builder::drProtectionGroupCollection).handleResponseHeaderString("opc-request-id", ListDrProtectionGroupsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListDrProtectionGroupsResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public ListWorkRequestErrorsResponse listWorkRequestErrors(ListWorkRequestErrorsRequest request) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return (ListWorkRequestErrorsResponse)this.clientCall(request, ListWorkRequestErrorsResponse::builder).logger(LOG, "listWorkRequestErrors").serviceDetails("DisasterRecovery", "ListWorkRequestErrors", "https://docs.oracle.com/iaas/api/#/en/disaster-recovery/20220125/WorkRequestError/ListWorkRequestErrors").method(Method.GET).requestBuilder(ListWorkRequestErrorsRequest::builder).basePath("/20220125").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).appendPathParam("errors").appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(WorkRequestErrorCollection.class, ListWorkRequestErrorsResponse.Builder::workRequestErrorCollection).handleResponseHeaderString("opc-next-page", ListWorkRequestErrorsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListWorkRequestErrorsResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ListWorkRequestLogsResponse listWorkRequestLogs(ListWorkRequestLogsRequest request) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return (ListWorkRequestLogsResponse)this.clientCall(request, ListWorkRequestLogsResponse::builder).logger(LOG, "listWorkRequestLogs").serviceDetails("DisasterRecovery", "ListWorkRequestLogs", "https://docs.oracle.com/iaas/api/#/en/disaster-recovery/20220125/WorkRequestLogEntry/ListWorkRequestLogs").method(Method.GET).requestBuilder(ListWorkRequestLogsRequest::builder).basePath("/20220125").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).appendPathParam("logs").appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(WorkRequestLogEntryCollection.class, ListWorkRequestLogsResponse.Builder::workRequestLogEntryCollection).handleResponseHeaderString("opc-next-page", ListWorkRequestLogsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListWorkRequestLogsResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ListWorkRequestsResponse listWorkRequests(ListWorkRequestsRequest request) {
        return (ListWorkRequestsResponse)this.clientCall(request, ListWorkRequestsResponse::builder).logger(LOG, "listWorkRequests").serviceDetails("DisasterRecovery", "ListWorkRequests", "https://docs.oracle.com/iaas/api/#/en/disaster-recovery/20220125/WorkRequest/ListWorkRequests").method(Method.GET).requestBuilder(ListWorkRequestsRequest::builder).basePath("/20220125").appendPathParam("workRequests").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("workRequestId", (Object)request.getWorkRequestId()).appendEnumQueryParam("status", (BmcEnum)request.getStatus()).appendQueryParam("resourceId", (Object)request.getResourceId()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(WorkRequestSummaryCollection.class, ListWorkRequestsResponse.Builder::workRequestSummaryCollection).handleResponseHeaderString("opc-request-id", ListWorkRequestsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListWorkRequestsResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public PauseDrPlanExecutionResponse pauseDrPlanExecution(PauseDrPlanExecutionRequest request) {
        Objects.requireNonNull(request.getPauseDrPlanExecutionDetails(), "pauseDrPlanExecutionDetails is required");
        Validate.notBlank((String)request.getDrPlanExecutionId(), (String)"drPlanExecutionId must not be blank", (Object[])new Object[0]);
        return (PauseDrPlanExecutionResponse)this.clientCall(request, PauseDrPlanExecutionResponse::builder).logger(LOG, "pauseDrPlanExecution").serviceDetails("DisasterRecovery", "PauseDrPlanExecution", "https://docs.oracle.com/iaas/api/#/en/disaster-recovery/20220125/DrPlanExecution/PauseDrPlanExecution").method(Method.POST).requestBuilder(PauseDrPlanExecutionRequest::builder).basePath("/20220125").appendPathParam("drPlanExecutions").appendPathParam(request.getDrPlanExecutionId()).appendPathParam("actions").appendPathParam("pause").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().hasBody().handleResponseHeaderString("opc-work-request-id", PauseDrPlanExecutionResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", PauseDrPlanExecutionResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ResumeDrPlanExecutionResponse resumeDrPlanExecution(ResumeDrPlanExecutionRequest request) {
        Objects.requireNonNull(request.getResumeDrPlanExecutionDetails(), "resumeDrPlanExecutionDetails is required");
        Validate.notBlank((String)request.getDrPlanExecutionId(), (String)"drPlanExecutionId must not be blank", (Object[])new Object[0]);
        return (ResumeDrPlanExecutionResponse)this.clientCall(request, ResumeDrPlanExecutionResponse::builder).logger(LOG, "resumeDrPlanExecution").serviceDetails("DisasterRecovery", "ResumeDrPlanExecution", "https://docs.oracle.com/iaas/api/#/en/disaster-recovery/20220125/DrPlanExecution/ResumeDrPlanExecution").method(Method.POST).requestBuilder(ResumeDrPlanExecutionRequest::builder).basePath("/20220125").appendPathParam("drPlanExecutions").appendPathParam(request.getDrPlanExecutionId()).appendPathParam("actions").appendPathParam("resume").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().hasBody().handleResponseHeaderString("opc-work-request-id", ResumeDrPlanExecutionResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", ResumeDrPlanExecutionResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public RetryDrPlanExecutionResponse retryDrPlanExecution(RetryDrPlanExecutionRequest request) {
        Objects.requireNonNull(request.getRetryDrPlanExecutionDetails(), "retryDrPlanExecutionDetails is required");
        Validate.notBlank((String)request.getDrPlanExecutionId(), (String)"drPlanExecutionId must not be blank", (Object[])new Object[0]);
        return (RetryDrPlanExecutionResponse)this.clientCall(request, RetryDrPlanExecutionResponse::builder).logger(LOG, "retryDrPlanExecution").serviceDetails("DisasterRecovery", "RetryDrPlanExecution", "https://docs.oracle.com/iaas/api/#/en/disaster-recovery/20220125/DrPlanExecution/RetryDrPlanExecution").method(Method.POST).requestBuilder(RetryDrPlanExecutionRequest::builder).basePath("/20220125").appendPathParam("drPlanExecutions").appendPathParam(request.getDrPlanExecutionId()).appendPathParam("actions").appendPathParam("retry").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().hasBody().handleResponseHeaderString("opc-work-request-id", RetryDrPlanExecutionResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", RetryDrPlanExecutionResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public UpdateDrPlanResponse updateDrPlan(UpdateDrPlanRequest request) {
        Objects.requireNonNull(request.getUpdateDrPlanDetails(), "updateDrPlanDetails is required");
        Validate.notBlank((String)request.getDrPlanId(), (String)"drPlanId must not be blank", (Object[])new Object[0]);
        return (UpdateDrPlanResponse)this.clientCall(request, UpdateDrPlanResponse::builder).logger(LOG, "updateDrPlan").serviceDetails("DisasterRecovery", "UpdateDrPlan", "https://docs.oracle.com/iaas/api/#/en/disaster-recovery/20220125/DrPlan/UpdateDrPlan").method(Method.PUT).requestBuilder(UpdateDrPlanRequest::builder).basePath("/20220125").appendPathParam("drPlans").appendPathParam(request.getDrPlanId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().hasBody().handleResponseHeaderString("opc-work-request-id", UpdateDrPlanResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", UpdateDrPlanResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public UpdateDrPlanExecutionResponse updateDrPlanExecution(UpdateDrPlanExecutionRequest request) {
        Objects.requireNonNull(request.getUpdateDrPlanExecutionDetails(), "updateDrPlanExecutionDetails is required");
        Validate.notBlank((String)request.getDrPlanExecutionId(), (String)"drPlanExecutionId must not be blank", (Object[])new Object[0]);
        return (UpdateDrPlanExecutionResponse)this.clientCall(request, UpdateDrPlanExecutionResponse::builder).logger(LOG, "updateDrPlanExecution").serviceDetails("DisasterRecovery", "UpdateDrPlanExecution", "https://docs.oracle.com/iaas/api/#/en/disaster-recovery/20220125/DrPlanExecution/UpdateDrPlanExecution").method(Method.PUT).requestBuilder(UpdateDrPlanExecutionRequest::builder).basePath("/20220125").appendPathParam("drPlanExecutions").appendPathParam(request.getDrPlanExecutionId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().hasBody().handleResponseHeaderString("opc-work-request-id", UpdateDrPlanExecutionResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", UpdateDrPlanExecutionResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public UpdateDrProtectionGroupResponse updateDrProtectionGroup(UpdateDrProtectionGroupRequest request) {
        Objects.requireNonNull(request.getUpdateDrProtectionGroupDetails(), "updateDrProtectionGroupDetails is required");
        Validate.notBlank((String)request.getDrProtectionGroupId(), (String)"drProtectionGroupId must not be blank", (Object[])new Object[0]);
        return (UpdateDrProtectionGroupResponse)this.clientCall(request, UpdateDrProtectionGroupResponse::builder).logger(LOG, "updateDrProtectionGroup").serviceDetails("DisasterRecovery", "UpdateDrProtectionGroup", "https://docs.oracle.com/iaas/api/#/en/disaster-recovery/20220125/DrProtectionGroup/UpdateDrProtectionGroup").method(Method.PUT).requestBuilder(UpdateDrProtectionGroupRequest::builder).basePath("/20220125").appendPathParam("drProtectionGroups").appendPathParam(request.getDrProtectionGroupId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().hasBody().handleResponseHeaderString("opc-work-request-id", UpdateDrProtectionGroupResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", UpdateDrProtectionGroupResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public UpdateDrProtectionGroupRoleResponse updateDrProtectionGroupRole(UpdateDrProtectionGroupRoleRequest request) {
        Objects.requireNonNull(request.getUpdateDrProtectionGroupRoleDetails(), "updateDrProtectionGroupRoleDetails is required");
        Validate.notBlank((String)request.getDrProtectionGroupId(), (String)"drProtectionGroupId must not be blank", (Object[])new Object[0]);
        return (UpdateDrProtectionGroupRoleResponse)this.clientCall(request, UpdateDrProtectionGroupRoleResponse::builder).logger(LOG, "updateDrProtectionGroupRole").serviceDetails("DisasterRecovery", "UpdateDrProtectionGroupRole", "https://docs.oracle.com/iaas/api/#/en/disaster-recovery/20220125/DrProtectionGroup/UpdateDrProtectionGroupRole").method(Method.POST).requestBuilder(UpdateDrProtectionGroupRoleRequest::builder).basePath("/20220125").appendPathParam("drProtectionGroups").appendPathParam(request.getDrProtectionGroupId()).appendPathParam("actions").appendPathParam("updateRole").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().hasBody().handleResponseHeaderString("opc-work-request-id", UpdateDrProtectionGroupRoleResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", UpdateDrProtectionGroupRoleResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public DisasterRecoveryWaiters getWaiters() {
        return this.waiters;
    }

    @Override
    public DisasterRecoveryPaginators getPaginators() {
        return this.paginators;
    }

    @Deprecated
    public DisasterRecoveryClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this((ClientBuilderBase<?, ?>)DisasterRecoveryClient.builder(), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public DisasterRecoveryClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(DisasterRecoveryClient.builder().configuration(configuration), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public DisasterRecoveryClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(((Builder)DisasterRecoveryClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public DisasterRecoveryClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(((Builder)((Builder)DisasterRecoveryClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory), authenticationDetailsProvider, null);
    }

    @Deprecated
    public DisasterRecoveryClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(((Builder)((Builder)((Builder)DisasterRecoveryClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators), authenticationDetailsProvider, null);
    }

    @Deprecated
    public DisasterRecoveryClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)DisasterRecoveryClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint), authenticationDetailsProvider, null);
    }

    @Deprecated
    public DisasterRecoveryClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)DisasterRecoveryClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider, null);
    }

    @Deprecated
    public DisasterRecoveryClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint, ExecutorService executorService) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)DisasterRecoveryClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider, executorService);
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, DisasterRecoveryClient> {
        private ExecutorService executorService;

        private Builder(Service service) {
            super(service);
            String packageName = "disasterrecovery";
            Alloy.throwDisabledServiceExceptionIfAppropriate((String)"disasterrecovery");
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public Builder executorService(ExecutorService executorService) {
            this.executorService = executorService;
            return this;
        }

        public DisasterRecoveryClient build(@Nonnull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            return new DisasterRecoveryClient((ClientBuilderBase<?, ?>)this, authenticationDetailsProvider, this.executorService);
        }
    }
}

