/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.disasterrecovery;

import com.oracle.bmc.disasterrecovery.DisasterRecovery;
import com.oracle.bmc.disasterrecovery.model.DrPlanExecutionLifecycleState;
import com.oracle.bmc.disasterrecovery.model.DrPlanLifecycleState;
import com.oracle.bmc.disasterrecovery.model.DrProtectionGroupLifecycleState;
import com.oracle.bmc.disasterrecovery.requests.GetDrPlanExecutionRequest;
import com.oracle.bmc.disasterrecovery.requests.GetDrPlanRequest;
import com.oracle.bmc.disasterrecovery.requests.GetDrProtectionGroupRequest;
import com.oracle.bmc.disasterrecovery.requests.GetWorkRequestRequest;
import com.oracle.bmc.disasterrecovery.responses.GetDrPlanExecutionResponse;
import com.oracle.bmc.disasterrecovery.responses.GetDrPlanResponse;
import com.oracle.bmc.disasterrecovery.responses.GetDrProtectionGroupResponse;
import com.oracle.bmc.disasterrecovery.responses.GetWorkRequestResponse;
import com.oracle.bmc.util.internal.Validate;
import com.oracle.bmc.waiter.BmcGenericWaiter;
import com.oracle.bmc.waiter.DelayStrategy;
import com.oracle.bmc.waiter.TerminationStrategy;
import com.oracle.bmc.waiter.Waiter;
import com.oracle.bmc.waiter.Waiters;
import com.oracle.bmc.waiter.internal.SimpleWaiterImpl;
import java.util.Arrays;
import java.util.HashSet;
import java.util.concurrent.ExecutorService;
import java.util.function.Function;
import java.util.function.Predicate;

public class DisasterRecoveryWaiters {
    private final ExecutorService executorService;
    private final DisasterRecovery client;

    public DisasterRecoveryWaiters(ExecutorService executorService, DisasterRecovery client) {
        this.executorService = executorService;
        this.client = client;
    }

    public Waiter<GetDrPlanRequest, GetDrPlanResponse> forDrPlan(GetDrPlanRequest request, DrPlanLifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forDrPlan(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetDrPlanRequest, GetDrPlanResponse> forDrPlan(GetDrPlanRequest request, DrPlanLifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forDrPlan(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetDrPlanRequest, GetDrPlanResponse> forDrPlan(GetDrPlanRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, DrPlanLifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forDrPlan(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetDrPlanRequest, GetDrPlanResponse> forDrPlan(BmcGenericWaiter waiter, GetDrPlanRequest request, DrPlanLifecycleState ... targetStates) {
        final HashSet<DrPlanLifecycleState> targetStatesSet = new HashSet<DrPlanLifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetDrPlanRequest, GetDrPlanResponse>(){

            @Override
            public GetDrPlanResponse apply(GetDrPlanRequest request) {
                return DisasterRecoveryWaiters.this.client.getDrPlan(request);
            }
        }, (Predicate)new Predicate<GetDrPlanResponse>(){

            @Override
            public boolean test(GetDrPlanResponse response) {
                return targetStatesSet.contains((Object)response.getDrPlan().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)DrPlanLifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetDrPlanExecutionRequest, GetDrPlanExecutionResponse> forDrPlanExecution(GetDrPlanExecutionRequest request, DrPlanExecutionLifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forDrPlanExecution(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetDrPlanExecutionRequest, GetDrPlanExecutionResponse> forDrPlanExecution(GetDrPlanExecutionRequest request, DrPlanExecutionLifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forDrPlanExecution(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetDrPlanExecutionRequest, GetDrPlanExecutionResponse> forDrPlanExecution(GetDrPlanExecutionRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, DrPlanExecutionLifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forDrPlanExecution(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetDrPlanExecutionRequest, GetDrPlanExecutionResponse> forDrPlanExecution(BmcGenericWaiter waiter, GetDrPlanExecutionRequest request, DrPlanExecutionLifecycleState ... targetStates) {
        final HashSet<DrPlanExecutionLifecycleState> targetStatesSet = new HashSet<DrPlanExecutionLifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetDrPlanExecutionRequest, GetDrPlanExecutionResponse>(){

            @Override
            public GetDrPlanExecutionResponse apply(GetDrPlanExecutionRequest request) {
                return DisasterRecoveryWaiters.this.client.getDrPlanExecution(request);
            }
        }, (Predicate)new Predicate<GetDrPlanExecutionResponse>(){

            @Override
            public boolean test(GetDrPlanExecutionResponse response) {
                return targetStatesSet.contains((Object)response.getDrPlanExecution().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)DrPlanExecutionLifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetDrProtectionGroupRequest, GetDrProtectionGroupResponse> forDrProtectionGroup(GetDrProtectionGroupRequest request, DrProtectionGroupLifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forDrProtectionGroup(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetDrProtectionGroupRequest, GetDrProtectionGroupResponse> forDrProtectionGroup(GetDrProtectionGroupRequest request, DrProtectionGroupLifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forDrProtectionGroup(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetDrProtectionGroupRequest, GetDrProtectionGroupResponse> forDrProtectionGroup(GetDrProtectionGroupRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, DrProtectionGroupLifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forDrProtectionGroup(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetDrProtectionGroupRequest, GetDrProtectionGroupResponse> forDrProtectionGroup(BmcGenericWaiter waiter, GetDrProtectionGroupRequest request, DrProtectionGroupLifecycleState ... targetStates) {
        final HashSet<DrProtectionGroupLifecycleState> targetStatesSet = new HashSet<DrProtectionGroupLifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetDrProtectionGroupRequest, GetDrProtectionGroupResponse>(){

            @Override
            public GetDrProtectionGroupResponse apply(GetDrProtectionGroupRequest request) {
                return DisasterRecoveryWaiters.this.client.getDrProtectionGroup(request);
            }
        }, (Predicate)new Predicate<GetDrProtectionGroupResponse>(){

            @Override
            public boolean test(GetDrProtectionGroupResponse response) {
                return targetStatesSet.contains((Object)response.getDrProtectionGroup().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)DrProtectionGroupLifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetWorkRequestRequest, GetWorkRequestResponse> forWorkRequest(GetWorkRequestRequest request) {
        return this.forWorkRequest(Waiters.DEFAULT_POLLING_WAITER, request);
    }

    public Waiter<GetWorkRequestRequest, GetWorkRequestResponse> forWorkRequest(GetWorkRequestRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        return this.forWorkRequest(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request);
    }

    private Waiter<GetWorkRequestRequest, GetWorkRequestResponse> forWorkRequest(BmcGenericWaiter waiter, GetWorkRequestRequest request) {
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetWorkRequestRequest, GetWorkRequestResponse>(){

            @Override
            public GetWorkRequestResponse apply(GetWorkRequestRequest request) {
                return DisasterRecoveryWaiters.this.client.getWorkRequest(request);
            }
        }, (Predicate)new Predicate<GetWorkRequestResponse>(){

            @Override
            public boolean test(GetWorkRequestResponse response) {
                return response.getWorkRequest().getTimeFinished() != null;
            }
        }, false), (Object)request);
    }
}

