/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.disasterrecovery.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.disasterrecovery.model.CreateDrProtectionGroupMemberDetails;
import com.oracle.bmc.disasterrecovery.model.LoadBalancerBackendSetMappingDetails;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="memberType")
@JsonFilter(value="explicitlySetFilter")
public final class CreateDrProtectionGroupMemberLoadBalancerDetails
extends CreateDrProtectionGroupMemberDetails {
    @JsonProperty(value="destinationLoadBalancerId")
    private final String destinationLoadBalancerId;
    @JsonProperty(value="backendSetMappings")
    private final List<LoadBalancerBackendSetMappingDetails> backendSetMappings;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public CreateDrProtectionGroupMemberLoadBalancerDetails(String memberId, String destinationLoadBalancerId, List<LoadBalancerBackendSetMappingDetails> backendSetMappings) {
        super(memberId);
        this.destinationLoadBalancerId = destinationLoadBalancerId;
        this.backendSetMappings = backendSetMappings;
    }

    public String getDestinationLoadBalancerId() {
        return this.destinationLoadBalancerId;
    }

    public List<LoadBalancerBackendSetMappingDetails> getBackendSetMappings() {
        return this.backendSetMappings;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("CreateDrProtectionGroupMemberLoadBalancerDetails(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", destinationLoadBalancerId=").append(String.valueOf(this.destinationLoadBalancerId));
        sb.append(", backendSetMappings=").append(String.valueOf(this.backendSetMappings));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CreateDrProtectionGroupMemberLoadBalancerDetails)) {
            return false;
        }
        CreateDrProtectionGroupMemberLoadBalancerDetails other = (CreateDrProtectionGroupMemberLoadBalancerDetails)((Object)o);
        return Objects.equals(this.destinationLoadBalancerId, other.destinationLoadBalancerId) && Objects.equals(this.backendSetMappings, other.backendSetMappings) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.destinationLoadBalancerId == null ? 43 : this.destinationLoadBalancerId.hashCode());
        result = result * 59 + (this.backendSetMappings == null ? 43 : this.backendSetMappings.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="memberId")
        private String memberId;
        @JsonProperty(value="destinationLoadBalancerId")
        private String destinationLoadBalancerId;
        @JsonProperty(value="backendSetMappings")
        private List<LoadBalancerBackendSetMappingDetails> backendSetMappings;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder memberId(String memberId) {
            this.memberId = memberId;
            this.__explicitlySet__.add("memberId");
            return this;
        }

        public Builder destinationLoadBalancerId(String destinationLoadBalancerId) {
            this.destinationLoadBalancerId = destinationLoadBalancerId;
            this.__explicitlySet__.add("destinationLoadBalancerId");
            return this;
        }

        public Builder backendSetMappings(List<LoadBalancerBackendSetMappingDetails> backendSetMappings) {
            this.backendSetMappings = backendSetMappings;
            this.__explicitlySet__.add("backendSetMappings");
            return this;
        }

        public CreateDrProtectionGroupMemberLoadBalancerDetails build() {
            CreateDrProtectionGroupMemberLoadBalancerDetails model = new CreateDrProtectionGroupMemberLoadBalancerDetails(this.memberId, this.destinationLoadBalancerId, this.backendSetMappings);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(CreateDrProtectionGroupMemberLoadBalancerDetails model) {
            if (model.wasPropertyExplicitlySet("memberId")) {
                this.memberId(model.getMemberId());
            }
            if (model.wasPropertyExplicitlySet("destinationLoadBalancerId")) {
                this.destinationLoadBalancerId(model.getDestinationLoadBalancerId());
            }
            if (model.wasPropertyExplicitlySet("backendSetMappings")) {
                this.backendSetMappings(model.getBackendSetMappings());
            }
            return this;
        }
    }
}

