/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.disasterrecovery.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.disasterrecovery.model.ComputeInstanceVnicMapping;
import com.oracle.bmc.disasterrecovery.model.DrProtectionGroupMember;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="memberType")
@JsonFilter(value="explicitlySetFilter")
public final class DrProtectionGroupMemberComputeInstance
extends DrProtectionGroupMember {
    @JsonProperty(value="isMovable")
    private final Boolean isMovable;
    @JsonProperty(value="vnicMapping")
    private final List<ComputeInstanceVnicMapping> vnicMapping;
    @JsonProperty(value="destinationCompartmentId")
    private final String destinationCompartmentId;
    @JsonProperty(value="destinationDedicatedVmHostId")
    private final String destinationDedicatedVmHostId;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public DrProtectionGroupMemberComputeInstance(String memberId, Boolean isMovable, List<ComputeInstanceVnicMapping> vnicMapping, String destinationCompartmentId, String destinationDedicatedVmHostId) {
        super(memberId);
        this.isMovable = isMovable;
        this.vnicMapping = vnicMapping;
        this.destinationCompartmentId = destinationCompartmentId;
        this.destinationDedicatedVmHostId = destinationDedicatedVmHostId;
    }

    public Boolean getIsMovable() {
        return this.isMovable;
    }

    public List<ComputeInstanceVnicMapping> getVnicMapping() {
        return this.vnicMapping;
    }

    public String getDestinationCompartmentId() {
        return this.destinationCompartmentId;
    }

    public String getDestinationDedicatedVmHostId() {
        return this.destinationDedicatedVmHostId;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("DrProtectionGroupMemberComputeInstance(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", isMovable=").append(String.valueOf(this.isMovable));
        sb.append(", vnicMapping=").append(String.valueOf(this.vnicMapping));
        sb.append(", destinationCompartmentId=").append(String.valueOf(this.destinationCompartmentId));
        sb.append(", destinationDedicatedVmHostId=").append(String.valueOf(this.destinationDedicatedVmHostId));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DrProtectionGroupMemberComputeInstance)) {
            return false;
        }
        DrProtectionGroupMemberComputeInstance other = (DrProtectionGroupMemberComputeInstance)((Object)o);
        return Objects.equals(this.isMovable, other.isMovable) && Objects.equals(this.vnicMapping, other.vnicMapping) && Objects.equals(this.destinationCompartmentId, other.destinationCompartmentId) && Objects.equals(this.destinationDedicatedVmHostId, other.destinationDedicatedVmHostId) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.isMovable == null ? 43 : this.isMovable.hashCode());
        result = result * 59 + (this.vnicMapping == null ? 43 : this.vnicMapping.hashCode());
        result = result * 59 + (this.destinationCompartmentId == null ? 43 : this.destinationCompartmentId.hashCode());
        result = result * 59 + (this.destinationDedicatedVmHostId == null ? 43 : this.destinationDedicatedVmHostId.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="memberId")
        private String memberId;
        @JsonProperty(value="isMovable")
        private Boolean isMovable;
        @JsonProperty(value="vnicMapping")
        private List<ComputeInstanceVnicMapping> vnicMapping;
        @JsonProperty(value="destinationCompartmentId")
        private String destinationCompartmentId;
        @JsonProperty(value="destinationDedicatedVmHostId")
        private String destinationDedicatedVmHostId;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder memberId(String memberId) {
            this.memberId = memberId;
            this.__explicitlySet__.add("memberId");
            return this;
        }

        public Builder isMovable(Boolean isMovable) {
            this.isMovable = isMovable;
            this.__explicitlySet__.add("isMovable");
            return this;
        }

        public Builder vnicMapping(List<ComputeInstanceVnicMapping> vnicMapping) {
            this.vnicMapping = vnicMapping;
            this.__explicitlySet__.add("vnicMapping");
            return this;
        }

        public Builder destinationCompartmentId(String destinationCompartmentId) {
            this.destinationCompartmentId = destinationCompartmentId;
            this.__explicitlySet__.add("destinationCompartmentId");
            return this;
        }

        public Builder destinationDedicatedVmHostId(String destinationDedicatedVmHostId) {
            this.destinationDedicatedVmHostId = destinationDedicatedVmHostId;
            this.__explicitlySet__.add("destinationDedicatedVmHostId");
            return this;
        }

        public DrProtectionGroupMemberComputeInstance build() {
            DrProtectionGroupMemberComputeInstance model = new DrProtectionGroupMemberComputeInstance(this.memberId, this.isMovable, this.vnicMapping, this.destinationCompartmentId, this.destinationDedicatedVmHostId);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(DrProtectionGroupMemberComputeInstance model) {
            if (model.wasPropertyExplicitlySet("memberId")) {
                this.memberId(model.getMemberId());
            }
            if (model.wasPropertyExplicitlySet("isMovable")) {
                this.isMovable(model.getIsMovable());
            }
            if (model.wasPropertyExplicitlySet("vnicMapping")) {
                this.vnicMapping(model.getVnicMapping());
            }
            if (model.wasPropertyExplicitlySet("destinationCompartmentId")) {
                this.destinationCompartmentId(model.getDestinationCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("destinationDedicatedVmHostId")) {
                this.destinationDedicatedVmHostId(model.getDestinationDedicatedVmHostId());
            }
            return this;
        }
    }
}

