/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.disasterrecovery.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.disasterrecovery.model.ComputeInstanceMovableFileSystemOperation;
import com.oracle.bmc.disasterrecovery.model.ComputeInstanceMovableVnicMapping;
import com.oracle.bmc.disasterrecovery.model.DrProtectionGroupMember;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="memberType")
@JsonFilter(value="explicitlySetFilter")
public final class DrProtectionGroupMemberComputeInstanceMovable
extends DrProtectionGroupMember {
    @JsonProperty(value="isRetainFaultDomain")
    private final Boolean isRetainFaultDomain;
    @JsonProperty(value="destinationCapacityReservationId")
    private final String destinationCapacityReservationId;
    @JsonProperty(value="vnicMappings")
    private final List<ComputeInstanceMovableVnicMapping> vnicMappings;
    @JsonProperty(value="destinationCompartmentId")
    private final String destinationCompartmentId;
    @JsonProperty(value="destinationDedicatedVmHostId")
    private final String destinationDedicatedVmHostId;
    @JsonProperty(value="fileSystemOperations")
    private final List<ComputeInstanceMovableFileSystemOperation> fileSystemOperations;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public DrProtectionGroupMemberComputeInstanceMovable(String memberId, Boolean isRetainFaultDomain, String destinationCapacityReservationId, List<ComputeInstanceMovableVnicMapping> vnicMappings, String destinationCompartmentId, String destinationDedicatedVmHostId, List<ComputeInstanceMovableFileSystemOperation> fileSystemOperations) {
        super(memberId);
        this.isRetainFaultDomain = isRetainFaultDomain;
        this.destinationCapacityReservationId = destinationCapacityReservationId;
        this.vnicMappings = vnicMappings;
        this.destinationCompartmentId = destinationCompartmentId;
        this.destinationDedicatedVmHostId = destinationDedicatedVmHostId;
        this.fileSystemOperations = fileSystemOperations;
    }

    public Boolean getIsRetainFaultDomain() {
        return this.isRetainFaultDomain;
    }

    public String getDestinationCapacityReservationId() {
        return this.destinationCapacityReservationId;
    }

    public List<ComputeInstanceMovableVnicMapping> getVnicMappings() {
        return this.vnicMappings;
    }

    public String getDestinationCompartmentId() {
        return this.destinationCompartmentId;
    }

    public String getDestinationDedicatedVmHostId() {
        return this.destinationDedicatedVmHostId;
    }

    public List<ComputeInstanceMovableFileSystemOperation> getFileSystemOperations() {
        return this.fileSystemOperations;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("DrProtectionGroupMemberComputeInstanceMovable(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", isRetainFaultDomain=").append(String.valueOf(this.isRetainFaultDomain));
        sb.append(", destinationCapacityReservationId=").append(String.valueOf(this.destinationCapacityReservationId));
        sb.append(", vnicMappings=").append(String.valueOf(this.vnicMappings));
        sb.append(", destinationCompartmentId=").append(String.valueOf(this.destinationCompartmentId));
        sb.append(", destinationDedicatedVmHostId=").append(String.valueOf(this.destinationDedicatedVmHostId));
        sb.append(", fileSystemOperations=").append(String.valueOf(this.fileSystemOperations));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DrProtectionGroupMemberComputeInstanceMovable)) {
            return false;
        }
        DrProtectionGroupMemberComputeInstanceMovable other = (DrProtectionGroupMemberComputeInstanceMovable)((Object)o);
        return Objects.equals(this.isRetainFaultDomain, other.isRetainFaultDomain) && Objects.equals(this.destinationCapacityReservationId, other.destinationCapacityReservationId) && Objects.equals(this.vnicMappings, other.vnicMappings) && Objects.equals(this.destinationCompartmentId, other.destinationCompartmentId) && Objects.equals(this.destinationDedicatedVmHostId, other.destinationDedicatedVmHostId) && Objects.equals(this.fileSystemOperations, other.fileSystemOperations) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.isRetainFaultDomain == null ? 43 : this.isRetainFaultDomain.hashCode());
        result = result * 59 + (this.destinationCapacityReservationId == null ? 43 : this.destinationCapacityReservationId.hashCode());
        result = result * 59 + (this.vnicMappings == null ? 43 : this.vnicMappings.hashCode());
        result = result * 59 + (this.destinationCompartmentId == null ? 43 : this.destinationCompartmentId.hashCode());
        result = result * 59 + (this.destinationDedicatedVmHostId == null ? 43 : this.destinationDedicatedVmHostId.hashCode());
        result = result * 59 + (this.fileSystemOperations == null ? 43 : this.fileSystemOperations.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="memberId")
        private String memberId;
        @JsonProperty(value="isRetainFaultDomain")
        private Boolean isRetainFaultDomain;
        @JsonProperty(value="destinationCapacityReservationId")
        private String destinationCapacityReservationId;
        @JsonProperty(value="vnicMappings")
        private List<ComputeInstanceMovableVnicMapping> vnicMappings;
        @JsonProperty(value="destinationCompartmentId")
        private String destinationCompartmentId;
        @JsonProperty(value="destinationDedicatedVmHostId")
        private String destinationDedicatedVmHostId;
        @JsonProperty(value="fileSystemOperations")
        private List<ComputeInstanceMovableFileSystemOperation> fileSystemOperations;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder memberId(String memberId) {
            this.memberId = memberId;
            this.__explicitlySet__.add("memberId");
            return this;
        }

        public Builder isRetainFaultDomain(Boolean isRetainFaultDomain) {
            this.isRetainFaultDomain = isRetainFaultDomain;
            this.__explicitlySet__.add("isRetainFaultDomain");
            return this;
        }

        public Builder destinationCapacityReservationId(String destinationCapacityReservationId) {
            this.destinationCapacityReservationId = destinationCapacityReservationId;
            this.__explicitlySet__.add("destinationCapacityReservationId");
            return this;
        }

        public Builder vnicMappings(List<ComputeInstanceMovableVnicMapping> vnicMappings) {
            this.vnicMappings = vnicMappings;
            this.__explicitlySet__.add("vnicMappings");
            return this;
        }

        public Builder destinationCompartmentId(String destinationCompartmentId) {
            this.destinationCompartmentId = destinationCompartmentId;
            this.__explicitlySet__.add("destinationCompartmentId");
            return this;
        }

        public Builder destinationDedicatedVmHostId(String destinationDedicatedVmHostId) {
            this.destinationDedicatedVmHostId = destinationDedicatedVmHostId;
            this.__explicitlySet__.add("destinationDedicatedVmHostId");
            return this;
        }

        public Builder fileSystemOperations(List<ComputeInstanceMovableFileSystemOperation> fileSystemOperations) {
            this.fileSystemOperations = fileSystemOperations;
            this.__explicitlySet__.add("fileSystemOperations");
            return this;
        }

        public DrProtectionGroupMemberComputeInstanceMovable build() {
            DrProtectionGroupMemberComputeInstanceMovable model = new DrProtectionGroupMemberComputeInstanceMovable(this.memberId, this.isRetainFaultDomain, this.destinationCapacityReservationId, this.vnicMappings, this.destinationCompartmentId, this.destinationDedicatedVmHostId, this.fileSystemOperations);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(DrProtectionGroupMemberComputeInstanceMovable model) {
            if (model.wasPropertyExplicitlySet("memberId")) {
                this.memberId(model.getMemberId());
            }
            if (model.wasPropertyExplicitlySet("isRetainFaultDomain")) {
                this.isRetainFaultDomain(model.getIsRetainFaultDomain());
            }
            if (model.wasPropertyExplicitlySet("destinationCapacityReservationId")) {
                this.destinationCapacityReservationId(model.getDestinationCapacityReservationId());
            }
            if (model.wasPropertyExplicitlySet("vnicMappings")) {
                this.vnicMappings(model.getVnicMappings());
            }
            if (model.wasPropertyExplicitlySet("destinationCompartmentId")) {
                this.destinationCompartmentId(model.getDestinationCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("destinationDedicatedVmHostId")) {
                this.destinationDedicatedVmHostId(model.getDestinationDedicatedVmHostId());
            }
            if (model.wasPropertyExplicitlySet("fileSystemOperations")) {
                this.fileSystemOperations(model.getFileSystemOperations());
            }
            return this;
        }
    }
}

