/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.disasterrecovery.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.disasterrecovery.model.FileSystemExportMappingDetails;
import com.oracle.bmc.disasterrecovery.model.UpdateDrProtectionGroupMemberDetails;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="memberType")
@JsonFilter(value="explicitlySetFilter")
public final class UpdateDrProtectionGroupMemberFileSystemDetails
extends UpdateDrProtectionGroupMemberDetails {
    @JsonProperty(value="destinationAvailabilityDomain")
    private final String destinationAvailabilityDomain;
    @JsonProperty(value="exportMappings")
    private final List<FileSystemExportMappingDetails> exportMappings;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public UpdateDrProtectionGroupMemberFileSystemDetails(String memberId, String destinationAvailabilityDomain, List<FileSystemExportMappingDetails> exportMappings) {
        super(memberId);
        this.destinationAvailabilityDomain = destinationAvailabilityDomain;
        this.exportMappings = exportMappings;
    }

    public String getDestinationAvailabilityDomain() {
        return this.destinationAvailabilityDomain;
    }

    public List<FileSystemExportMappingDetails> getExportMappings() {
        return this.exportMappings;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("UpdateDrProtectionGroupMemberFileSystemDetails(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", destinationAvailabilityDomain=").append(String.valueOf(this.destinationAvailabilityDomain));
        sb.append(", exportMappings=").append(String.valueOf(this.exportMappings));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UpdateDrProtectionGroupMemberFileSystemDetails)) {
            return false;
        }
        UpdateDrProtectionGroupMemberFileSystemDetails other = (UpdateDrProtectionGroupMemberFileSystemDetails)((Object)o);
        return Objects.equals(this.destinationAvailabilityDomain, other.destinationAvailabilityDomain) && Objects.equals(this.exportMappings, other.exportMappings) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.destinationAvailabilityDomain == null ? 43 : this.destinationAvailabilityDomain.hashCode());
        result = result * 59 + (this.exportMappings == null ? 43 : this.exportMappings.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="memberId")
        private String memberId;
        @JsonProperty(value="destinationAvailabilityDomain")
        private String destinationAvailabilityDomain;
        @JsonProperty(value="exportMappings")
        private List<FileSystemExportMappingDetails> exportMappings;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder memberId(String memberId) {
            this.memberId = memberId;
            this.__explicitlySet__.add("memberId");
            return this;
        }

        public Builder destinationAvailabilityDomain(String destinationAvailabilityDomain) {
            this.destinationAvailabilityDomain = destinationAvailabilityDomain;
            this.__explicitlySet__.add("destinationAvailabilityDomain");
            return this;
        }

        public Builder exportMappings(List<FileSystemExportMappingDetails> exportMappings) {
            this.exportMappings = exportMappings;
            this.__explicitlySet__.add("exportMappings");
            return this;
        }

        public UpdateDrProtectionGroupMemberFileSystemDetails build() {
            UpdateDrProtectionGroupMemberFileSystemDetails model = new UpdateDrProtectionGroupMemberFileSystemDetails(this.memberId, this.destinationAvailabilityDomain, this.exportMappings);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(UpdateDrProtectionGroupMemberFileSystemDetails model) {
            if (model.wasPropertyExplicitlySet("memberId")) {
                this.memberId(model.getMemberId());
            }
            if (model.wasPropertyExplicitlySet("destinationAvailabilityDomain")) {
                this.destinationAvailabilityDomain(model.getDestinationAvailabilityDomain());
            }
            if (model.wasPropertyExplicitlySet("exportMappings")) {
                this.exportMappings(model.getExportMappings());
            }
            return this;
        }
    }
}

