/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.disasterrecovery.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GetDrProtectionGroupRequest
extends BmcRequest<Void> {
    private String drProtectionGroupId;
    private String opcRequestId;

    public String getDrProtectionGroupId() {
        return this.drProtectionGroupId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().drProtectionGroupId(this.drProtectionGroupId).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",drProtectionGroupId=").append(String.valueOf(this.drProtectionGroupId));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetDrProtectionGroupRequest)) {
            return false;
        }
        GetDrProtectionGroupRequest other = (GetDrProtectionGroupRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.drProtectionGroupId, other.drProtectionGroupId) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.drProtectionGroupId == null ? 43 : this.drProtectionGroupId.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetDrProtectionGroupRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String drProtectionGroupId = null;
        private String opcRequestId = null;

        public Builder drProtectionGroupId(String drProtectionGroupId) {
            this.drProtectionGroupId = drProtectionGroupId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetDrProtectionGroupRequest o) {
            this.drProtectionGroupId(o.getDrProtectionGroupId());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetDrProtectionGroupRequest build() {
            GetDrProtectionGroupRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetDrProtectionGroupRequest buildWithoutInvocationCallback() {
            GetDrProtectionGroupRequest request = new GetDrProtectionGroupRequest();
            request.drProtectionGroupId = this.drProtectionGroupId;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

