/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dns;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.auth.RegionProvider;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.dns.Dns;
import com.oracle.bmc.dns.DnsPaginators;
import com.oracle.bmc.dns.DnsWaiters;
import com.oracle.bmc.dns.internal.http.ChangeSteeringPolicyCompartmentConverter;
import com.oracle.bmc.dns.internal.http.ChangeTsigKeyCompartmentConverter;
import com.oracle.bmc.dns.internal.http.ChangeZoneCompartmentConverter;
import com.oracle.bmc.dns.internal.http.CreateSteeringPolicyAttachmentConverter;
import com.oracle.bmc.dns.internal.http.CreateSteeringPolicyConverter;
import com.oracle.bmc.dns.internal.http.CreateTsigKeyConverter;
import com.oracle.bmc.dns.internal.http.CreateZoneConverter;
import com.oracle.bmc.dns.internal.http.DeleteDomainRecordsConverter;
import com.oracle.bmc.dns.internal.http.DeleteRRSetConverter;
import com.oracle.bmc.dns.internal.http.DeleteSteeringPolicyAttachmentConverter;
import com.oracle.bmc.dns.internal.http.DeleteSteeringPolicyConverter;
import com.oracle.bmc.dns.internal.http.DeleteTsigKeyConverter;
import com.oracle.bmc.dns.internal.http.DeleteZoneConverter;
import com.oracle.bmc.dns.internal.http.GetDomainRecordsConverter;
import com.oracle.bmc.dns.internal.http.GetRRSetConverter;
import com.oracle.bmc.dns.internal.http.GetSteeringPolicyAttachmentConverter;
import com.oracle.bmc.dns.internal.http.GetSteeringPolicyConverter;
import com.oracle.bmc.dns.internal.http.GetTsigKeyConverter;
import com.oracle.bmc.dns.internal.http.GetZoneConverter;
import com.oracle.bmc.dns.internal.http.GetZoneRecordsConverter;
import com.oracle.bmc.dns.internal.http.ListSteeringPoliciesConverter;
import com.oracle.bmc.dns.internal.http.ListSteeringPolicyAttachmentsConverter;
import com.oracle.bmc.dns.internal.http.ListTsigKeysConverter;
import com.oracle.bmc.dns.internal.http.ListZonesConverter;
import com.oracle.bmc.dns.internal.http.PatchDomainRecordsConverter;
import com.oracle.bmc.dns.internal.http.PatchRRSetConverter;
import com.oracle.bmc.dns.internal.http.PatchZoneRecordsConverter;
import com.oracle.bmc.dns.internal.http.UpdateDomainRecordsConverter;
import com.oracle.bmc.dns.internal.http.UpdateRRSetConverter;
import com.oracle.bmc.dns.internal.http.UpdateSteeringPolicyAttachmentConverter;
import com.oracle.bmc.dns.internal.http.UpdateSteeringPolicyConverter;
import com.oracle.bmc.dns.internal.http.UpdateTsigKeyConverter;
import com.oracle.bmc.dns.internal.http.UpdateZoneConverter;
import com.oracle.bmc.dns.internal.http.UpdateZoneRecordsConverter;
import com.oracle.bmc.dns.requests.ChangeSteeringPolicyCompartmentRequest;
import com.oracle.bmc.dns.requests.ChangeTsigKeyCompartmentRequest;
import com.oracle.bmc.dns.requests.ChangeZoneCompartmentRequest;
import com.oracle.bmc.dns.requests.CreateSteeringPolicyAttachmentRequest;
import com.oracle.bmc.dns.requests.CreateSteeringPolicyRequest;
import com.oracle.bmc.dns.requests.CreateTsigKeyRequest;
import com.oracle.bmc.dns.requests.CreateZoneRequest;
import com.oracle.bmc.dns.requests.DeleteDomainRecordsRequest;
import com.oracle.bmc.dns.requests.DeleteRRSetRequest;
import com.oracle.bmc.dns.requests.DeleteSteeringPolicyAttachmentRequest;
import com.oracle.bmc.dns.requests.DeleteSteeringPolicyRequest;
import com.oracle.bmc.dns.requests.DeleteTsigKeyRequest;
import com.oracle.bmc.dns.requests.DeleteZoneRequest;
import com.oracle.bmc.dns.requests.GetDomainRecordsRequest;
import com.oracle.bmc.dns.requests.GetRRSetRequest;
import com.oracle.bmc.dns.requests.GetSteeringPolicyAttachmentRequest;
import com.oracle.bmc.dns.requests.GetSteeringPolicyRequest;
import com.oracle.bmc.dns.requests.GetTsigKeyRequest;
import com.oracle.bmc.dns.requests.GetZoneRecordsRequest;
import com.oracle.bmc.dns.requests.GetZoneRequest;
import com.oracle.bmc.dns.requests.ListSteeringPoliciesRequest;
import com.oracle.bmc.dns.requests.ListSteeringPolicyAttachmentsRequest;
import com.oracle.bmc.dns.requests.ListTsigKeysRequest;
import com.oracle.bmc.dns.requests.ListZonesRequest;
import com.oracle.bmc.dns.requests.PatchDomainRecordsRequest;
import com.oracle.bmc.dns.requests.PatchRRSetRequest;
import com.oracle.bmc.dns.requests.PatchZoneRecordsRequest;
import com.oracle.bmc.dns.requests.UpdateDomainRecordsRequest;
import com.oracle.bmc.dns.requests.UpdateRRSetRequest;
import com.oracle.bmc.dns.requests.UpdateSteeringPolicyAttachmentRequest;
import com.oracle.bmc.dns.requests.UpdateSteeringPolicyRequest;
import com.oracle.bmc.dns.requests.UpdateTsigKeyRequest;
import com.oracle.bmc.dns.requests.UpdateZoneRecordsRequest;
import com.oracle.bmc.dns.requests.UpdateZoneRequest;
import com.oracle.bmc.dns.responses.ChangeSteeringPolicyCompartmentResponse;
import com.oracle.bmc.dns.responses.ChangeTsigKeyCompartmentResponse;
import com.oracle.bmc.dns.responses.ChangeZoneCompartmentResponse;
import com.oracle.bmc.dns.responses.CreateSteeringPolicyAttachmentResponse;
import com.oracle.bmc.dns.responses.CreateSteeringPolicyResponse;
import com.oracle.bmc.dns.responses.CreateTsigKeyResponse;
import com.oracle.bmc.dns.responses.CreateZoneResponse;
import com.oracle.bmc.dns.responses.DeleteDomainRecordsResponse;
import com.oracle.bmc.dns.responses.DeleteRRSetResponse;
import com.oracle.bmc.dns.responses.DeleteSteeringPolicyAttachmentResponse;
import com.oracle.bmc.dns.responses.DeleteSteeringPolicyResponse;
import com.oracle.bmc.dns.responses.DeleteTsigKeyResponse;
import com.oracle.bmc.dns.responses.DeleteZoneResponse;
import com.oracle.bmc.dns.responses.GetDomainRecordsResponse;
import com.oracle.bmc.dns.responses.GetRRSetResponse;
import com.oracle.bmc.dns.responses.GetSteeringPolicyAttachmentResponse;
import com.oracle.bmc.dns.responses.GetSteeringPolicyResponse;
import com.oracle.bmc.dns.responses.GetTsigKeyResponse;
import com.oracle.bmc.dns.responses.GetZoneRecordsResponse;
import com.oracle.bmc.dns.responses.GetZoneResponse;
import com.oracle.bmc.dns.responses.ListSteeringPoliciesResponse;
import com.oracle.bmc.dns.responses.ListSteeringPolicyAttachmentsResponse;
import com.oracle.bmc.dns.responses.ListTsigKeysResponse;
import com.oracle.bmc.dns.responses.ListZonesResponse;
import com.oracle.bmc.dns.responses.PatchDomainRecordsResponse;
import com.oracle.bmc.dns.responses.PatchRRSetResponse;
import com.oracle.bmc.dns.responses.PatchZoneRecordsResponse;
import com.oracle.bmc.dns.responses.UpdateDomainRecordsResponse;
import com.oracle.bmc.dns.responses.UpdateRRSetResponse;
import com.oracle.bmc.dns.responses.UpdateSteeringPolicyAttachmentResponse;
import com.oracle.bmc.dns.responses.UpdateSteeringPolicyResponse;
import com.oracle.bmc.dns.responses.UpdateTsigKeyResponse;
import com.oracle.bmc.dns.responses.UpdateZoneRecordsResponse;
import com.oracle.bmc.dns.responses.UpdateZoneResponse;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.RestClientFactory;
import com.oracle.bmc.http.internal.RestClientFactoryBuilder;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.signing.RequestSigner;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.BmcGenericRetrier;
import com.oracle.bmc.retrier.Retriers;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.retrier.TokenRefreshRetrier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.ws.rs.core.Response;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DnsClient
implements Dns {
    private static final Logger LOG = LoggerFactory.getLogger(DnsClient.class);
    public static final Service SERVICE = Services.serviceBuilder().serviceName("DNS").serviceEndpointPrefix("dns").serviceEndpointTemplate("https://dns.{region}.{secondLevelDomain}").build();
    private static final int MAX_IMMEDIATE_RETRIES_IF_USING_INSTANCE_PRINCIPALS = 2;
    private final DnsWaiters waiters;
    private final DnsPaginators paginators;
    private final RestClient client;
    private final AbstractAuthenticationDetailsProvider authenticationDetailsProvider;
    private final RetryConfiguration retryConfiguration;

    public DnsClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this(authenticationDetailsProvider, null);
    }

    public DnsClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(authenticationDetailsProvider, configuration, null);
    }

    public DnsClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this((AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, configuration, clientConfigurator, (RequestSignerFactory)new DefaultRequestSignerFactory(SigningStrategy.STANDARD));
    }

    public DnsClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, new ArrayList<ClientConfigurator>());
    }

    public DnsClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, additionalClientConfigurators, null);
    }

    public DnsClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, DefaultRequestSignerFactory.createDefaultRequestSignerFactories(), additionalClientConfigurators, endpoint);
    }

    public DnsClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, signingStrategyRequestSignerFactories, additionalClientConfigurators, endpoint, null);
    }

    public DnsClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint, ExecutorService executorService) {
        RegionProvider provider;
        this.authenticationDetailsProvider = authenticationDetailsProvider;
        RestClientFactory restClientFactory = RestClientFactoryBuilder.builder().clientConfigurator(clientConfigurator).additionalClientConfigurators(additionalClientConfigurators).build();
        RequestSigner defaultRequestSigner = defaultRequestSignerFactory.createRequestSigner(SERVICE, this.authenticationDetailsProvider);
        HashMap<SigningStrategy, RequestSigner> requestSigners = new HashMap<SigningStrategy, RequestSigner>();
        if (this.authenticationDetailsProvider instanceof BasicAuthenticationDetailsProvider) {
            for (SigningStrategy s : SigningStrategy.values()) {
                requestSigners.put(s, signingStrategyRequestSignerFactories.get(s).createRequestSigner(SERVICE, authenticationDetailsProvider));
            }
        }
        ClientConfiguration clientConfigurationToUse = configuration != null ? configuration : ClientConfiguration.builder().build();
        this.retryConfiguration = clientConfigurationToUse.getRetryConfiguration();
        this.client = restClientFactory.create(defaultRequestSigner, requestSigners, clientConfigurationToUse);
        if (executorService == null) {
            ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(50, 50, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new ThreadFactoryBuilder().setDaemon(true).setNameFormat("Dns-waiters-%d").build());
            threadPoolExecutor.allowCoreThreadTimeOut(true);
            executorService = threadPoolExecutor;
        }
        this.waiters = new DnsWaiters(executorService, this);
        this.paginators = new DnsPaginators(this);
        if (this.authenticationDetailsProvider instanceof RegionProvider && (provider = (RegionProvider)this.authenticationDetailsProvider).getRegion() != null) {
            this.setRegion(provider.getRegion());
            if (endpoint != null) {
                LOG.info("Authentication details provider configured for region '{}', but endpoint specifically set to '{}'. Using endpoint setting instead of region.", (Object)provider.getRegion(), (Object)endpoint);
            }
        }
        if (endpoint != null) {
            this.setEndpoint(endpoint);
        }
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setEndpoint(String endpoint) {
        LOG.info("Setting endpoint to {}", (Object)endpoint);
        this.client.setEndpoint(endpoint);
    }

    @Override
    public void setRegion(Region region) {
        Optional endpoint = region.getEndpoint(SERVICE);
        if (!endpoint.isPresent()) {
            throw new IllegalArgumentException("Endpoint for " + SERVICE + " is not known in region " + region);
        }
        this.setEndpoint((String)endpoint.get());
    }

    @Override
    public void setRegion(String regionId) {
        regionId = regionId.toLowerCase(Locale.ENGLISH);
        try {
            Region region = Region.fromRegionId((String)regionId);
            this.setRegion(region);
        }
        catch (IllegalArgumentException e) {
            LOG.info("Unknown regionId '{}', falling back to default endpoint format", (Object)regionId);
            String endpoint = Region.formatDefaultRegionEndpoint((Service)SERVICE, (String)regionId);
            this.setEndpoint(endpoint);
        }
    }

    @Override
    public void close() {
        this.client.close();
    }

    @Override
    public ChangeSteeringPolicyCompartmentResponse changeSteeringPolicyCompartment(ChangeSteeringPolicyCompartmentRequest request) {
        LOG.trace("Called changeSteeringPolicyCompartment");
        ChangeSteeringPolicyCompartmentRequest interceptedRequest = ChangeSteeringPolicyCompartmentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ChangeSteeringPolicyCompartmentConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ChangeSteeringPolicyCompartmentResponse> transformer = ChangeSteeringPolicyCompartmentConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ChangeSteeringPolicyCompartmentResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ChangeSteeringPolicyCompartmentResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getChangeSteeringPolicyCompartmentDetails(), (BmcRequest)retriedRequest);
                return (ChangeSteeringPolicyCompartmentResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ChangeTsigKeyCompartmentResponse changeTsigKeyCompartment(ChangeTsigKeyCompartmentRequest request) {
        LOG.trace("Called changeTsigKeyCompartment");
        ChangeTsigKeyCompartmentRequest interceptedRequest = ChangeTsigKeyCompartmentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ChangeTsigKeyCompartmentConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ChangeTsigKeyCompartmentResponse> transformer = ChangeTsigKeyCompartmentConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ChangeTsigKeyCompartmentResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ChangeTsigKeyCompartmentResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getChangeTsigKeyCompartmentDetails(), (BmcRequest)retriedRequest);
                return (ChangeTsigKeyCompartmentResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ChangeZoneCompartmentResponse changeZoneCompartment(ChangeZoneCompartmentRequest request) {
        LOG.trace("Called changeZoneCompartment");
        ChangeZoneCompartmentRequest interceptedRequest = ChangeZoneCompartmentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ChangeZoneCompartmentConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ChangeZoneCompartmentResponse> transformer = ChangeZoneCompartmentConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ChangeZoneCompartmentResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ChangeZoneCompartmentResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getChangeZoneCompartmentDetails(), (BmcRequest)retriedRequest);
                return (ChangeZoneCompartmentResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public CreateSteeringPolicyResponse createSteeringPolicy(CreateSteeringPolicyRequest request) {
        LOG.trace("Called createSteeringPolicy");
        CreateSteeringPolicyRequest interceptedRequest = CreateSteeringPolicyConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateSteeringPolicyConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateSteeringPolicyResponse> transformer = CreateSteeringPolicyConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (CreateSteeringPolicyResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (CreateSteeringPolicyResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getCreateSteeringPolicyDetails(), (BmcRequest)retriedRequest);
                return (CreateSteeringPolicyResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public CreateSteeringPolicyAttachmentResponse createSteeringPolicyAttachment(CreateSteeringPolicyAttachmentRequest request) {
        LOG.trace("Called createSteeringPolicyAttachment");
        CreateSteeringPolicyAttachmentRequest interceptedRequest = CreateSteeringPolicyAttachmentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateSteeringPolicyAttachmentConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateSteeringPolicyAttachmentResponse> transformer = CreateSteeringPolicyAttachmentConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (CreateSteeringPolicyAttachmentResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (CreateSteeringPolicyAttachmentResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getCreateSteeringPolicyAttachmentDetails(), (BmcRequest)retriedRequest);
                return (CreateSteeringPolicyAttachmentResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public CreateTsigKeyResponse createTsigKey(CreateTsigKeyRequest request) {
        LOG.trace("Called createTsigKey");
        CreateTsigKeyRequest interceptedRequest = CreateTsigKeyConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateTsigKeyConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateTsigKeyResponse> transformer = CreateTsigKeyConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (CreateTsigKeyResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (CreateTsigKeyResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getCreateTsigKeyDetails(), (BmcRequest)retriedRequest);
                return (CreateTsigKeyResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public CreateZoneResponse createZone(CreateZoneRequest request) {
        LOG.trace("Called createZone");
        CreateZoneRequest interceptedRequest = CreateZoneConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateZoneConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateZoneResponse> transformer = CreateZoneConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (CreateZoneResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (CreateZoneResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getCreateZoneDetails(), (BmcRequest)retriedRequest);
                return (CreateZoneResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public DeleteDomainRecordsResponse deleteDomainRecords(DeleteDomainRecordsRequest request) {
        LOG.trace("Called deleteDomainRecords");
        DeleteDomainRecordsRequest interceptedRequest = DeleteDomainRecordsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteDomainRecordsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteDomainRecordsResponse> transformer = DeleteDomainRecordsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (DeleteDomainRecordsResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (DeleteDomainRecordsResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.delete(ib, (BmcRequest)retriedRequest);
                return (DeleteDomainRecordsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public DeleteRRSetResponse deleteRRSet(DeleteRRSetRequest request) {
        LOG.trace("Called deleteRRSet");
        DeleteRRSetRequest interceptedRequest = DeleteRRSetConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteRRSetConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteRRSetResponse> transformer = DeleteRRSetConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (DeleteRRSetResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (DeleteRRSetResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.delete(ib, (BmcRequest)retriedRequest);
                return (DeleteRRSetResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public DeleteSteeringPolicyResponse deleteSteeringPolicy(DeleteSteeringPolicyRequest request) {
        LOG.trace("Called deleteSteeringPolicy");
        DeleteSteeringPolicyRequest interceptedRequest = DeleteSteeringPolicyConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteSteeringPolicyConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteSteeringPolicyResponse> transformer = DeleteSteeringPolicyConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (DeleteSteeringPolicyResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (DeleteSteeringPolicyResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.delete(ib, (BmcRequest)retriedRequest);
                return (DeleteSteeringPolicyResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public DeleteSteeringPolicyAttachmentResponse deleteSteeringPolicyAttachment(DeleteSteeringPolicyAttachmentRequest request) {
        LOG.trace("Called deleteSteeringPolicyAttachment");
        DeleteSteeringPolicyAttachmentRequest interceptedRequest = DeleteSteeringPolicyAttachmentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteSteeringPolicyAttachmentConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteSteeringPolicyAttachmentResponse> transformer = DeleteSteeringPolicyAttachmentConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (DeleteSteeringPolicyAttachmentResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (DeleteSteeringPolicyAttachmentResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.delete(ib, (BmcRequest)retriedRequest);
                return (DeleteSteeringPolicyAttachmentResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public DeleteTsigKeyResponse deleteTsigKey(DeleteTsigKeyRequest request) {
        LOG.trace("Called deleteTsigKey");
        DeleteTsigKeyRequest interceptedRequest = DeleteTsigKeyConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteTsigKeyConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteTsigKeyResponse> transformer = DeleteTsigKeyConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (DeleteTsigKeyResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (DeleteTsigKeyResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.delete(ib, (BmcRequest)retriedRequest);
                return (DeleteTsigKeyResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public DeleteZoneResponse deleteZone(DeleteZoneRequest request) {
        LOG.trace("Called deleteZone");
        DeleteZoneRequest interceptedRequest = DeleteZoneConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteZoneConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteZoneResponse> transformer = DeleteZoneConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (DeleteZoneResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (DeleteZoneResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.delete(ib, (BmcRequest)retriedRequest);
                return (DeleteZoneResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetDomainRecordsResponse getDomainRecords(GetDomainRecordsRequest request) {
        LOG.trace("Called getDomainRecords");
        GetDomainRecordsRequest interceptedRequest = GetDomainRecordsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetDomainRecordsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetDomainRecordsResponse> transformer = GetDomainRecordsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (GetDomainRecordsResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetDomainRecordsResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetDomainRecordsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetRRSetResponse getRRSet(GetRRSetRequest request) {
        LOG.trace("Called getRRSet");
        GetRRSetRequest interceptedRequest = GetRRSetConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetRRSetConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetRRSetResponse> transformer = GetRRSetConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (GetRRSetResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetRRSetResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetRRSetResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetSteeringPolicyResponse getSteeringPolicy(GetSteeringPolicyRequest request) {
        LOG.trace("Called getSteeringPolicy");
        GetSteeringPolicyRequest interceptedRequest = GetSteeringPolicyConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetSteeringPolicyConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetSteeringPolicyResponse> transformer = GetSteeringPolicyConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (GetSteeringPolicyResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetSteeringPolicyResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetSteeringPolicyResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetSteeringPolicyAttachmentResponse getSteeringPolicyAttachment(GetSteeringPolicyAttachmentRequest request) {
        LOG.trace("Called getSteeringPolicyAttachment");
        GetSteeringPolicyAttachmentRequest interceptedRequest = GetSteeringPolicyAttachmentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetSteeringPolicyAttachmentConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetSteeringPolicyAttachmentResponse> transformer = GetSteeringPolicyAttachmentConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (GetSteeringPolicyAttachmentResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetSteeringPolicyAttachmentResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetSteeringPolicyAttachmentResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetTsigKeyResponse getTsigKey(GetTsigKeyRequest request) {
        LOG.trace("Called getTsigKey");
        GetTsigKeyRequest interceptedRequest = GetTsigKeyConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetTsigKeyConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetTsigKeyResponse> transformer = GetTsigKeyConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (GetTsigKeyResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetTsigKeyResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetTsigKeyResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetZoneResponse getZone(GetZoneRequest request) {
        LOG.trace("Called getZone");
        GetZoneRequest interceptedRequest = GetZoneConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetZoneConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetZoneResponse> transformer = GetZoneConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (GetZoneResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetZoneResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetZoneResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetZoneRecordsResponse getZoneRecords(GetZoneRecordsRequest request) {
        LOG.trace("Called getZoneRecords");
        GetZoneRecordsRequest interceptedRequest = GetZoneRecordsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetZoneRecordsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetZoneRecordsResponse> transformer = GetZoneRecordsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (GetZoneRecordsResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetZoneRecordsResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetZoneRecordsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListSteeringPoliciesResponse listSteeringPolicies(ListSteeringPoliciesRequest request) {
        LOG.trace("Called listSteeringPolicies");
        ListSteeringPoliciesRequest interceptedRequest = ListSteeringPoliciesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListSteeringPoliciesConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListSteeringPoliciesResponse> transformer = ListSteeringPoliciesConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListSteeringPoliciesResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListSteeringPoliciesResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListSteeringPoliciesResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListSteeringPolicyAttachmentsResponse listSteeringPolicyAttachments(ListSteeringPolicyAttachmentsRequest request) {
        LOG.trace("Called listSteeringPolicyAttachments");
        ListSteeringPolicyAttachmentsRequest interceptedRequest = ListSteeringPolicyAttachmentsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListSteeringPolicyAttachmentsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListSteeringPolicyAttachmentsResponse> transformer = ListSteeringPolicyAttachmentsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListSteeringPolicyAttachmentsResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListSteeringPolicyAttachmentsResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListSteeringPolicyAttachmentsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListTsigKeysResponse listTsigKeys(ListTsigKeysRequest request) {
        LOG.trace("Called listTsigKeys");
        ListTsigKeysRequest interceptedRequest = ListTsigKeysConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListTsigKeysConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListTsigKeysResponse> transformer = ListTsigKeysConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListTsigKeysResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListTsigKeysResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListTsigKeysResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListZonesResponse listZones(ListZonesRequest request) {
        LOG.trace("Called listZones");
        ListZonesRequest interceptedRequest = ListZonesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListZonesConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListZonesResponse> transformer = ListZonesConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListZonesResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListZonesResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListZonesResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public PatchDomainRecordsResponse patchDomainRecords(PatchDomainRecordsRequest request) {
        LOG.trace("Called patchDomainRecords");
        PatchDomainRecordsRequest interceptedRequest = PatchDomainRecordsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = PatchDomainRecordsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, PatchDomainRecordsResponse> transformer = PatchDomainRecordsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (PatchDomainRecordsResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (PatchDomainRecordsResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.patch(ib, (Object)retriedRequest.getPatchDomainRecordsDetails(), (BmcRequest)retriedRequest);
                return (PatchDomainRecordsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public PatchRRSetResponse patchRRSet(PatchRRSetRequest request) {
        LOG.trace("Called patchRRSet");
        PatchRRSetRequest interceptedRequest = PatchRRSetConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = PatchRRSetConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, PatchRRSetResponse> transformer = PatchRRSetConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (PatchRRSetResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (PatchRRSetResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.patch(ib, (Object)retriedRequest.getPatchRRSetDetails(), (BmcRequest)retriedRequest);
                return (PatchRRSetResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public PatchZoneRecordsResponse patchZoneRecords(PatchZoneRecordsRequest request) {
        LOG.trace("Called patchZoneRecords");
        PatchZoneRecordsRequest interceptedRequest = PatchZoneRecordsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = PatchZoneRecordsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, PatchZoneRecordsResponse> transformer = PatchZoneRecordsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (PatchZoneRecordsResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (PatchZoneRecordsResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.patch(ib, (Object)retriedRequest.getPatchZoneRecordsDetails(), (BmcRequest)retriedRequest);
                return (PatchZoneRecordsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public UpdateDomainRecordsResponse updateDomainRecords(UpdateDomainRecordsRequest request) {
        LOG.trace("Called updateDomainRecords");
        UpdateDomainRecordsRequest interceptedRequest = UpdateDomainRecordsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateDomainRecordsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateDomainRecordsResponse> transformer = UpdateDomainRecordsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (UpdateDomainRecordsResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (UpdateDomainRecordsResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.put(ib, (Object)retriedRequest.getUpdateDomainRecordsDetails(), (BmcRequest)retriedRequest);
                return (UpdateDomainRecordsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public UpdateRRSetResponse updateRRSet(UpdateRRSetRequest request) {
        LOG.trace("Called updateRRSet");
        UpdateRRSetRequest interceptedRequest = UpdateRRSetConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateRRSetConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateRRSetResponse> transformer = UpdateRRSetConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (UpdateRRSetResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (UpdateRRSetResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.put(ib, (Object)retriedRequest.getUpdateRRSetDetails(), (BmcRequest)retriedRequest);
                return (UpdateRRSetResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public UpdateSteeringPolicyResponse updateSteeringPolicy(UpdateSteeringPolicyRequest request) {
        LOG.trace("Called updateSteeringPolicy");
        UpdateSteeringPolicyRequest interceptedRequest = UpdateSteeringPolicyConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateSteeringPolicyConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateSteeringPolicyResponse> transformer = UpdateSteeringPolicyConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (UpdateSteeringPolicyResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (UpdateSteeringPolicyResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.put(ib, (Object)retriedRequest.getUpdateSteeringPolicyDetails(), (BmcRequest)retriedRequest);
                return (UpdateSteeringPolicyResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public UpdateSteeringPolicyAttachmentResponse updateSteeringPolicyAttachment(UpdateSteeringPolicyAttachmentRequest request) {
        LOG.trace("Called updateSteeringPolicyAttachment");
        UpdateSteeringPolicyAttachmentRequest interceptedRequest = UpdateSteeringPolicyAttachmentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateSteeringPolicyAttachmentConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateSteeringPolicyAttachmentResponse> transformer = UpdateSteeringPolicyAttachmentConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (UpdateSteeringPolicyAttachmentResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (UpdateSteeringPolicyAttachmentResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.put(ib, (Object)retriedRequest.getUpdateSteeringPolicyAttachmentDetails(), (BmcRequest)retriedRequest);
                return (UpdateSteeringPolicyAttachmentResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public UpdateTsigKeyResponse updateTsigKey(UpdateTsigKeyRequest request) {
        LOG.trace("Called updateTsigKey");
        UpdateTsigKeyRequest interceptedRequest = UpdateTsigKeyConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateTsigKeyConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateTsigKeyResponse> transformer = UpdateTsigKeyConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (UpdateTsigKeyResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (UpdateTsigKeyResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.put(ib, (Object)retriedRequest.getUpdateTsigKeyDetails(), (BmcRequest)retriedRequest);
                return (UpdateTsigKeyResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public UpdateZoneResponse updateZone(UpdateZoneRequest request) {
        LOG.trace("Called updateZone");
        UpdateZoneRequest interceptedRequest = UpdateZoneConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateZoneConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateZoneResponse> transformer = UpdateZoneConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (UpdateZoneResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (UpdateZoneResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.put(ib, (Object)retriedRequest.getUpdateZoneDetails(), (BmcRequest)retriedRequest);
                return (UpdateZoneResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public UpdateZoneRecordsResponse updateZoneRecords(UpdateZoneRecordsRequest request) {
        LOG.trace("Called updateZoneRecords");
        UpdateZoneRecordsRequest interceptedRequest = UpdateZoneRecordsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateZoneRecordsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateZoneRecordsResponse> transformer = UpdateZoneRecordsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (UpdateZoneRecordsResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (UpdateZoneRecordsResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.put(ib, (Object)retriedRequest.getUpdateZoneRecordsDetails(), (BmcRequest)retriedRequest);
                return (UpdateZoneRecordsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public DnsWaiters getWaiters() {
        return this.waiters;
    }

    @Override
    public DnsPaginators getPaginators() {
        return this.paginators;
    }

    RestClient getClient() {
        return this.client;
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, DnsClient> {
        private ExecutorService executorService;

        private Builder(Service service) {
            super(service);
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public Builder executorService(ExecutorService executorService) {
            this.executorService = executorService;
            return this;
        }

        public DnsClient build(@NonNull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            if (authenticationDetailsProvider == null) {
                throw new NullPointerException("authenticationDetailsProvider is marked @NonNull but is null");
            }
            return new DnsClient(authenticationDetailsProvider, this.configuration, this.clientConfigurator, this.requestSignerFactory, this.signingStrategyRequestSignerFactories, this.additionalClientConfigurators, this.endpoint, this.executorService);
        }
    }
}

