/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dns.internal.http;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.dns.model.SteeringPolicyAttachmentSummary;
import com.oracle.bmc.dns.requests.ListSteeringPolicyAttachmentsRequest;
import com.oracle.bmc.dns.responses.ListSteeringPolicyAttachmentsResponse;
import com.oracle.bmc.http.internal.HeaderUtils;
import com.oracle.bmc.http.internal.ResponseConversionFunctionFactory;
import com.oracle.bmc.http.internal.ResponseHelper;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.WithHeaders;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.internal.WrappedWebTarget;
import com.oracle.bmc.util.internal.HttpUtils;
import java.util.List;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ListSteeringPolicyAttachmentsConverter {
    private static final Logger LOG = LoggerFactory.getLogger(ListSteeringPolicyAttachmentsConverter.class);
    private static final ResponseConversionFunctionFactory RESPONSE_CONVERSION_FACTORY = new ResponseConversionFunctionFactory();

    public static ListSteeringPolicyAttachmentsRequest interceptRequest(ListSteeringPolicyAttachmentsRequest request) {
        return request;
    }

    public static WrappedInvocationBuilder fromRequest(RestClient client, ListSteeringPolicyAttachmentsRequest request) {
        Validate.notNull((Object)((Object)request), (String)"request instance is required", (Object[])new Object[0]);
        Validate.notNull((Object)request.getCompartmentId(), (String)"compartmentId is required", (Object[])new Object[0]);
        WrappedWebTarget target = client.getBaseTarget().path("/20180115").path("steeringPolicyAttachments");
        if (request.getLimit() != null) {
            target = target.queryParam("limit", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getLimit())});
        }
        if (request.getPage() != null) {
            target = target.queryParam("page", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getPage())});
        }
        target = target.queryParam("compartmentId", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getCompartmentId())});
        if (request.getId() != null) {
            target = target.queryParam("id", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getId())});
        }
        if (request.getDisplayName() != null) {
            target = target.queryParam("displayName", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getDisplayName())});
        }
        if (request.getSteeringPolicyId() != null) {
            target = target.queryParam("steeringPolicyId", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getSteeringPolicyId())});
        }
        if (request.getZoneId() != null) {
            target = target.queryParam("zoneId", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getZoneId())});
        }
        if (request.getDomain() != null) {
            target = target.queryParam("domain", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getDomain())});
        }
        if (request.getDomainContains() != null) {
            target = target.queryParam("domainContains", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getDomainContains())});
        }
        if (request.getTimeCreatedGreaterThanOrEqualTo() != null) {
            target = target.queryParam("timeCreatedGreaterThanOrEqualTo", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getTimeCreatedGreaterThanOrEqualTo())});
        }
        if (request.getTimeCreatedLessThan() != null) {
            target = target.queryParam("timeCreatedLessThan", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getTimeCreatedLessThan())});
        }
        if (request.getLifecycleState() != null) {
            target = target.queryParam("lifecycleState", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getLifecycleState().getValue())});
        }
        if (request.getSortBy() != null) {
            target = target.queryParam("sortBy", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getSortBy().getValue())});
        }
        if (request.getSortOrder() != null) {
            target = target.queryParam("sortOrder", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getSortOrder().getValue())});
        }
        WrappedInvocationBuilder ib = target.request();
        ib.accept(new String[]{"application/json"});
        if (request.getOpcRequestId() != null) {
            ib.header("opc-request-id", (Object)request.getOpcRequestId());
        }
        return ib;
    }

    public static Function<Response, ListSteeringPolicyAttachmentsResponse> fromResponse() {
        Function<Response, ListSteeringPolicyAttachmentsResponse> transformer = new Function<Response, ListSteeringPolicyAttachmentsResponse>(){

            public ListSteeringPolicyAttachmentsResponse apply(Response rawResponse) {
                Optional opcRequestIdHeader;
                Optional opcTotalItemsHeader;
                LOG.trace("Transform function invoked for ListSteeringPolicyAttachmentsResponse");
                Function responseFn = RESPONSE_CONVERSION_FACTORY.create((GenericType)new GenericType<List<SteeringPolicyAttachmentSummary>>(){});
                WithHeaders response = (WithHeaders)responseFn.apply((Object)rawResponse);
                MultivaluedMap headers = response.getHeaders();
                ListSteeringPolicyAttachmentsResponse.Builder builder = ListSteeringPolicyAttachmentsResponse.builder();
                builder.items((List)response.getItem());
                Optional opcNextPageHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"opc-next-page");
                if (opcNextPageHeader.isPresent()) {
                    builder.opcNextPage((String)HeaderUtils.toValue((String)"opc-next-page", (String)((String)((List)opcNextPageHeader.get()).get(0)), String.class));
                }
                if ((opcTotalItemsHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"opc-total-items")).isPresent()) {
                    builder.opcTotalItems((Integer)HeaderUtils.toValue((String)"opc-total-items", (String)((String)((List)opcTotalItemsHeader.get()).get(0)), Integer.class));
                }
                if ((opcRequestIdHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"opc-request-id")).isPresent()) {
                    builder.opcRequestId((String)HeaderUtils.toValue((String)"opc-request-id", (String)((String)((List)opcRequestIdHeader.get()).get(0)), String.class));
                }
                ListSteeringPolicyAttachmentsResponse responseWrapper = builder.build();
                ResponseHelper.closeResponseSilentlyIfNotBuffered((Response)rawResponse);
                return responseWrapper;
            }
        };
        return transformer;
    }
}

