/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dns.internal.http;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.dns.model.SteeringPolicyAttachment;
import com.oracle.bmc.dns.requests.UpdateSteeringPolicyAttachmentRequest;
import com.oracle.bmc.dns.responses.UpdateSteeringPolicyAttachmentResponse;
import com.oracle.bmc.http.internal.HeaderUtils;
import com.oracle.bmc.http.internal.ResponseConversionFunctionFactory;
import com.oracle.bmc.http.internal.ResponseHelper;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.WithHeaders;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.internal.WrappedWebTarget;
import com.oracle.bmc.util.internal.HttpUtils;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpdateSteeringPolicyAttachmentConverter {
    private static final Logger LOG = LoggerFactory.getLogger(UpdateSteeringPolicyAttachmentConverter.class);
    private static final ResponseConversionFunctionFactory RESPONSE_CONVERSION_FACTORY = new ResponseConversionFunctionFactory();

    public static UpdateSteeringPolicyAttachmentRequest interceptRequest(UpdateSteeringPolicyAttachmentRequest request) {
        return request;
    }

    public static WrappedInvocationBuilder fromRequest(RestClient client, UpdateSteeringPolicyAttachmentRequest request) {
        Validate.notNull((Object)((Object)request), (String)"request instance is required", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)request.getSteeringPolicyAttachmentId(), (String)"steeringPolicyAttachmentId must not be blank", (Object[])new Object[0]);
        Validate.notNull((Object)request.getUpdateSteeringPolicyAttachmentDetails(), (String)"updateSteeringPolicyAttachmentDetails is required", (Object[])new Object[0]);
        WrappedWebTarget target = client.getBaseTarget().path("/20180115").path("steeringPolicyAttachments").path(HttpUtils.encodePathSegment((String)request.getSteeringPolicyAttachmentId()));
        WrappedInvocationBuilder ib = target.request();
        ib.accept(new String[]{"application/json"});
        if (request.getIfMatch() != null) {
            ib.header("If-Match", (Object)request.getIfMatch());
        }
        if (request.getIfUnmodifiedSince() != null) {
            ib.header("If-Unmodified-Since", (Object)request.getIfUnmodifiedSince());
        }
        if (request.getOpcRequestId() != null) {
            ib.header("opc-request-id", (Object)request.getOpcRequestId());
        }
        return ib;
    }

    public static Function<Response, UpdateSteeringPolicyAttachmentResponse> fromResponse() {
        Function<Response, UpdateSteeringPolicyAttachmentResponse> transformer = new Function<Response, UpdateSteeringPolicyAttachmentResponse>(){

            public UpdateSteeringPolicyAttachmentResponse apply(Response rawResponse) {
                Optional eTagHeader;
                LOG.trace("Transform function invoked for UpdateSteeringPolicyAttachmentResponse");
                Function responseFn = RESPONSE_CONVERSION_FACTORY.create(SteeringPolicyAttachment.class);
                WithHeaders response = (WithHeaders)responseFn.apply((Object)rawResponse);
                MultivaluedMap headers = response.getHeaders();
                UpdateSteeringPolicyAttachmentResponse.Builder builder = UpdateSteeringPolicyAttachmentResponse.builder();
                builder.steeringPolicyAttachment((SteeringPolicyAttachment)response.getItem());
                Optional opcRequestIdHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"opc-request-id");
                if (opcRequestIdHeader.isPresent()) {
                    builder.opcRequestId((String)HeaderUtils.toValue((String)"opc-request-id", (String)((String)((List)opcRequestIdHeader.get()).get(0)), String.class));
                }
                if ((eTagHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"ETag")).isPresent()) {
                    builder.eTag((String)HeaderUtils.toValue((String)"ETag", (String)((String)((List)eTagHeader.get()).get(0)), String.class));
                }
                UpdateSteeringPolicyAttachmentResponse responseWrapper = builder.build();
                ResponseHelper.closeResponseSilentlyIfNotBuffered((Response)rawResponse);
                return responseWrapper;
            }
        };
        return transformer;
    }
}

