/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dns.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class DeleteRRSetRequest
extends BmcRequest {
    private String zoneNameOrId;
    private String domain;
    private String rtype;
    private String ifMatch;
    private String ifUnmodifiedSince;
    private String opcRequestId;
    private String compartmentId;

    @ConstructorProperties(value={"zoneNameOrId", "domain", "rtype", "ifMatch", "ifUnmodifiedSince", "opcRequestId", "compartmentId"})
    DeleteRRSetRequest(String zoneNameOrId, String domain, String rtype, String ifMatch, String ifUnmodifiedSince, String opcRequestId, String compartmentId) {
        this.zoneNameOrId = zoneNameOrId;
        this.domain = domain;
        this.rtype = rtype;
        this.ifMatch = ifMatch;
        this.ifUnmodifiedSince = ifUnmodifiedSince;
        this.opcRequestId = opcRequestId;
        this.compartmentId = compartmentId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getZoneNameOrId() {
        return this.zoneNameOrId;
    }

    public String getDomain() {
        return this.domain;
    }

    public String getRtype() {
        return this.rtype;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public String getIfUnmodifiedSince() {
        return this.ifUnmodifiedSince;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public static class Builder {
        private String zoneNameOrId;
        private String domain;
        private String rtype;
        private String ifMatch;
        private String ifUnmodifiedSince;
        private String opcRequestId;
        private String compartmentId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(DeleteRRSetRequest o) {
            this.zoneNameOrId(o.getZoneNameOrId());
            this.domain(o.getDomain());
            this.rtype(o.getRtype());
            this.ifMatch(o.getIfMatch());
            this.ifUnmodifiedSince(o.getIfUnmodifiedSince());
            this.opcRequestId(o.getOpcRequestId());
            this.compartmentId(o.getCompartmentId());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public DeleteRRSetRequest build() {
            DeleteRRSetRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder zoneNameOrId(String zoneNameOrId) {
            this.zoneNameOrId = zoneNameOrId;
            return this;
        }

        public Builder domain(String domain) {
            this.domain = domain;
            return this;
        }

        public Builder rtype(String rtype) {
            this.rtype = rtype;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder ifUnmodifiedSince(String ifUnmodifiedSince) {
            this.ifUnmodifiedSince = ifUnmodifiedSince;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            return this;
        }

        public DeleteRRSetRequest buildWithoutInvocationCallback() {
            return new DeleteRRSetRequest(this.zoneNameOrId, this.domain, this.rtype, this.ifMatch, this.ifUnmodifiedSince, this.opcRequestId, this.compartmentId);
        }

        public String toString() {
            return "DeleteRRSetRequest.Builder(zoneNameOrId=" + this.zoneNameOrId + ", domain=" + this.domain + ", rtype=" + this.rtype + ", ifMatch=" + this.ifMatch + ", ifUnmodifiedSince=" + this.ifUnmodifiedSince + ", opcRequestId=" + this.opcRequestId + ", compartmentId=" + this.compartmentId + ")";
        }
    }
}

