/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dns.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.dns.model.SortOrder;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.client.Invocation;

public class GetZoneRecordsRequest
extends BmcRequest {
    private String zoneNameOrId;
    private String ifNoneMatch;
    private String ifModifiedSince;
    private String opcRequestId;
    private Long limit;
    private String page;
    private String zoneVersion;
    private String domain;
    private String domainContains;
    private String rtype;
    private SortBy sortBy;
    private SortOrder sortOrder;
    private String compartmentId;

    @ConstructorProperties(value={"zoneNameOrId", "ifNoneMatch", "ifModifiedSince", "opcRequestId", "limit", "page", "zoneVersion", "domain", "domainContains", "rtype", "sortBy", "sortOrder", "compartmentId"})
    GetZoneRecordsRequest(String zoneNameOrId, String ifNoneMatch, String ifModifiedSince, String opcRequestId, Long limit, String page, String zoneVersion, String domain, String domainContains, String rtype, SortBy sortBy, SortOrder sortOrder, String compartmentId) {
        this.zoneNameOrId = zoneNameOrId;
        this.ifNoneMatch = ifNoneMatch;
        this.ifModifiedSince = ifModifiedSince;
        this.opcRequestId = opcRequestId;
        this.limit = limit;
        this.page = page;
        this.zoneVersion = zoneVersion;
        this.domain = domain;
        this.domainContains = domainContains;
        this.rtype = rtype;
        this.sortBy = sortBy;
        this.sortOrder = sortOrder;
        this.compartmentId = compartmentId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getZoneNameOrId() {
        return this.zoneNameOrId;
    }

    public String getIfNoneMatch() {
        return this.ifNoneMatch;
    }

    public String getIfModifiedSince() {
        return this.ifModifiedSince;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Long getLimit() {
        return this.limit;
    }

    public String getPage() {
        return this.page;
    }

    public String getZoneVersion() {
        return this.zoneVersion;
    }

    public String getDomain() {
        return this.domain;
    }

    public String getDomainContains() {
        return this.domainContains;
    }

    public String getRtype() {
        return this.rtype;
    }

    public SortBy getSortBy() {
        return this.sortBy;
    }

    public SortOrder getSortOrder() {
        return this.sortOrder;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public static class Builder {
        private String zoneNameOrId;
        private String ifNoneMatch;
        private String ifModifiedSince;
        private String opcRequestId;
        private Long limit;
        private String page;
        private String zoneVersion;
        private String domain;
        private String domainContains;
        private String rtype;
        private SortBy sortBy;
        private SortOrder sortOrder;
        private String compartmentId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetZoneRecordsRequest o) {
            this.zoneNameOrId(o.getZoneNameOrId());
            this.ifNoneMatch(o.getIfNoneMatch());
            this.ifModifiedSince(o.getIfModifiedSince());
            this.opcRequestId(o.getOpcRequestId());
            this.limit(o.getLimit());
            this.page(o.getPage());
            this.zoneVersion(o.getZoneVersion());
            this.domain(o.getDomain());
            this.domainContains(o.getDomainContains());
            this.rtype(o.getRtype());
            this.sortBy(o.getSortBy());
            this.sortOrder(o.getSortOrder());
            this.compartmentId(o.getCompartmentId());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetZoneRecordsRequest build() {
            GetZoneRecordsRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder zoneNameOrId(String zoneNameOrId) {
            this.zoneNameOrId = zoneNameOrId;
            return this;
        }

        public Builder ifNoneMatch(String ifNoneMatch) {
            this.ifNoneMatch = ifNoneMatch;
            return this;
        }

        public Builder ifModifiedSince(String ifModifiedSince) {
            this.ifModifiedSince = ifModifiedSince;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder limit(Long limit) {
            this.limit = limit;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder zoneVersion(String zoneVersion) {
            this.zoneVersion = zoneVersion;
            return this;
        }

        public Builder domain(String domain) {
            this.domain = domain;
            return this;
        }

        public Builder domainContains(String domainContains) {
            this.domainContains = domainContains;
            return this;
        }

        public Builder rtype(String rtype) {
            this.rtype = rtype;
            return this;
        }

        public Builder sortBy(SortBy sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        public Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            return this;
        }

        public GetZoneRecordsRequest buildWithoutInvocationCallback() {
            return new GetZoneRecordsRequest(this.zoneNameOrId, this.ifNoneMatch, this.ifModifiedSince, this.opcRequestId, this.limit, this.page, this.zoneVersion, this.domain, this.domainContains, this.rtype, this.sortBy, this.sortOrder, this.compartmentId);
        }

        public String toString() {
            return "GetZoneRecordsRequest.Builder(zoneNameOrId=" + this.zoneNameOrId + ", ifNoneMatch=" + this.ifNoneMatch + ", ifModifiedSince=" + this.ifModifiedSince + ", opcRequestId=" + this.opcRequestId + ", limit=" + this.limit + ", page=" + this.page + ", zoneVersion=" + this.zoneVersion + ", domain=" + this.domain + ", domainContains=" + this.domainContains + ", rtype=" + this.rtype + ", sortBy=" + (Object)((Object)this.sortBy) + ", sortOrder=" + (Object)((Object)this.sortOrder) + ", compartmentId=" + this.compartmentId + ")";
        }
    }

    public static enum SortBy {
        Domain("domain"),
        Rtype("rtype"),
        Ttl("ttl");

        private final String value;
        private static Map<String, SortBy> map;

        private SortBy(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortBy create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new RuntimeException("Invalid SortBy: " + key);
        }

        static {
            map = new HashMap<String, SortBy>();
            for (SortBy v : SortBy.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

