/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dns.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class GetZoneRequest
extends BmcRequest {
    private String zoneNameOrId;
    private String ifNoneMatch;
    private String ifModifiedSince;
    private String opcRequestId;
    private String compartmentId;

    @ConstructorProperties(value={"zoneNameOrId", "ifNoneMatch", "ifModifiedSince", "opcRequestId", "compartmentId"})
    GetZoneRequest(String zoneNameOrId, String ifNoneMatch, String ifModifiedSince, String opcRequestId, String compartmentId) {
        this.zoneNameOrId = zoneNameOrId;
        this.ifNoneMatch = ifNoneMatch;
        this.ifModifiedSince = ifModifiedSince;
        this.opcRequestId = opcRequestId;
        this.compartmentId = compartmentId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getZoneNameOrId() {
        return this.zoneNameOrId;
    }

    public String getIfNoneMatch() {
        return this.ifNoneMatch;
    }

    public String getIfModifiedSince() {
        return this.ifModifiedSince;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public static class Builder {
        private String zoneNameOrId;
        private String ifNoneMatch;
        private String ifModifiedSince;
        private String opcRequestId;
        private String compartmentId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetZoneRequest o) {
            this.zoneNameOrId(o.getZoneNameOrId());
            this.ifNoneMatch(o.getIfNoneMatch());
            this.ifModifiedSince(o.getIfModifiedSince());
            this.opcRequestId(o.getOpcRequestId());
            this.compartmentId(o.getCompartmentId());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetZoneRequest build() {
            GetZoneRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder zoneNameOrId(String zoneNameOrId) {
            this.zoneNameOrId = zoneNameOrId;
            return this;
        }

        public Builder ifNoneMatch(String ifNoneMatch) {
            this.ifNoneMatch = ifNoneMatch;
            return this;
        }

        public Builder ifModifiedSince(String ifModifiedSince) {
            this.ifModifiedSince = ifModifiedSince;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            return this;
        }

        public GetZoneRequest buildWithoutInvocationCallback() {
            return new GetZoneRequest(this.zoneNameOrId, this.ifNoneMatch, this.ifModifiedSince, this.opcRequestId, this.compartmentId);
        }

        public String toString() {
            return "GetZoneRequest.Builder(zoneNameOrId=" + this.zoneNameOrId + ", ifNoneMatch=" + this.ifNoneMatch + ", ifModifiedSince=" + this.ifModifiedSince + ", opcRequestId=" + this.opcRequestId + ", compartmentId=" + this.compartmentId + ")";
        }
    }
}

