/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dns.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.dns.model.SortOrder;
import com.oracle.bmc.dns.model.SteeringPolicyAttachmentSummary;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.client.Invocation;

public class ListSteeringPolicyAttachmentsRequest
extends BmcRequest {
    private String compartmentId;
    private String opcRequestId;
    private Long limit;
    private String page;
    private String id;
    private String displayName;
    private String steeringPolicyId;
    private String zoneId;
    private String domain;
    private String domainContains;
    private Date timeCreatedGreaterThanOrEqualTo;
    private Date timeCreatedLessThan;
    private SteeringPolicyAttachmentSummary.LifecycleState lifecycleState;
    private SortBy sortBy;
    private SortOrder sortOrder;

    @ConstructorProperties(value={"compartmentId", "opcRequestId", "limit", "page", "id", "displayName", "steeringPolicyId", "zoneId", "domain", "domainContains", "timeCreatedGreaterThanOrEqualTo", "timeCreatedLessThan", "lifecycleState", "sortBy", "sortOrder"})
    ListSteeringPolicyAttachmentsRequest(String compartmentId, String opcRequestId, Long limit, String page, String id, String displayName, String steeringPolicyId, String zoneId, String domain, String domainContains, Date timeCreatedGreaterThanOrEqualTo, Date timeCreatedLessThan, SteeringPolicyAttachmentSummary.LifecycleState lifecycleState, SortBy sortBy, SortOrder sortOrder) {
        this.compartmentId = compartmentId;
        this.opcRequestId = opcRequestId;
        this.limit = limit;
        this.page = page;
        this.id = id;
        this.displayName = displayName;
        this.steeringPolicyId = steeringPolicyId;
        this.zoneId = zoneId;
        this.domain = domain;
        this.domainContains = domainContains;
        this.timeCreatedGreaterThanOrEqualTo = timeCreatedGreaterThanOrEqualTo;
        this.timeCreatedLessThan = timeCreatedLessThan;
        this.lifecycleState = lifecycleState;
        this.sortBy = sortBy;
        this.sortOrder = sortOrder;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Long getLimit() {
        return this.limit;
    }

    public String getPage() {
        return this.page;
    }

    public String getId() {
        return this.id;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getSteeringPolicyId() {
        return this.steeringPolicyId;
    }

    public String getZoneId() {
        return this.zoneId;
    }

    public String getDomain() {
        return this.domain;
    }

    public String getDomainContains() {
        return this.domainContains;
    }

    public Date getTimeCreatedGreaterThanOrEqualTo() {
        return this.timeCreatedGreaterThanOrEqualTo;
    }

    public Date getTimeCreatedLessThan() {
        return this.timeCreatedLessThan;
    }

    public SteeringPolicyAttachmentSummary.LifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public SortBy getSortBy() {
        return this.sortBy;
    }

    public SortOrder getSortOrder() {
        return this.sortOrder;
    }

    public static class Builder {
        private String compartmentId;
        private String opcRequestId;
        private Long limit;
        private String page;
        private String id;
        private String displayName;
        private String steeringPolicyId;
        private String zoneId;
        private String domain;
        private String domainContains;
        private Date timeCreatedGreaterThanOrEqualTo;
        private Date timeCreatedLessThan;
        private SteeringPolicyAttachmentSummary.LifecycleState lifecycleState;
        private SortBy sortBy;
        private SortOrder sortOrder;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListSteeringPolicyAttachmentsRequest o) {
            this.compartmentId(o.getCompartmentId());
            this.opcRequestId(o.getOpcRequestId());
            this.limit(o.getLimit());
            this.page(o.getPage());
            this.id(o.getId());
            this.displayName(o.getDisplayName());
            this.steeringPolicyId(o.getSteeringPolicyId());
            this.zoneId(o.getZoneId());
            this.domain(o.getDomain());
            this.domainContains(o.getDomainContains());
            this.timeCreatedGreaterThanOrEqualTo(o.getTimeCreatedGreaterThanOrEqualTo());
            this.timeCreatedLessThan(o.getTimeCreatedLessThan());
            this.lifecycleState(o.getLifecycleState());
            this.sortBy(o.getSortBy());
            this.sortOrder(o.getSortOrder());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListSteeringPolicyAttachmentsRequest build() {
            ListSteeringPolicyAttachmentsRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder limit(Long limit) {
            this.limit = limit;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public Builder steeringPolicyId(String steeringPolicyId) {
            this.steeringPolicyId = steeringPolicyId;
            return this;
        }

        public Builder zoneId(String zoneId) {
            this.zoneId = zoneId;
            return this;
        }

        public Builder domain(String domain) {
            this.domain = domain;
            return this;
        }

        public Builder domainContains(String domainContains) {
            this.domainContains = domainContains;
            return this;
        }

        public Builder timeCreatedGreaterThanOrEqualTo(Date timeCreatedGreaterThanOrEqualTo) {
            this.timeCreatedGreaterThanOrEqualTo = timeCreatedGreaterThanOrEqualTo;
            return this;
        }

        public Builder timeCreatedLessThan(Date timeCreatedLessThan) {
            this.timeCreatedLessThan = timeCreatedLessThan;
            return this;
        }

        public Builder lifecycleState(SteeringPolicyAttachmentSummary.LifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            return this;
        }

        public Builder sortBy(SortBy sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        public Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        public ListSteeringPolicyAttachmentsRequest buildWithoutInvocationCallback() {
            return new ListSteeringPolicyAttachmentsRequest(this.compartmentId, this.opcRequestId, this.limit, this.page, this.id, this.displayName, this.steeringPolicyId, this.zoneId, this.domain, this.domainContains, this.timeCreatedGreaterThanOrEqualTo, this.timeCreatedLessThan, this.lifecycleState, this.sortBy, this.sortOrder);
        }

        public String toString() {
            return "ListSteeringPolicyAttachmentsRequest.Builder(compartmentId=" + this.compartmentId + ", opcRequestId=" + this.opcRequestId + ", limit=" + this.limit + ", page=" + this.page + ", id=" + this.id + ", displayName=" + this.displayName + ", steeringPolicyId=" + this.steeringPolicyId + ", zoneId=" + this.zoneId + ", domain=" + this.domain + ", domainContains=" + this.domainContains + ", timeCreatedGreaterThanOrEqualTo=" + this.timeCreatedGreaterThanOrEqualTo + ", timeCreatedLessThan=" + this.timeCreatedLessThan + ", lifecycleState=" + (Object)((Object)this.lifecycleState) + ", sortBy=" + (Object)((Object)this.sortBy) + ", sortOrder=" + (Object)((Object)this.sortOrder) + ")";
        }
    }

    public static enum SortBy {
        DisplayName("displayName"),
        TimeCreated("timeCreated"),
        DomainName("domainName");

        private final String value;
        private static Map<String, SortBy> map;

        private SortBy(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortBy create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new RuntimeException("Invalid SortBy: " + key);
        }

        static {
            map = new HashMap<String, SortBy>();
            for (SortBy v : SortBy.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

