/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dns.requests;

import com.oracle.bmc.dns.model.UpdateTsigKeyDetails;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class UpdateTsigKeyRequest
extends BmcRequest {
    private String tsigKeyId;
    private UpdateTsigKeyDetails updateTsigKeyDetails;
    private String ifMatch;
    private String ifUnmodifiedSince;
    private String opcRequestId;

    @ConstructorProperties(value={"tsigKeyId", "updateTsigKeyDetails", "ifMatch", "ifUnmodifiedSince", "opcRequestId"})
    UpdateTsigKeyRequest(String tsigKeyId, UpdateTsigKeyDetails updateTsigKeyDetails, String ifMatch, String ifUnmodifiedSince, String opcRequestId) {
        this.tsigKeyId = tsigKeyId;
        this.updateTsigKeyDetails = updateTsigKeyDetails;
        this.ifMatch = ifMatch;
        this.ifUnmodifiedSince = ifUnmodifiedSince;
        this.opcRequestId = opcRequestId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getTsigKeyId() {
        return this.tsigKeyId;
    }

    public UpdateTsigKeyDetails getUpdateTsigKeyDetails() {
        return this.updateTsigKeyDetails;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public String getIfUnmodifiedSince() {
        return this.ifUnmodifiedSince;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public static class Builder {
        private String tsigKeyId;
        private UpdateTsigKeyDetails updateTsigKeyDetails;
        private String ifMatch;
        private String ifUnmodifiedSince;
        private String opcRequestId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(UpdateTsigKeyRequest o) {
            this.tsigKeyId(o.getTsigKeyId());
            this.updateTsigKeyDetails(o.getUpdateTsigKeyDetails());
            this.ifMatch(o.getIfMatch());
            this.ifUnmodifiedSince(o.getIfUnmodifiedSince());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public UpdateTsigKeyRequest build() {
            UpdateTsigKeyRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder tsigKeyId(String tsigKeyId) {
            this.tsigKeyId = tsigKeyId;
            return this;
        }

        public Builder updateTsigKeyDetails(UpdateTsigKeyDetails updateTsigKeyDetails) {
            this.updateTsigKeyDetails = updateTsigKeyDetails;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder ifUnmodifiedSince(String ifUnmodifiedSince) {
            this.ifUnmodifiedSince = ifUnmodifiedSince;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public UpdateTsigKeyRequest buildWithoutInvocationCallback() {
            return new UpdateTsigKeyRequest(this.tsigKeyId, this.updateTsigKeyDetails, this.ifMatch, this.ifUnmodifiedSince, this.opcRequestId);
        }

        public String toString() {
            return "UpdateTsigKeyRequest.Builder(tsigKeyId=" + this.tsigKeyId + ", updateTsigKeyDetails=" + this.updateTsigKeyDetails + ", ifMatch=" + this.ifMatch + ", ifUnmodifiedSince=" + this.ifUnmodifiedSince + ", opcRequestId=" + this.opcRequestId + ")";
        }
    }
}

