/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dns.responses;

import com.oracle.bmc.dns.model.Zone;
import java.beans.ConstructorProperties;

public class CreateZoneResponse {
    private String opcRequestId;
    private String eTag;
    private Zone zone;

    @ConstructorProperties(value={"opcRequestId", "eTag", "zone"})
    CreateZoneResponse(String opcRequestId, String eTag, Zone zone) {
        this.opcRequestId = opcRequestId;
        this.eTag = eTag;
        this.zone = zone;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getETag() {
        return this.eTag;
    }

    public Zone getZone() {
        return this.zone;
    }

    public static class Builder {
        private String opcRequestId;
        private String eTag;
        private Zone zone;

        public Builder copy(CreateZoneResponse o) {
            this.opcRequestId(o.getOpcRequestId());
            this.eTag(o.getETag());
            this.zone(o.getZone());
            return this;
        }

        Builder() {
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder eTag(String eTag) {
            this.eTag = eTag;
            return this;
        }

        public Builder zone(Zone zone) {
            this.zone = zone;
            return this;
        }

        public CreateZoneResponse build() {
            return new CreateZoneResponse(this.opcRequestId, this.eTag, this.zone);
        }

        public String toString() {
            return "CreateZoneResponse.Builder(opcRequestId=" + this.opcRequestId + ", eTag=" + this.eTag + ", zone=" + this.zone + ")";
        }
    }
}

