/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dns.responses;

import com.oracle.bmc.dns.model.TsigKeySummary;
import java.beans.ConstructorProperties;
import java.util.List;

public class ListTsigKeysResponse {
    private String opcNextPage;
    private String opcRequestId;
    private List<TsigKeySummary> items;

    @ConstructorProperties(value={"opcNextPage", "opcRequestId", "items"})
    ListTsigKeysResponse(String opcNextPage, String opcRequestId, List<TsigKeySummary> items) {
        this.opcNextPage = opcNextPage;
        this.opcRequestId = opcRequestId;
        this.items = items;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getOpcNextPage() {
        return this.opcNextPage;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public List<TsigKeySummary> getItems() {
        return this.items;
    }

    public static class Builder {
        private String opcNextPage;
        private String opcRequestId;
        private List<TsigKeySummary> items;

        public Builder copy(ListTsigKeysResponse o) {
            this.opcNextPage(o.getOpcNextPage());
            this.opcRequestId(o.getOpcRequestId());
            this.items(o.getItems());
            return this;
        }

        Builder() {
        }

        public Builder opcNextPage(String opcNextPage) {
            this.opcNextPage = opcNextPage;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder items(List<TsigKeySummary> items) {
            this.items = items;
            return this;
        }

        public ListTsigKeysResponse build() {
            return new ListTsigKeysResponse(this.opcNextPage, this.opcRequestId, this.items);
        }

        public String toString() {
            return "ListTsigKeysResponse.Builder(opcNextPage=" + this.opcNextPage + ", opcRequestId=" + this.opcRequestId + ", items=" + this.items + ")";
        }
    }
}

