/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dns.responses;

import com.oracle.bmc.dns.model.TsigKey;
import java.beans.ConstructorProperties;

public class UpdateTsigKeyResponse {
    private String eTag;
    private String opcRequestId;
    private TsigKey tsigKey;

    @ConstructorProperties(value={"eTag", "opcRequestId", "tsigKey"})
    UpdateTsigKeyResponse(String eTag, String opcRequestId, TsigKey tsigKey) {
        this.eTag = eTag;
        this.opcRequestId = opcRequestId;
        this.tsigKey = tsigKey;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getETag() {
        return this.eTag;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public TsigKey getTsigKey() {
        return this.tsigKey;
    }

    public static class Builder {
        private String eTag;
        private String opcRequestId;
        private TsigKey tsigKey;

        public Builder copy(UpdateTsigKeyResponse o) {
            this.eTag(o.getETag());
            this.opcRequestId(o.getOpcRequestId());
            this.tsigKey(o.getTsigKey());
            return this;
        }

        Builder() {
        }

        public Builder eTag(String eTag) {
            this.eTag = eTag;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder tsigKey(TsigKey tsigKey) {
            this.tsigKey = tsigKey;
            return this;
        }

        public UpdateTsigKeyResponse build() {
            return new UpdateTsigKeyResponse(this.eTag, this.opcRequestId, this.tsigKey);
        }

        public String toString() {
            return "UpdateTsigKeyResponse.Builder(eTag=" + this.eTag + ", opcRequestId=" + this.opcRequestId + ", tsigKey=" + this.tsigKey + ")";
        }
    }
}

