/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dns.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.dns.model.SteeringPolicyLimitRuleCase;
import com.oracle.bmc.dns.model.SteeringPolicyRule;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="ruleType")
@JsonFilter(value="explicitlySetFilter")
public final class SteeringPolicyLimitRule
extends SteeringPolicyRule {
    @JsonProperty(value="cases")
    private final List<SteeringPolicyLimitRuleCase> cases;
    @JsonProperty(value="defaultCount")
    private final Integer defaultCount;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public SteeringPolicyLimitRule(String description, List<SteeringPolicyLimitRuleCase> cases, Integer defaultCount) {
        super(description);
        this.cases = cases;
        this.defaultCount = defaultCount;
    }

    public List<SteeringPolicyLimitRuleCase> getCases() {
        return this.cases;
    }

    public Integer getDefaultCount() {
        return this.defaultCount;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("SteeringPolicyLimitRule(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", cases=").append(String.valueOf(this.cases));
        sb.append(", defaultCount=").append(String.valueOf(this.defaultCount));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SteeringPolicyLimitRule)) {
            return false;
        }
        SteeringPolicyLimitRule other = (SteeringPolicyLimitRule)((Object)o);
        return Objects.equals(this.cases, other.cases) && Objects.equals(this.defaultCount, other.defaultCount) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.cases == null ? 43 : this.cases.hashCode());
        result = result * 59 + (this.defaultCount == null ? 43 : this.defaultCount.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="description")
        private String description;
        @JsonProperty(value="cases")
        private List<SteeringPolicyLimitRuleCase> cases;
        @JsonProperty(value="defaultCount")
        private Integer defaultCount;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder description(String description) {
            this.description = description;
            this.__explicitlySet__.add("description");
            return this;
        }

        public Builder cases(List<SteeringPolicyLimitRuleCase> cases) {
            this.cases = cases;
            this.__explicitlySet__.add("cases");
            return this;
        }

        public Builder defaultCount(Integer defaultCount) {
            this.defaultCount = defaultCount;
            this.__explicitlySet__.add("defaultCount");
            return this;
        }

        public SteeringPolicyLimitRule build() {
            SteeringPolicyLimitRule model = new SteeringPolicyLimitRule(this.description, this.cases, this.defaultCount);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(SteeringPolicyLimitRule model) {
            if (model.wasPropertyExplicitlySet("description")) {
                this.description(model.getDescription());
            }
            if (model.wasPropertyExplicitlySet("cases")) {
                this.cases(model.getCases());
            }
            if (model.wasPropertyExplicitlySet("defaultCount")) {
                this.defaultCount(model.getDefaultCount());
            }
            return this;
        }
    }
}

