/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dns.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class ExternalMaster
extends ExplicitlySetBmcModel {
    @JsonProperty(value="address")
    private final String address;
    @JsonProperty(value="port")
    private final Integer port;
    @JsonProperty(value="tsigKeyId")
    private final String tsigKeyId;

    @Deprecated
    @ConstructorProperties(value={"address", "port", "tsigKeyId"})
    public ExternalMaster(String address, Integer port, String tsigKeyId) {
        this.address = address;
        this.port = port;
        this.tsigKeyId = tsigKeyId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getAddress() {
        return this.address;
    }

    public Integer getPort() {
        return this.port;
    }

    public String getTsigKeyId() {
        return this.tsigKeyId;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("ExternalMaster(");
        sb.append("super=").append(super.toString());
        sb.append("address=").append(String.valueOf(this.address));
        sb.append(", port=").append(String.valueOf(this.port));
        sb.append(", tsigKeyId=").append(String.valueOf(this.tsigKeyId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ExternalMaster)) {
            return false;
        }
        ExternalMaster other = (ExternalMaster)((Object)o);
        return Objects.equals(this.address, other.address) && Objects.equals(this.port, other.port) && Objects.equals(this.tsigKeyId, other.tsigKeyId) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.address == null ? 43 : this.address.hashCode());
        result = result * 59 + (this.port == null ? 43 : this.port.hashCode());
        result = result * 59 + (this.tsigKeyId == null ? 43 : this.tsigKeyId.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="address")
        private String address;
        @JsonProperty(value="port")
        private Integer port;
        @JsonProperty(value="tsigKeyId")
        private String tsigKeyId;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder address(String address) {
            this.address = address;
            this.__explicitlySet__.add("address");
            return this;
        }

        public Builder port(Integer port) {
            this.port = port;
            this.__explicitlySet__.add("port");
            return this;
        }

        public Builder tsigKeyId(String tsigKeyId) {
            this.tsigKeyId = tsigKeyId;
            this.__explicitlySet__.add("tsigKeyId");
            return this;
        }

        public ExternalMaster build() {
            ExternalMaster model = new ExternalMaster(this.address, this.port, this.tsigKeyId);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(ExternalMaster model) {
            if (model.wasPropertyExplicitlySet("address")) {
                this.address(model.getAddress());
            }
            if (model.wasPropertyExplicitlySet("port")) {
                this.port(model.getPort());
            }
            if (model.wasPropertyExplicitlySet("tsigKeyId")) {
                this.tsigKeyId(model.getTsigKeyId());
            }
            return this;
        }
    }
}

