/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dns.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class MigrationReplacement
extends ExplicitlySetBmcModel {
    @JsonProperty(value="rtype")
    private final String rtype;
    @JsonProperty(value="substituteRtype")
    private final String substituteRtype;
    @JsonProperty(value="ttl")
    private final Integer ttl;
    @JsonProperty(value="rdata")
    private final String rdata;

    @Deprecated
    @ConstructorProperties(value={"rtype", "substituteRtype", "ttl", "rdata"})
    public MigrationReplacement(String rtype, String substituteRtype, Integer ttl, String rdata) {
        this.rtype = rtype;
        this.substituteRtype = substituteRtype;
        this.ttl = ttl;
        this.rdata = rdata;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getRtype() {
        return this.rtype;
    }

    public String getSubstituteRtype() {
        return this.substituteRtype;
    }

    public Integer getTtl() {
        return this.ttl;
    }

    public String getRdata() {
        return this.rdata;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("MigrationReplacement(");
        sb.append("super=").append(super.toString());
        sb.append("rtype=").append(String.valueOf(this.rtype));
        sb.append(", substituteRtype=").append(String.valueOf(this.substituteRtype));
        sb.append(", ttl=").append(String.valueOf(this.ttl));
        sb.append(", rdata=").append(String.valueOf(this.rdata));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MigrationReplacement)) {
            return false;
        }
        MigrationReplacement other = (MigrationReplacement)((Object)o);
        return Objects.equals(this.rtype, other.rtype) && Objects.equals(this.substituteRtype, other.substituteRtype) && Objects.equals(this.ttl, other.ttl) && Objects.equals(this.rdata, other.rdata) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.rtype == null ? 43 : this.rtype.hashCode());
        result = result * 59 + (this.substituteRtype == null ? 43 : this.substituteRtype.hashCode());
        result = result * 59 + (this.ttl == null ? 43 : this.ttl.hashCode());
        result = result * 59 + (this.rdata == null ? 43 : this.rdata.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="rtype")
        private String rtype;
        @JsonProperty(value="substituteRtype")
        private String substituteRtype;
        @JsonProperty(value="ttl")
        private Integer ttl;
        @JsonProperty(value="rdata")
        private String rdata;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder rtype(String rtype) {
            this.rtype = rtype;
            this.__explicitlySet__.add("rtype");
            return this;
        }

        public Builder substituteRtype(String substituteRtype) {
            this.substituteRtype = substituteRtype;
            this.__explicitlySet__.add("substituteRtype");
            return this;
        }

        public Builder ttl(Integer ttl) {
            this.ttl = ttl;
            this.__explicitlySet__.add("ttl");
            return this;
        }

        public Builder rdata(String rdata) {
            this.rdata = rdata;
            this.__explicitlySet__.add("rdata");
            return this;
        }

        public MigrationReplacement build() {
            MigrationReplacement model = new MigrationReplacement(this.rtype, this.substituteRtype, this.ttl, this.rdata);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(MigrationReplacement model) {
            if (model.wasPropertyExplicitlySet("rtype")) {
                this.rtype(model.getRtype());
            }
            if (model.wasPropertyExplicitlySet("substituteRtype")) {
                this.substituteRtype(model.getSubstituteRtype());
            }
            if (model.wasPropertyExplicitlySet("ttl")) {
                this.ttl(model.getTtl());
            }
            if (model.wasPropertyExplicitlySet("rdata")) {
                this.rdata(model.getRdata());
            }
            return this;
        }
    }
}

