/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dns.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.dns.model.ChangeViewCompartmentDetails;
import com.oracle.bmc.dns.model.Scope;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class ChangeViewCompartmentRequest
extends BmcRequest<ChangeViewCompartmentDetails> {
    private String viewId;
    private ChangeViewCompartmentDetails changeViewCompartmentDetails;
    private String ifMatch;
    private String opcRetryToken;
    private String opcRequestId;
    private Scope scope;

    public String getViewId() {
        return this.viewId;
    }

    public ChangeViewCompartmentDetails getChangeViewCompartmentDetails() {
        return this.changeViewCompartmentDetails;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Scope getScope() {
        return this.scope;
    }

    @InternalSdk
    public ChangeViewCompartmentDetails getBody$() {
        return this.changeViewCompartmentDetails;
    }

    public Builder toBuilder() {
        return new Builder().viewId(this.viewId).changeViewCompartmentDetails(this.changeViewCompartmentDetails).ifMatch(this.ifMatch).opcRetryToken(this.opcRetryToken).opcRequestId(this.opcRequestId).scope(this.scope);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",viewId=").append(String.valueOf(this.viewId));
        sb.append(",changeViewCompartmentDetails=").append(String.valueOf((Object)this.changeViewCompartmentDetails));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(",opcRetryToken=").append(String.valueOf(this.opcRetryToken));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",scope=").append(String.valueOf((Object)this.scope));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ChangeViewCompartmentRequest)) {
            return false;
        }
        ChangeViewCompartmentRequest other = (ChangeViewCompartmentRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.viewId, other.viewId) && Objects.equals((Object)this.changeViewCompartmentDetails, (Object)other.changeViewCompartmentDetails) && Objects.equals(this.ifMatch, other.ifMatch) && Objects.equals(this.opcRetryToken, other.opcRetryToken) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals((Object)this.scope, (Object)other.scope);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.viewId == null ? 43 : this.viewId.hashCode());
        result = result * 59 + (this.changeViewCompartmentDetails == null ? 43 : this.changeViewCompartmentDetails.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        result = result * 59 + (this.opcRetryToken == null ? 43 : this.opcRetryToken.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.scope == null ? 43 : this.scope.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<ChangeViewCompartmentRequest, ChangeViewCompartmentDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String viewId = null;
        private ChangeViewCompartmentDetails changeViewCompartmentDetails = null;
        private String ifMatch = null;
        private String opcRetryToken = null;
        private String opcRequestId = null;
        private Scope scope = null;

        public Builder viewId(String viewId) {
            this.viewId = viewId;
            return this;
        }

        public Builder changeViewCompartmentDetails(ChangeViewCompartmentDetails changeViewCompartmentDetails) {
            this.changeViewCompartmentDetails = changeViewCompartmentDetails;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder scope(Scope scope) {
            this.scope = scope;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ChangeViewCompartmentRequest o) {
            this.viewId(o.getViewId());
            this.changeViewCompartmentDetails(o.getChangeViewCompartmentDetails());
            this.ifMatch(o.getIfMatch());
            this.opcRetryToken(o.getOpcRetryToken());
            this.opcRequestId(o.getOpcRequestId());
            this.scope(o.getScope());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ChangeViewCompartmentRequest build() {
            ChangeViewCompartmentRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(ChangeViewCompartmentDetails body) {
            this.changeViewCompartmentDetails(body);
            return this;
        }

        public ChangeViewCompartmentRequest buildWithoutInvocationCallback() {
            ChangeViewCompartmentRequest request = new ChangeViewCompartmentRequest();
            request.viewId = this.viewId;
            request.changeViewCompartmentDetails = this.changeViewCompartmentDetails;
            request.ifMatch = this.ifMatch;
            request.opcRetryToken = this.opcRetryToken;
            request.opcRequestId = this.opcRequestId;
            request.scope = this.scope;
            return request;
        }
    }
}

