/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dns.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.dns.model.CreateZoneBaseDetails;
import com.oracle.bmc.dns.model.Scope;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class CreateZoneRequest
extends BmcRequest<CreateZoneBaseDetails> {
    private CreateZoneBaseDetails createZoneDetails;
    private String opcRequestId;
    private String compartmentId;
    private Scope scope;
    private String viewId;

    public CreateZoneBaseDetails getCreateZoneDetails() {
        return this.createZoneDetails;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public Scope getScope() {
        return this.scope;
    }

    public String getViewId() {
        return this.viewId;
    }

    @InternalSdk
    public CreateZoneBaseDetails getBody$() {
        return this.createZoneDetails;
    }

    public Builder toBuilder() {
        return new Builder().createZoneDetails(this.createZoneDetails).opcRequestId(this.opcRequestId).compartmentId(this.compartmentId).scope(this.scope).viewId(this.viewId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",createZoneDetails=").append(String.valueOf((Object)this.createZoneDetails));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(",scope=").append(String.valueOf((Object)this.scope));
        sb.append(",viewId=").append(String.valueOf(this.viewId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CreateZoneRequest)) {
            return false;
        }
        CreateZoneRequest other = (CreateZoneRequest)((Object)o);
        return super.equals(o) && Objects.equals((Object)this.createZoneDetails, (Object)other.createZoneDetails) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals((Object)this.scope, (Object)other.scope) && Objects.equals(this.viewId, other.viewId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.createZoneDetails == null ? 43 : this.createZoneDetails.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.scope == null ? 43 : this.scope.hashCode());
        result = result * 59 + (this.viewId == null ? 43 : this.viewId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<CreateZoneRequest, CreateZoneBaseDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private CreateZoneBaseDetails createZoneDetails = null;
        private String opcRequestId = null;
        private String compartmentId = null;
        private Scope scope = null;
        private String viewId = null;

        public Builder createZoneDetails(CreateZoneBaseDetails createZoneDetails) {
            this.createZoneDetails = createZoneDetails;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            return this;
        }

        public Builder scope(Scope scope) {
            this.scope = scope;
            return this;
        }

        public Builder viewId(String viewId) {
            this.viewId = viewId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(CreateZoneRequest o) {
            this.createZoneDetails(o.getCreateZoneDetails());
            this.opcRequestId(o.getOpcRequestId());
            this.compartmentId(o.getCompartmentId());
            this.scope(o.getScope());
            this.viewId(o.getViewId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public CreateZoneRequest build() {
            CreateZoneRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(CreateZoneBaseDetails body) {
            this.createZoneDetails(body);
            return this;
        }

        public CreateZoneRequest buildWithoutInvocationCallback() {
            CreateZoneRequest request = new CreateZoneRequest();
            request.createZoneDetails = this.createZoneDetails;
            request.opcRequestId = this.opcRequestId;
            request.compartmentId = this.compartmentId;
            request.scope = this.scope;
            request.viewId = this.viewId;
            return request;
        }
    }
}

