/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dns.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.dns.model.Scope;
import com.oracle.bmc.dns.model.UpdateDomainRecordsDetails;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class UpdateDomainRecordsRequest
extends BmcRequest<UpdateDomainRecordsDetails> {
    private String zoneNameOrId;
    private String domain;
    private UpdateDomainRecordsDetails updateDomainRecordsDetails;
    private String ifMatch;
    private String ifUnmodifiedSince;
    private String opcRequestId;
    private Scope scope;
    private String viewId;
    private String compartmentId;

    public String getZoneNameOrId() {
        return this.zoneNameOrId;
    }

    public String getDomain() {
        return this.domain;
    }

    public UpdateDomainRecordsDetails getUpdateDomainRecordsDetails() {
        return this.updateDomainRecordsDetails;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public String getIfUnmodifiedSince() {
        return this.ifUnmodifiedSince;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Scope getScope() {
        return this.scope;
    }

    public String getViewId() {
        return this.viewId;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    @InternalSdk
    public UpdateDomainRecordsDetails getBody$() {
        return this.updateDomainRecordsDetails;
    }

    public Builder toBuilder() {
        return new Builder().zoneNameOrId(this.zoneNameOrId).domain(this.domain).updateDomainRecordsDetails(this.updateDomainRecordsDetails).ifMatch(this.ifMatch).ifUnmodifiedSince(this.ifUnmodifiedSince).opcRequestId(this.opcRequestId).scope(this.scope).viewId(this.viewId).compartmentId(this.compartmentId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",zoneNameOrId=").append(String.valueOf(this.zoneNameOrId));
        sb.append(",domain=").append(String.valueOf(this.domain));
        sb.append(",updateDomainRecordsDetails=").append(String.valueOf((Object)this.updateDomainRecordsDetails));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(",ifUnmodifiedSince=").append(String.valueOf(this.ifUnmodifiedSince));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",scope=").append(String.valueOf((Object)this.scope));
        sb.append(",viewId=").append(String.valueOf(this.viewId));
        sb.append(",compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UpdateDomainRecordsRequest)) {
            return false;
        }
        UpdateDomainRecordsRequest other = (UpdateDomainRecordsRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.zoneNameOrId, other.zoneNameOrId) && Objects.equals(this.domain, other.domain) && Objects.equals((Object)this.updateDomainRecordsDetails, (Object)other.updateDomainRecordsDetails) && Objects.equals(this.ifMatch, other.ifMatch) && Objects.equals(this.ifUnmodifiedSince, other.ifUnmodifiedSince) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals((Object)this.scope, (Object)other.scope) && Objects.equals(this.viewId, other.viewId) && Objects.equals(this.compartmentId, other.compartmentId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.zoneNameOrId == null ? 43 : this.zoneNameOrId.hashCode());
        result = result * 59 + (this.domain == null ? 43 : this.domain.hashCode());
        result = result * 59 + (this.updateDomainRecordsDetails == null ? 43 : this.updateDomainRecordsDetails.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        result = result * 59 + (this.ifUnmodifiedSince == null ? 43 : this.ifUnmodifiedSince.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.scope == null ? 43 : this.scope.hashCode());
        result = result * 59 + (this.viewId == null ? 43 : this.viewId.hashCode());
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<UpdateDomainRecordsRequest, UpdateDomainRecordsDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String zoneNameOrId = null;
        private String domain = null;
        private UpdateDomainRecordsDetails updateDomainRecordsDetails = null;
        private String ifMatch = null;
        private String ifUnmodifiedSince = null;
        private String opcRequestId = null;
        private Scope scope = null;
        private String viewId = null;
        private String compartmentId = null;

        public Builder zoneNameOrId(String zoneNameOrId) {
            this.zoneNameOrId = zoneNameOrId;
            return this;
        }

        public Builder domain(String domain) {
            this.domain = domain;
            return this;
        }

        public Builder updateDomainRecordsDetails(UpdateDomainRecordsDetails updateDomainRecordsDetails) {
            this.updateDomainRecordsDetails = updateDomainRecordsDetails;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder ifUnmodifiedSince(String ifUnmodifiedSince) {
            this.ifUnmodifiedSince = ifUnmodifiedSince;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder scope(Scope scope) {
            this.scope = scope;
            return this;
        }

        public Builder viewId(String viewId) {
            this.viewId = viewId;
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(UpdateDomainRecordsRequest o) {
            this.zoneNameOrId(o.getZoneNameOrId());
            this.domain(o.getDomain());
            this.updateDomainRecordsDetails(o.getUpdateDomainRecordsDetails());
            this.ifMatch(o.getIfMatch());
            this.ifUnmodifiedSince(o.getIfUnmodifiedSince());
            this.opcRequestId(o.getOpcRequestId());
            this.scope(o.getScope());
            this.viewId(o.getViewId());
            this.compartmentId(o.getCompartmentId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public UpdateDomainRecordsRequest build() {
            UpdateDomainRecordsRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(UpdateDomainRecordsDetails body) {
            this.updateDomainRecordsDetails(body);
            return this;
        }

        public UpdateDomainRecordsRequest buildWithoutInvocationCallback() {
            UpdateDomainRecordsRequest request = new UpdateDomainRecordsRequest();
            request.zoneNameOrId = this.zoneNameOrId;
            request.domain = this.domain;
            request.updateDomainRecordsDetails = this.updateDomainRecordsDetails;
            request.ifMatch = this.ifMatch;
            request.ifUnmodifiedSince = this.ifUnmodifiedSince;
            request.opcRequestId = this.opcRequestId;
            request.scope = this.scope;
            request.viewId = this.viewId;
            request.compartmentId = this.compartmentId;
            return request;
        }
    }
}

