/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dns.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.dns.model.CreateZoneBaseDetails;
import com.oracle.bmc.dns.model.ExternalDownstream;
import com.oracle.bmc.dns.model.ExternalMaster;
import com.oracle.bmc.dns.model.Scope;
import com.oracle.bmc.http.internal.BmcEnum;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="migrationSource")
@JsonFilter(value="explicitlySetFilter")
public final class CreateZoneDetails
extends CreateZoneBaseDetails {
    @JsonProperty(value="zoneType")
    private final ZoneType zoneType;
    @JsonProperty(value="viewId")
    private final String viewId;
    @JsonProperty(value="scope")
    private final Scope scope;
    @JsonProperty(value="externalMasters")
    private final List<ExternalMaster> externalMasters;
    @JsonProperty(value="externalDownstreams")
    private final List<ExternalDownstream> externalDownstreams;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public CreateZoneDetails(String name, String compartmentId, Map<String, String> freeformTags, Map<String, Map<String, Object>> definedTags, ZoneType zoneType, String viewId, Scope scope, List<ExternalMaster> externalMasters, List<ExternalDownstream> externalDownstreams) {
        super(name, compartmentId, freeformTags, definedTags);
        this.zoneType = zoneType;
        this.viewId = viewId;
        this.scope = scope;
        this.externalMasters = externalMasters;
        this.externalDownstreams = externalDownstreams;
    }

    public ZoneType getZoneType() {
        return this.zoneType;
    }

    public String getViewId() {
        return this.viewId;
    }

    public Scope getScope() {
        return this.scope;
    }

    public List<ExternalMaster> getExternalMasters() {
        return this.externalMasters;
    }

    public List<ExternalDownstream> getExternalDownstreams() {
        return this.externalDownstreams;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("CreateZoneDetails(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", zoneType=").append(String.valueOf((Object)this.zoneType));
        sb.append(", viewId=").append(String.valueOf(this.viewId));
        sb.append(", scope=").append(String.valueOf((Object)this.scope));
        sb.append(", externalMasters=").append(String.valueOf(this.externalMasters));
        sb.append(", externalDownstreams=").append(String.valueOf(this.externalDownstreams));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CreateZoneDetails)) {
            return false;
        }
        CreateZoneDetails other = (CreateZoneDetails)((Object)o);
        return Objects.equals((Object)this.zoneType, (Object)other.zoneType) && Objects.equals(this.viewId, other.viewId) && Objects.equals((Object)this.scope, (Object)other.scope) && Objects.equals(this.externalMasters, other.externalMasters) && Objects.equals(this.externalDownstreams, other.externalDownstreams) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.zoneType == null ? 43 : this.zoneType.hashCode());
        result = result * 59 + (this.viewId == null ? 43 : this.viewId.hashCode());
        result = result * 59 + (this.scope == null ? 43 : this.scope.hashCode());
        result = result * 59 + (this.externalMasters == null ? 43 : this.externalMasters.hashCode());
        result = result * 59 + (this.externalDownstreams == null ? 43 : this.externalDownstreams.hashCode());
        return result;
    }

    public static enum ZoneType implements BmcEnum
    {
        Primary("PRIMARY"),
        Secondary("SECONDARY");

        private final String value;
        private static Map<String, ZoneType> map;

        private ZoneType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static ZoneType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid ZoneType: " + key);
        }

        static {
            map = new HashMap<String, ZoneType>();
            for (ZoneType v : ZoneType.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="name")
        private String name;
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="freeformTags")
        private Map<String, String> freeformTags;
        @JsonProperty(value="definedTags")
        private Map<String, Map<String, Object>> definedTags;
        @JsonProperty(value="zoneType")
        private ZoneType zoneType;
        @JsonProperty(value="viewId")
        private String viewId;
        @JsonProperty(value="scope")
        private Scope scope;
        @JsonProperty(value="externalMasters")
        private List<ExternalMaster> externalMasters;
        @JsonProperty(value="externalDownstreams")
        private List<ExternalDownstream> externalDownstreams;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder name(String name) {
            this.name = name;
            this.__explicitlySet__.add("name");
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder freeformTags(Map<String, String> freeformTags) {
            this.freeformTags = freeformTags;
            this.__explicitlySet__.add("freeformTags");
            return this;
        }

        public Builder definedTags(Map<String, Map<String, Object>> definedTags) {
            this.definedTags = definedTags;
            this.__explicitlySet__.add("definedTags");
            return this;
        }

        public Builder zoneType(ZoneType zoneType) {
            this.zoneType = zoneType;
            this.__explicitlySet__.add("zoneType");
            return this;
        }

        public Builder viewId(String viewId) {
            this.viewId = viewId;
            this.__explicitlySet__.add("viewId");
            return this;
        }

        public Builder scope(Scope scope) {
            this.scope = scope;
            this.__explicitlySet__.add("scope");
            return this;
        }

        public Builder externalMasters(List<ExternalMaster> externalMasters) {
            this.externalMasters = externalMasters;
            this.__explicitlySet__.add("externalMasters");
            return this;
        }

        public Builder externalDownstreams(List<ExternalDownstream> externalDownstreams) {
            this.externalDownstreams = externalDownstreams;
            this.__explicitlySet__.add("externalDownstreams");
            return this;
        }

        public CreateZoneDetails build() {
            CreateZoneDetails model = new CreateZoneDetails(this.name, this.compartmentId, this.freeformTags, this.definedTags, this.zoneType, this.viewId, this.scope, this.externalMasters, this.externalDownstreams);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(CreateZoneDetails model) {
            if (model.wasPropertyExplicitlySet("name")) {
                this.name(model.getName());
            }
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("freeformTags")) {
                this.freeformTags(model.getFreeformTags());
            }
            if (model.wasPropertyExplicitlySet("definedTags")) {
                this.definedTags(model.getDefinedTags());
            }
            if (model.wasPropertyExplicitlySet("zoneType")) {
                this.zoneType(model.getZoneType());
            }
            if (model.wasPropertyExplicitlySet("viewId")) {
                this.viewId(model.getViewId());
            }
            if (model.wasPropertyExplicitlySet("scope")) {
                this.scope(model.getScope());
            }
            if (model.wasPropertyExplicitlySet("externalMasters")) {
                this.externalMasters(model.getExternalMasters());
            }
            if (model.wasPropertyExplicitlySet("externalDownstreams")) {
                this.externalDownstreams(model.getExternalDownstreams());
            }
            return this;
        }
    }
}

