/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dns.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.dns.model.Scope;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.io.InputStream;
import java.util.Objects;

public class CreateZoneFromZoneFileRequest
extends BmcRequest<InputStream> {
    private String compartmentId;
    private InputStream createZoneFromZoneFileDetails;
    private String opcRequestId;
    private Scope scope;
    private String viewId;

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public InputStream getCreateZoneFromZoneFileDetails() {
        return this.createZoneFromZoneFileDetails;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Scope getScope() {
        return this.scope;
    }

    public String getViewId() {
        return this.viewId;
    }

    @InternalSdk
    public InputStream getBody$() {
        return this.createZoneFromZoneFileDetails;
    }

    public Builder toBuilder() {
        return new Builder().compartmentId(this.compartmentId).createZoneFromZoneFileDetails(this.createZoneFromZoneFileDetails).opcRequestId(this.opcRequestId).scope(this.scope).viewId(this.viewId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(",createZoneFromZoneFileDetails=").append(String.valueOf(this.createZoneFromZoneFileDetails));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",scope=").append(String.valueOf((Object)this.scope));
        sb.append(",viewId=").append(String.valueOf(this.viewId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CreateZoneFromZoneFileRequest)) {
            return false;
        }
        CreateZoneFromZoneFileRequest other = (CreateZoneFromZoneFileRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.createZoneFromZoneFileDetails, other.createZoneFromZoneFileDetails) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals((Object)this.scope, (Object)other.scope) && Objects.equals(this.viewId, other.viewId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.createZoneFromZoneFileDetails == null ? 43 : this.createZoneFromZoneFileDetails.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.scope == null ? 43 : this.scope.hashCode());
        result = result * 59 + (this.viewId == null ? 43 : this.viewId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<CreateZoneFromZoneFileRequest, InputStream> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String compartmentId = null;
        private InputStream createZoneFromZoneFileDetails = null;
        private String opcRequestId = null;
        private Scope scope = null;
        private String viewId = null;

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            return this;
        }

        public Builder createZoneFromZoneFileDetails(InputStream createZoneFromZoneFileDetails) {
            this.createZoneFromZoneFileDetails = createZoneFromZoneFileDetails;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder scope(Scope scope) {
            this.scope = scope;
            return this;
        }

        public Builder viewId(String viewId) {
            this.viewId = viewId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(CreateZoneFromZoneFileRequest o) {
            this.compartmentId(o.getCompartmentId());
            this.createZoneFromZoneFileDetails(o.getCreateZoneFromZoneFileDetails());
            this.opcRequestId(o.getOpcRequestId());
            this.scope(o.getScope());
            this.viewId(o.getViewId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public CreateZoneFromZoneFileRequest build() {
            CreateZoneFromZoneFileRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(InputStream body) {
            this.createZoneFromZoneFileDetails(body);
            return this;
        }

        public CreateZoneFromZoneFileRequest buildWithoutInvocationCallback() {
            CreateZoneFromZoneFileRequest request = new CreateZoneFromZoneFileRequest();
            request.compartmentId = this.compartmentId;
            request.createZoneFromZoneFileDetails = this.createZoneFromZoneFileDetails;
            request.opcRequestId = this.opcRequestId;
            request.scope = this.scope;
            request.viewId = this.viewId;
            return request;
        }
    }
}

