/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dns.requests;

import com.oracle.bmc.dns.model.Scope;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GetSteeringPolicyAttachmentRequest
extends BmcRequest<Void> {
    private String steeringPolicyAttachmentId;
    private String ifNoneMatch;
    private String ifModifiedSince;
    private String opcRequestId;
    private Scope scope;

    public String getSteeringPolicyAttachmentId() {
        return this.steeringPolicyAttachmentId;
    }

    public String getIfNoneMatch() {
        return this.ifNoneMatch;
    }

    public String getIfModifiedSince() {
        return this.ifModifiedSince;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Scope getScope() {
        return this.scope;
    }

    public Builder toBuilder() {
        return new Builder().steeringPolicyAttachmentId(this.steeringPolicyAttachmentId).ifNoneMatch(this.ifNoneMatch).ifModifiedSince(this.ifModifiedSince).opcRequestId(this.opcRequestId).scope(this.scope);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",steeringPolicyAttachmentId=").append(String.valueOf(this.steeringPolicyAttachmentId));
        sb.append(",ifNoneMatch=").append(String.valueOf(this.ifNoneMatch));
        sb.append(",ifModifiedSince=").append(String.valueOf(this.ifModifiedSince));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",scope=").append(String.valueOf((Object)this.scope));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetSteeringPolicyAttachmentRequest)) {
            return false;
        }
        GetSteeringPolicyAttachmentRequest other = (GetSteeringPolicyAttachmentRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.steeringPolicyAttachmentId, other.steeringPolicyAttachmentId) && Objects.equals(this.ifNoneMatch, other.ifNoneMatch) && Objects.equals(this.ifModifiedSince, other.ifModifiedSince) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals((Object)this.scope, (Object)other.scope);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.steeringPolicyAttachmentId == null ? 43 : this.steeringPolicyAttachmentId.hashCode());
        result = result * 59 + (this.ifNoneMatch == null ? 43 : this.ifNoneMatch.hashCode());
        result = result * 59 + (this.ifModifiedSince == null ? 43 : this.ifModifiedSince.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.scope == null ? 43 : this.scope.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetSteeringPolicyAttachmentRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String steeringPolicyAttachmentId = null;
        private String ifNoneMatch = null;
        private String ifModifiedSince = null;
        private String opcRequestId = null;
        private Scope scope = null;

        public Builder steeringPolicyAttachmentId(String steeringPolicyAttachmentId) {
            this.steeringPolicyAttachmentId = steeringPolicyAttachmentId;
            return this;
        }

        public Builder ifNoneMatch(String ifNoneMatch) {
            this.ifNoneMatch = ifNoneMatch;
            return this;
        }

        public Builder ifModifiedSince(String ifModifiedSince) {
            this.ifModifiedSince = ifModifiedSince;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder scope(Scope scope) {
            this.scope = scope;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetSteeringPolicyAttachmentRequest o) {
            this.steeringPolicyAttachmentId(o.getSteeringPolicyAttachmentId());
            this.ifNoneMatch(o.getIfNoneMatch());
            this.ifModifiedSince(o.getIfModifiedSince());
            this.opcRequestId(o.getOpcRequestId());
            this.scope(o.getScope());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetSteeringPolicyAttachmentRequest build() {
            GetSteeringPolicyAttachmentRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetSteeringPolicyAttachmentRequest buildWithoutInvocationCallback() {
            GetSteeringPolicyAttachmentRequest request = new GetSteeringPolicyAttachmentRequest();
            request.steeringPolicyAttachmentId = this.steeringPolicyAttachmentId;
            request.ifNoneMatch = this.ifNoneMatch;
            request.ifModifiedSince = this.ifModifiedSince;
            request.opcRequestId = this.opcRequestId;
            request.scope = this.scope;
            return request;
        }
    }
}

