/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dns.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.dns.model.Scope;
import com.oracle.bmc.dns.model.UpdateZoneDetails;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class UpdateZoneRequest
extends BmcRequest<UpdateZoneDetails> {
    private String zoneNameOrId;
    private UpdateZoneDetails updateZoneDetails;
    private String ifMatch;
    private String ifUnmodifiedSince;
    private String opcRequestId;
    private Scope scope;
    private String viewId;
    private String compartmentId;

    public String getZoneNameOrId() {
        return this.zoneNameOrId;
    }

    public UpdateZoneDetails getUpdateZoneDetails() {
        return this.updateZoneDetails;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public String getIfUnmodifiedSince() {
        return this.ifUnmodifiedSince;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Scope getScope() {
        return this.scope;
    }

    public String getViewId() {
        return this.viewId;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    @InternalSdk
    public UpdateZoneDetails getBody$() {
        return this.updateZoneDetails;
    }

    public Builder toBuilder() {
        return new Builder().zoneNameOrId(this.zoneNameOrId).updateZoneDetails(this.updateZoneDetails).ifMatch(this.ifMatch).ifUnmodifiedSince(this.ifUnmodifiedSince).opcRequestId(this.opcRequestId).scope(this.scope).viewId(this.viewId).compartmentId(this.compartmentId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",zoneNameOrId=").append(String.valueOf(this.zoneNameOrId));
        sb.append(",updateZoneDetails=").append(String.valueOf((Object)this.updateZoneDetails));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(",ifUnmodifiedSince=").append(String.valueOf(this.ifUnmodifiedSince));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",scope=").append(String.valueOf((Object)this.scope));
        sb.append(",viewId=").append(String.valueOf(this.viewId));
        sb.append(",compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UpdateZoneRequest)) {
            return false;
        }
        UpdateZoneRequest other = (UpdateZoneRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.zoneNameOrId, other.zoneNameOrId) && Objects.equals((Object)this.updateZoneDetails, (Object)other.updateZoneDetails) && Objects.equals(this.ifMatch, other.ifMatch) && Objects.equals(this.ifUnmodifiedSince, other.ifUnmodifiedSince) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals((Object)this.scope, (Object)other.scope) && Objects.equals(this.viewId, other.viewId) && Objects.equals(this.compartmentId, other.compartmentId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.zoneNameOrId == null ? 43 : this.zoneNameOrId.hashCode());
        result = result * 59 + (this.updateZoneDetails == null ? 43 : this.updateZoneDetails.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        result = result * 59 + (this.ifUnmodifiedSince == null ? 43 : this.ifUnmodifiedSince.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.scope == null ? 43 : this.scope.hashCode());
        result = result * 59 + (this.viewId == null ? 43 : this.viewId.hashCode());
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<UpdateZoneRequest, UpdateZoneDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String zoneNameOrId = null;
        private UpdateZoneDetails updateZoneDetails = null;
        private String ifMatch = null;
        private String ifUnmodifiedSince = null;
        private String opcRequestId = null;
        private Scope scope = null;
        private String viewId = null;
        private String compartmentId = null;

        public Builder zoneNameOrId(String zoneNameOrId) {
            this.zoneNameOrId = zoneNameOrId;
            return this;
        }

        public Builder updateZoneDetails(UpdateZoneDetails updateZoneDetails) {
            this.updateZoneDetails = updateZoneDetails;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder ifUnmodifiedSince(String ifUnmodifiedSince) {
            this.ifUnmodifiedSince = ifUnmodifiedSince;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder scope(Scope scope) {
            this.scope = scope;
            return this;
        }

        public Builder viewId(String viewId) {
            this.viewId = viewId;
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(UpdateZoneRequest o) {
            this.zoneNameOrId(o.getZoneNameOrId());
            this.updateZoneDetails(o.getUpdateZoneDetails());
            this.ifMatch(o.getIfMatch());
            this.ifUnmodifiedSince(o.getIfUnmodifiedSince());
            this.opcRequestId(o.getOpcRequestId());
            this.scope(o.getScope());
            this.viewId(o.getViewId());
            this.compartmentId(o.getCompartmentId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public UpdateZoneRequest build() {
            UpdateZoneRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(UpdateZoneDetails body) {
            this.updateZoneDetails(body);
            return this;
        }

        public UpdateZoneRequest buildWithoutInvocationCallback() {
            UpdateZoneRequest request = new UpdateZoneRequest();
            request.zoneNameOrId = this.zoneNameOrId;
            request.updateZoneDetails = this.updateZoneDetails;
            request.ifMatch = this.ifMatch;
            request.ifUnmodifiedSince = this.ifUnmodifiedSince;
            request.opcRequestId = this.opcRequestId;
            request.scope = this.scope;
            request.viewId = this.viewId;
            request.compartmentId = this.compartmentId;
            return request;
        }
    }
}

