/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dns.responses;

import com.oracle.bmc.dns.model.SteeringPolicy;
import com.oracle.bmc.responses.BmcResponse;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class GetSteeringPolicyResponse
extends BmcResponse {
    private String opcRequestId;
    private String eTag;
    private SteeringPolicy steeringPolicy;
    private boolean isNotModified;

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getETag() {
        return this.eTag;
    }

    public SteeringPolicy getSteeringPolicy() {
        return this.steeringPolicy;
    }

    public boolean isNotModified() {
        return this.isNotModified;
    }

    @ConstructorProperties(value={"__httpStatusCode__", "headers", "opcRequestId", "eTag", "steeringPolicy", "isNotModified"})
    private GetSteeringPolicyResponse(int __httpStatusCode__, Map<String, List<String>> headers, String opcRequestId, String eTag, SteeringPolicy steeringPolicy, boolean isNotModified) {
        super(__httpStatusCode__, headers);
        this.opcRequestId = opcRequestId;
        this.eTag = eTag;
        this.steeringPolicy = steeringPolicy;
        this.isNotModified = isNotModified;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",eTag=").append(String.valueOf(this.eTag));
        sb.append(",steeringPolicy=").append(String.valueOf((Object)this.steeringPolicy));
        sb.append(",isNotModified=").append(this.isNotModified);
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetSteeringPolicyResponse)) {
            return false;
        }
        GetSteeringPolicyResponse other = (GetSteeringPolicyResponse)((Object)o);
        return super.equals(o) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.eTag, other.eTag) && Objects.equals((Object)this.steeringPolicy, (Object)other.steeringPolicy) && this.isNotModified == other.isNotModified;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.eTag == null ? 43 : this.eTag.hashCode());
        result = result * 59 + (this.steeringPolicy == null ? 43 : this.steeringPolicy.hashCode());
        result = result * 59 + (this.isNotModified ? 79 : 97);
        return result;
    }

    public static class Builder
    implements BmcResponse.Builder<GetSteeringPolicyResponse> {
        private int __httpStatusCode__;
        private Map<String, List<String>> headers;
        private String opcRequestId;
        private String eTag;
        private SteeringPolicy steeringPolicy;
        private boolean isNotModified;

        public Builder __httpStatusCode__(int __httpStatusCode__) {
            this.__httpStatusCode__ = __httpStatusCode__;
            return this;
        }

        public Builder headers(Map<String, List<String>> headers) {
            this.headers = headers;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder eTag(String eTag) {
            this.eTag = eTag;
            return this;
        }

        public Builder steeringPolicy(SteeringPolicy steeringPolicy) {
            this.steeringPolicy = steeringPolicy;
            return this;
        }

        public Builder isNotModified(boolean isNotModified) {
            this.isNotModified = isNotModified;
            return this;
        }

        public Builder copy(GetSteeringPolicyResponse o) {
            this.__httpStatusCode__(o.get__httpStatusCode__());
            this.headers(o.getHeaders());
            this.opcRequestId(o.getOpcRequestId());
            this.eTag(o.getETag());
            this.steeringPolicy(o.getSteeringPolicy());
            this.isNotModified(o.isNotModified());
            return this;
        }

        public GetSteeringPolicyResponse build() {
            return new GetSteeringPolicyResponse(this.__httpStatusCode__, this.headers, this.opcRequestId, this.eTag, this.steeringPolicy, this.isNotModified);
        }
    }
}

