/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dns;

import com.oracle.bmc.dns.Dns;
import com.oracle.bmc.dns.model.Resolver;
import com.oracle.bmc.dns.model.ResolverEndpoint;
import com.oracle.bmc.dns.model.SteeringPolicy;
import com.oracle.bmc.dns.model.SteeringPolicyAttachment;
import com.oracle.bmc.dns.model.TsigKey;
import com.oracle.bmc.dns.model.View;
import com.oracle.bmc.dns.model.Zone;
import com.oracle.bmc.dns.requests.GetResolverEndpointRequest;
import com.oracle.bmc.dns.requests.GetResolverRequest;
import com.oracle.bmc.dns.requests.GetSteeringPolicyAttachmentRequest;
import com.oracle.bmc.dns.requests.GetSteeringPolicyRequest;
import com.oracle.bmc.dns.requests.GetTsigKeyRequest;
import com.oracle.bmc.dns.requests.GetViewRequest;
import com.oracle.bmc.dns.requests.GetZoneRequest;
import com.oracle.bmc.dns.responses.GetResolverEndpointResponse;
import com.oracle.bmc.dns.responses.GetResolverResponse;
import com.oracle.bmc.dns.responses.GetSteeringPolicyAttachmentResponse;
import com.oracle.bmc.dns.responses.GetSteeringPolicyResponse;
import com.oracle.bmc.dns.responses.GetTsigKeyResponse;
import com.oracle.bmc.dns.responses.GetViewResponse;
import com.oracle.bmc.dns.responses.GetZoneResponse;
import com.oracle.bmc.util.internal.Validate;
import com.oracle.bmc.waiter.BmcGenericWaiter;
import com.oracle.bmc.waiter.DelayStrategy;
import com.oracle.bmc.waiter.TerminationStrategy;
import com.oracle.bmc.waiter.Waiter;
import com.oracle.bmc.waiter.Waiters;
import com.oracle.bmc.waiter.internal.SimpleWaiterImpl;
import java.util.Arrays;
import java.util.HashSet;
import java.util.concurrent.ExecutorService;
import java.util.function.Function;
import java.util.function.Predicate;

public class DnsWaiters {
    private final ExecutorService executorService;
    private final Dns client;

    public DnsWaiters(ExecutorService executorService, Dns client) {
        this.executorService = executorService;
        this.client = client;
    }

    public Waiter<GetResolverRequest, GetResolverResponse> forResolver(GetResolverRequest request, Resolver.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forResolver(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetResolverRequest, GetResolverResponse> forResolver(GetResolverRequest request, Resolver.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forResolver(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetResolverRequest, GetResolverResponse> forResolver(GetResolverRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, Resolver.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forResolver(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetResolverRequest, GetResolverResponse> forResolver(BmcGenericWaiter waiter, GetResolverRequest request, Resolver.LifecycleState ... targetStates) {
        final HashSet<Resolver.LifecycleState> targetStatesSet = new HashSet<Resolver.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetResolverRequest, GetResolverResponse>(){

            @Override
            public GetResolverResponse apply(GetResolverRequest request) {
                return DnsWaiters.this.client.getResolver(request);
            }
        }, (Predicate)new Predicate<GetResolverResponse>(){

            @Override
            public boolean test(GetResolverResponse response) {
                return targetStatesSet.contains((Object)response.getResolver().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)Resolver.LifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetResolverEndpointRequest, GetResolverEndpointResponse> forResolverEndpoint(GetResolverEndpointRequest request, ResolverEndpoint.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forResolverEndpoint(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetResolverEndpointRequest, GetResolverEndpointResponse> forResolverEndpoint(GetResolverEndpointRequest request, ResolverEndpoint.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forResolverEndpoint(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetResolverEndpointRequest, GetResolverEndpointResponse> forResolverEndpoint(GetResolverEndpointRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, ResolverEndpoint.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forResolverEndpoint(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetResolverEndpointRequest, GetResolverEndpointResponse> forResolverEndpoint(BmcGenericWaiter waiter, GetResolverEndpointRequest request, ResolverEndpoint.LifecycleState ... targetStates) {
        final HashSet<ResolverEndpoint.LifecycleState> targetStatesSet = new HashSet<ResolverEndpoint.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetResolverEndpointRequest, GetResolverEndpointResponse>(){

            @Override
            public GetResolverEndpointResponse apply(GetResolverEndpointRequest request) {
                return DnsWaiters.this.client.getResolverEndpoint(request);
            }
        }, (Predicate)new Predicate<GetResolverEndpointResponse>(){

            @Override
            public boolean test(GetResolverEndpointResponse response) {
                return targetStatesSet.contains((Object)response.getResolverEndpoint().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)ResolverEndpoint.LifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetSteeringPolicyRequest, GetSteeringPolicyResponse> forSteeringPolicy(GetSteeringPolicyRequest request, SteeringPolicy.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forSteeringPolicy(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetSteeringPolicyRequest, GetSteeringPolicyResponse> forSteeringPolicy(GetSteeringPolicyRequest request, SteeringPolicy.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forSteeringPolicy(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetSteeringPolicyRequest, GetSteeringPolicyResponse> forSteeringPolicy(GetSteeringPolicyRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, SteeringPolicy.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forSteeringPolicy(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetSteeringPolicyRequest, GetSteeringPolicyResponse> forSteeringPolicy(BmcGenericWaiter waiter, GetSteeringPolicyRequest request, SteeringPolicy.LifecycleState ... targetStates) {
        final HashSet<SteeringPolicy.LifecycleState> targetStatesSet = new HashSet<SteeringPolicy.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetSteeringPolicyRequest, GetSteeringPolicyResponse>(){

            @Override
            public GetSteeringPolicyResponse apply(GetSteeringPolicyRequest request) {
                return DnsWaiters.this.client.getSteeringPolicy(request);
            }
        }, (Predicate)new Predicate<GetSteeringPolicyResponse>(){

            @Override
            public boolean test(GetSteeringPolicyResponse response) {
                return targetStatesSet.contains((Object)response.getSteeringPolicy().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)SteeringPolicy.LifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetSteeringPolicyAttachmentRequest, GetSteeringPolicyAttachmentResponse> forSteeringPolicyAttachment(GetSteeringPolicyAttachmentRequest request, SteeringPolicyAttachment.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forSteeringPolicyAttachment(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetSteeringPolicyAttachmentRequest, GetSteeringPolicyAttachmentResponse> forSteeringPolicyAttachment(GetSteeringPolicyAttachmentRequest request, SteeringPolicyAttachment.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forSteeringPolicyAttachment(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetSteeringPolicyAttachmentRequest, GetSteeringPolicyAttachmentResponse> forSteeringPolicyAttachment(GetSteeringPolicyAttachmentRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, SteeringPolicyAttachment.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forSteeringPolicyAttachment(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetSteeringPolicyAttachmentRequest, GetSteeringPolicyAttachmentResponse> forSteeringPolicyAttachment(BmcGenericWaiter waiter, GetSteeringPolicyAttachmentRequest request, SteeringPolicyAttachment.LifecycleState ... targetStates) {
        final HashSet<SteeringPolicyAttachment.LifecycleState> targetStatesSet = new HashSet<SteeringPolicyAttachment.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetSteeringPolicyAttachmentRequest, GetSteeringPolicyAttachmentResponse>(){

            @Override
            public GetSteeringPolicyAttachmentResponse apply(GetSteeringPolicyAttachmentRequest request) {
                return DnsWaiters.this.client.getSteeringPolicyAttachment(request);
            }
        }, (Predicate)new Predicate<GetSteeringPolicyAttachmentResponse>(){

            @Override
            public boolean test(GetSteeringPolicyAttachmentResponse response) {
                return targetStatesSet.contains((Object)response.getSteeringPolicyAttachment().getLifecycleState());
            }
        }, false), (Object)request);
    }

    public Waiter<GetTsigKeyRequest, GetTsigKeyResponse> forTsigKey(GetTsigKeyRequest request, TsigKey.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forTsigKey(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetTsigKeyRequest, GetTsigKeyResponse> forTsigKey(GetTsigKeyRequest request, TsigKey.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forTsigKey(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetTsigKeyRequest, GetTsigKeyResponse> forTsigKey(GetTsigKeyRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, TsigKey.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forTsigKey(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetTsigKeyRequest, GetTsigKeyResponse> forTsigKey(BmcGenericWaiter waiter, GetTsigKeyRequest request, TsigKey.LifecycleState ... targetStates) {
        final HashSet<TsigKey.LifecycleState> targetStatesSet = new HashSet<TsigKey.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetTsigKeyRequest, GetTsigKeyResponse>(){

            @Override
            public GetTsigKeyResponse apply(GetTsigKeyRequest request) {
                return DnsWaiters.this.client.getTsigKey(request);
            }
        }, (Predicate)new Predicate<GetTsigKeyResponse>(){

            @Override
            public boolean test(GetTsigKeyResponse response) {
                return targetStatesSet.contains((Object)response.getTsigKey().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)TsigKey.LifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetViewRequest, GetViewResponse> forView(GetViewRequest request, View.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forView(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetViewRequest, GetViewResponse> forView(GetViewRequest request, View.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forView(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetViewRequest, GetViewResponse> forView(GetViewRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, View.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forView(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetViewRequest, GetViewResponse> forView(BmcGenericWaiter waiter, GetViewRequest request, View.LifecycleState ... targetStates) {
        final HashSet<View.LifecycleState> targetStatesSet = new HashSet<View.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetViewRequest, GetViewResponse>(){

            @Override
            public GetViewResponse apply(GetViewRequest request) {
                return DnsWaiters.this.client.getView(request);
            }
        }, (Predicate)new Predicate<GetViewResponse>(){

            @Override
            public boolean test(GetViewResponse response) {
                return targetStatesSet.contains((Object)response.getView().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)View.LifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetZoneRequest, GetZoneResponse> forZone(GetZoneRequest request, Zone.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forZone(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetZoneRequest, GetZoneResponse> forZone(GetZoneRequest request, Zone.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forZone(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetZoneRequest, GetZoneResponse> forZone(GetZoneRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, Zone.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forZone(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetZoneRequest, GetZoneResponse> forZone(BmcGenericWaiter waiter, GetZoneRequest request, Zone.LifecycleState ... targetStates) {
        final HashSet<Zone.LifecycleState> targetStatesSet = new HashSet<Zone.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetZoneRequest, GetZoneResponse>(){

            @Override
            public GetZoneResponse apply(GetZoneRequest request) {
                return DnsWaiters.this.client.getZone(request);
            }
        }, (Predicate)new Predicate<GetZoneResponse>(){

            @Override
            public boolean test(GetZoneResponse response) {
                return targetStatesSet.contains((Object)response.getZone().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)Zone.LifecycleState.Deleted)), (Object)request);
    }
}

