/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dns.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.dns.model.ResolverVnicEndpoint;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="endpointType", defaultImpl=ResolverEndpoint.class)
@JsonSubTypes(value={@JsonSubTypes.Type(value=ResolverVnicEndpoint.class, name="VNIC")})
@JsonFilter(value="explicitlySetFilter")
public class ResolverEndpoint
extends ExplicitlySetBmcModel {
    @JsonProperty(value="name")
    private final String name;
    @JsonProperty(value="forwardingAddress")
    private final String forwardingAddress;
    @JsonProperty(value="isForwarding")
    private final Boolean isForwarding;
    @JsonProperty(value="isListening")
    private final Boolean isListening;
    @JsonProperty(value="listeningAddress")
    private final String listeningAddress;
    @JsonProperty(value="compartmentId")
    private final String compartmentId;
    @JsonProperty(value="timeCreated")
    private final Date timeCreated;
    @JsonProperty(value="timeUpdated")
    private final Date timeUpdated;
    @JsonProperty(value="lifecycleState")
    private final LifecycleState lifecycleState;
    @JsonProperty(value="self")
    private final String self;

    @Deprecated
    @ConstructorProperties(value={"name", "forwardingAddress", "isForwarding", "isListening", "listeningAddress", "compartmentId", "timeCreated", "timeUpdated", "lifecycleState", "self"})
    protected ResolverEndpoint(String name, String forwardingAddress, Boolean isForwarding, Boolean isListening, String listeningAddress, String compartmentId, Date timeCreated, Date timeUpdated, LifecycleState lifecycleState, String self) {
        this.name = name;
        this.forwardingAddress = forwardingAddress;
        this.isForwarding = isForwarding;
        this.isListening = isListening;
        this.listeningAddress = listeningAddress;
        this.compartmentId = compartmentId;
        this.timeCreated = timeCreated;
        this.timeUpdated = timeUpdated;
        this.lifecycleState = lifecycleState;
        this.self = self;
    }

    public String getName() {
        return this.name;
    }

    public String getForwardingAddress() {
        return this.forwardingAddress;
    }

    public Boolean getIsForwarding() {
        return this.isForwarding;
    }

    public Boolean getIsListening() {
        return this.isListening;
    }

    public String getListeningAddress() {
        return this.listeningAddress;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public Date getTimeCreated() {
        return this.timeCreated;
    }

    public Date getTimeUpdated() {
        return this.timeUpdated;
    }

    public LifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public String getSelf() {
        return this.self;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("ResolverEndpoint(");
        sb.append("super=").append(super.toString());
        sb.append("name=").append(String.valueOf(this.name));
        sb.append(", forwardingAddress=").append(String.valueOf(this.forwardingAddress));
        sb.append(", isForwarding=").append(String.valueOf(this.isForwarding));
        sb.append(", isListening=").append(String.valueOf(this.isListening));
        sb.append(", listeningAddress=").append(String.valueOf(this.listeningAddress));
        sb.append(", compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(", timeCreated=").append(String.valueOf(this.timeCreated));
        sb.append(", timeUpdated=").append(String.valueOf(this.timeUpdated));
        sb.append(", lifecycleState=").append(String.valueOf((Object)this.lifecycleState));
        sb.append(", self=").append(String.valueOf(this.self));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ResolverEndpoint)) {
            return false;
        }
        ResolverEndpoint other = (ResolverEndpoint)((Object)o);
        return Objects.equals(this.name, other.name) && Objects.equals(this.forwardingAddress, other.forwardingAddress) && Objects.equals(this.isForwarding, other.isForwarding) && Objects.equals(this.isListening, other.isListening) && Objects.equals(this.listeningAddress, other.listeningAddress) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.timeCreated, other.timeCreated) && Objects.equals(this.timeUpdated, other.timeUpdated) && Objects.equals((Object)this.lifecycleState, (Object)other.lifecycleState) && Objects.equals(this.self, other.self) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.name == null ? 43 : this.name.hashCode());
        result = result * 59 + (this.forwardingAddress == null ? 43 : this.forwardingAddress.hashCode());
        result = result * 59 + (this.isForwarding == null ? 43 : this.isForwarding.hashCode());
        result = result * 59 + (this.isListening == null ? 43 : this.isListening.hashCode());
        result = result * 59 + (this.listeningAddress == null ? 43 : this.listeningAddress.hashCode());
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.timeCreated == null ? 43 : this.timeCreated.hashCode());
        result = result * 59 + (this.timeUpdated == null ? 43 : this.timeUpdated.hashCode());
        result = result * 59 + (this.lifecycleState == null ? 43 : this.lifecycleState.hashCode());
        result = result * 59 + (this.self == null ? 43 : this.self.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum EndpointType implements BmcEnum
    {
        Vnic("VNIC"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, EndpointType> map;

        private EndpointType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static EndpointType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'EndpointType', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(EndpointType.class);
            map = new HashMap<String, EndpointType>();
            for (EndpointType v : EndpointType.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum LifecycleState implements BmcEnum
    {
        Active("ACTIVE"),
        Creating("CREATING"),
        Deleted("DELETED"),
        Deleting("DELETING"),
        Failed("FAILED"),
        Updating("UPDATING"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, LifecycleState> map;

        private LifecycleState(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static LifecycleState create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'LifecycleState', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(LifecycleState.class);
            map = new HashMap<String, LifecycleState>();
            for (LifecycleState v : LifecycleState.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }
}

