/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dns.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.dns.model.ResolverRule;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="action")
@JsonFilter(value="explicitlySetFilter")
public final class ResolverForwardRule
extends ResolverRule {
    @JsonProperty(value="destinationAddresses")
    private final List<String> destinationAddresses;
    @JsonProperty(value="sourceEndpointName")
    private final String sourceEndpointName;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public ResolverForwardRule(List<String> clientAddressConditions, List<String> qnameCoverConditions, List<String> destinationAddresses, String sourceEndpointName) {
        super(clientAddressConditions, qnameCoverConditions);
        this.destinationAddresses = destinationAddresses;
        this.sourceEndpointName = sourceEndpointName;
    }

    public List<String> getDestinationAddresses() {
        return this.destinationAddresses;
    }

    public String getSourceEndpointName() {
        return this.sourceEndpointName;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("ResolverForwardRule(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", destinationAddresses=").append(String.valueOf(this.destinationAddresses));
        sb.append(", sourceEndpointName=").append(String.valueOf(this.sourceEndpointName));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ResolverForwardRule)) {
            return false;
        }
        ResolverForwardRule other = (ResolverForwardRule)((Object)o);
        return Objects.equals(this.destinationAddresses, other.destinationAddresses) && Objects.equals(this.sourceEndpointName, other.sourceEndpointName) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.destinationAddresses == null ? 43 : this.destinationAddresses.hashCode());
        result = result * 59 + (this.sourceEndpointName == null ? 43 : this.sourceEndpointName.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="clientAddressConditions")
        private List<String> clientAddressConditions;
        @JsonProperty(value="qnameCoverConditions")
        private List<String> qnameCoverConditions;
        @JsonProperty(value="destinationAddresses")
        private List<String> destinationAddresses;
        @JsonProperty(value="sourceEndpointName")
        private String sourceEndpointName;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder clientAddressConditions(List<String> clientAddressConditions) {
            this.clientAddressConditions = clientAddressConditions;
            this.__explicitlySet__.add("clientAddressConditions");
            return this;
        }

        public Builder qnameCoverConditions(List<String> qnameCoverConditions) {
            this.qnameCoverConditions = qnameCoverConditions;
            this.__explicitlySet__.add("qnameCoverConditions");
            return this;
        }

        public Builder destinationAddresses(List<String> destinationAddresses) {
            this.destinationAddresses = destinationAddresses;
            this.__explicitlySet__.add("destinationAddresses");
            return this;
        }

        public Builder sourceEndpointName(String sourceEndpointName) {
            this.sourceEndpointName = sourceEndpointName;
            this.__explicitlySet__.add("sourceEndpointName");
            return this;
        }

        public ResolverForwardRule build() {
            ResolverForwardRule model = new ResolverForwardRule(this.clientAddressConditions, this.qnameCoverConditions, this.destinationAddresses, this.sourceEndpointName);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(ResolverForwardRule model) {
            if (model.wasPropertyExplicitlySet("clientAddressConditions")) {
                this.clientAddressConditions(model.getClientAddressConditions());
            }
            if (model.wasPropertyExplicitlySet("qnameCoverConditions")) {
                this.qnameCoverConditions(model.getQnameCoverConditions());
            }
            if (model.wasPropertyExplicitlySet("destinationAddresses")) {
                this.destinationAddresses(model.getDestinationAddresses());
            }
            if (model.wasPropertyExplicitlySet("sourceEndpointName")) {
                this.sourceEndpointName(model.getSourceEndpointName());
            }
            return this;
        }
    }
}

