/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dns.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.dns.model.Scope;
import com.oracle.bmc.dns.model.SortOrder;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class GetDomainRecordsRequest
extends BmcRequest<Void> {
    private String zoneNameOrId;
    private String domain;
    private String ifNoneMatch;
    private String ifModifiedSince;
    private String opcRequestId;
    private Long limit;
    private String page;
    private String zoneVersion;
    private String rtype;
    private Scope scope;
    private String viewId;
    private SortBy sortBy;
    private SortOrder sortOrder;
    private String compartmentId;

    public String getZoneNameOrId() {
        return this.zoneNameOrId;
    }

    public String getDomain() {
        return this.domain;
    }

    public String getIfNoneMatch() {
        return this.ifNoneMatch;
    }

    public String getIfModifiedSince() {
        return this.ifModifiedSince;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Long getLimit() {
        return this.limit;
    }

    public String getPage() {
        return this.page;
    }

    public String getZoneVersion() {
        return this.zoneVersion;
    }

    public String getRtype() {
        return this.rtype;
    }

    public Scope getScope() {
        return this.scope;
    }

    public String getViewId() {
        return this.viewId;
    }

    public SortBy getSortBy() {
        return this.sortBy;
    }

    public SortOrder getSortOrder() {
        return this.sortOrder;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public Builder toBuilder() {
        return new Builder().zoneNameOrId(this.zoneNameOrId).domain(this.domain).ifNoneMatch(this.ifNoneMatch).ifModifiedSince(this.ifModifiedSince).opcRequestId(this.opcRequestId).limit(this.limit).page(this.page).zoneVersion(this.zoneVersion).rtype(this.rtype).scope(this.scope).viewId(this.viewId).sortBy(this.sortBy).sortOrder(this.sortOrder).compartmentId(this.compartmentId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",zoneNameOrId=").append(String.valueOf(this.zoneNameOrId));
        sb.append(",domain=").append(String.valueOf(this.domain));
        sb.append(",ifNoneMatch=").append(String.valueOf(this.ifNoneMatch));
        sb.append(",ifModifiedSince=").append(String.valueOf(this.ifModifiedSince));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",limit=").append(String.valueOf(this.limit));
        sb.append(",page=").append(String.valueOf(this.page));
        sb.append(",zoneVersion=").append(String.valueOf(this.zoneVersion));
        sb.append(",rtype=").append(String.valueOf(this.rtype));
        sb.append(",scope=").append(String.valueOf((Object)this.scope));
        sb.append(",viewId=").append(String.valueOf(this.viewId));
        sb.append(",sortBy=").append(String.valueOf((Object)this.sortBy));
        sb.append(",sortOrder=").append(String.valueOf((Object)this.sortOrder));
        sb.append(",compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetDomainRecordsRequest)) {
            return false;
        }
        GetDomainRecordsRequest other = (GetDomainRecordsRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.zoneNameOrId, other.zoneNameOrId) && Objects.equals(this.domain, other.domain) && Objects.equals(this.ifNoneMatch, other.ifNoneMatch) && Objects.equals(this.ifModifiedSince, other.ifModifiedSince) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.limit, other.limit) && Objects.equals(this.page, other.page) && Objects.equals(this.zoneVersion, other.zoneVersion) && Objects.equals(this.rtype, other.rtype) && Objects.equals((Object)this.scope, (Object)other.scope) && Objects.equals(this.viewId, other.viewId) && Objects.equals((Object)this.sortBy, (Object)other.sortBy) && Objects.equals((Object)this.sortOrder, (Object)other.sortOrder) && Objects.equals(this.compartmentId, other.compartmentId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.zoneNameOrId == null ? 43 : this.zoneNameOrId.hashCode());
        result = result * 59 + (this.domain == null ? 43 : this.domain.hashCode());
        result = result * 59 + (this.ifNoneMatch == null ? 43 : this.ifNoneMatch.hashCode());
        result = result * 59 + (this.ifModifiedSince == null ? 43 : this.ifModifiedSince.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.limit == null ? 43 : this.limit.hashCode());
        result = result * 59 + (this.page == null ? 43 : this.page.hashCode());
        result = result * 59 + (this.zoneVersion == null ? 43 : this.zoneVersion.hashCode());
        result = result * 59 + (this.rtype == null ? 43 : this.rtype.hashCode());
        result = result * 59 + (this.scope == null ? 43 : this.scope.hashCode());
        result = result * 59 + (this.viewId == null ? 43 : this.viewId.hashCode());
        result = result * 59 + (this.sortBy == null ? 43 : this.sortBy.hashCode());
        result = result * 59 + (this.sortOrder == null ? 43 : this.sortOrder.hashCode());
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetDomainRecordsRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String zoneNameOrId = null;
        private String domain = null;
        private String ifNoneMatch = null;
        private String ifModifiedSince = null;
        private String opcRequestId = null;
        private Long limit = null;
        private String page = null;
        private String zoneVersion = null;
        private String rtype = null;
        private Scope scope = null;
        private String viewId = null;
        private SortBy sortBy = null;
        private SortOrder sortOrder = null;
        private String compartmentId = null;

        public Builder zoneNameOrId(String zoneNameOrId) {
            this.zoneNameOrId = zoneNameOrId;
            return this;
        }

        public Builder domain(String domain) {
            this.domain = domain;
            return this;
        }

        public Builder ifNoneMatch(String ifNoneMatch) {
            this.ifNoneMatch = ifNoneMatch;
            return this;
        }

        public Builder ifModifiedSince(String ifModifiedSince) {
            this.ifModifiedSince = ifModifiedSince;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder limit(Long limit) {
            this.limit = limit;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder zoneVersion(String zoneVersion) {
            this.zoneVersion = zoneVersion;
            return this;
        }

        public Builder rtype(String rtype) {
            this.rtype = rtype;
            return this;
        }

        public Builder scope(Scope scope) {
            this.scope = scope;
            return this;
        }

        public Builder viewId(String viewId) {
            this.viewId = viewId;
            return this;
        }

        public Builder sortBy(SortBy sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        public Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetDomainRecordsRequest o) {
            this.zoneNameOrId(o.getZoneNameOrId());
            this.domain(o.getDomain());
            this.ifNoneMatch(o.getIfNoneMatch());
            this.ifModifiedSince(o.getIfModifiedSince());
            this.opcRequestId(o.getOpcRequestId());
            this.limit(o.getLimit());
            this.page(o.getPage());
            this.zoneVersion(o.getZoneVersion());
            this.rtype(o.getRtype());
            this.scope(o.getScope());
            this.viewId(o.getViewId());
            this.sortBy(o.getSortBy());
            this.sortOrder(o.getSortOrder());
            this.compartmentId(o.getCompartmentId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetDomainRecordsRequest build() {
            GetDomainRecordsRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetDomainRecordsRequest buildWithoutInvocationCallback() {
            GetDomainRecordsRequest request = new GetDomainRecordsRequest();
            request.zoneNameOrId = this.zoneNameOrId;
            request.domain = this.domain;
            request.ifNoneMatch = this.ifNoneMatch;
            request.ifModifiedSince = this.ifModifiedSince;
            request.opcRequestId = this.opcRequestId;
            request.limit = this.limit;
            request.page = this.page;
            request.zoneVersion = this.zoneVersion;
            request.rtype = this.rtype;
            request.scope = this.scope;
            request.viewId = this.viewId;
            request.sortBy = this.sortBy;
            request.sortOrder = this.sortOrder;
            request.compartmentId = this.compartmentId;
            return request;
        }
    }

    public static enum SortBy implements BmcEnum
    {
        Rtype("rtype"),
        Ttl("ttl");

        private final String value;
        private static Map<String, SortBy> map;

        private SortBy(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortBy create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortBy: " + key);
        }

        static {
            map = new HashMap<String, SortBy>();
            for (SortBy v : SortBy.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

