/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dns.requests;

import com.oracle.bmc.dns.model.Scope;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GetResolverRequest
extends BmcRequest<Void> {
    private String resolverId;
    private String ifModifiedSince;
    private String ifNoneMatch;
    private String opcRequestId;
    private Scope scope;

    public String getResolverId() {
        return this.resolverId;
    }

    public String getIfModifiedSince() {
        return this.ifModifiedSince;
    }

    public String getIfNoneMatch() {
        return this.ifNoneMatch;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Scope getScope() {
        return this.scope;
    }

    public Builder toBuilder() {
        return new Builder().resolverId(this.resolverId).ifModifiedSince(this.ifModifiedSince).ifNoneMatch(this.ifNoneMatch).opcRequestId(this.opcRequestId).scope(this.scope);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",resolverId=").append(String.valueOf(this.resolverId));
        sb.append(",ifModifiedSince=").append(String.valueOf(this.ifModifiedSince));
        sb.append(",ifNoneMatch=").append(String.valueOf(this.ifNoneMatch));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",scope=").append(String.valueOf((Object)this.scope));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetResolverRequest)) {
            return false;
        }
        GetResolverRequest other = (GetResolverRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.resolverId, other.resolverId) && Objects.equals(this.ifModifiedSince, other.ifModifiedSince) && Objects.equals(this.ifNoneMatch, other.ifNoneMatch) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals((Object)this.scope, (Object)other.scope);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.resolverId == null ? 43 : this.resolverId.hashCode());
        result = result * 59 + (this.ifModifiedSince == null ? 43 : this.ifModifiedSince.hashCode());
        result = result * 59 + (this.ifNoneMatch == null ? 43 : this.ifNoneMatch.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.scope == null ? 43 : this.scope.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetResolverRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String resolverId = null;
        private String ifModifiedSince = null;
        private String ifNoneMatch = null;
        private String opcRequestId = null;
        private Scope scope = null;

        public Builder resolverId(String resolverId) {
            this.resolverId = resolverId;
            return this;
        }

        public Builder ifModifiedSince(String ifModifiedSince) {
            this.ifModifiedSince = ifModifiedSince;
            return this;
        }

        public Builder ifNoneMatch(String ifNoneMatch) {
            this.ifNoneMatch = ifNoneMatch;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder scope(Scope scope) {
            this.scope = scope;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetResolverRequest o) {
            this.resolverId(o.getResolverId());
            this.ifModifiedSince(o.getIfModifiedSince());
            this.ifNoneMatch(o.getIfNoneMatch());
            this.opcRequestId(o.getOpcRequestId());
            this.scope(o.getScope());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetResolverRequest build() {
            GetResolverRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetResolverRequest buildWithoutInvocationCallback() {
            GetResolverRequest request = new GetResolverRequest();
            request.resolverId = this.resolverId;
            request.ifModifiedSince = this.ifModifiedSince;
            request.ifNoneMatch = this.ifNoneMatch;
            request.opcRequestId = this.opcRequestId;
            request.scope = this.scope;
            return request;
        }
    }
}

