/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dns;

import com.oracle.bmc.dns.Dns;
import com.oracle.bmc.dns.model.Resolver;
import com.oracle.bmc.dns.model.ResolverEndpoint;
import com.oracle.bmc.dns.model.SteeringPolicy;
import com.oracle.bmc.dns.model.SteeringPolicyAttachment;
import com.oracle.bmc.dns.model.TsigKey;
import com.oracle.bmc.dns.model.View;
import com.oracle.bmc.dns.model.Zone;
import com.oracle.bmc.dns.requests.ChangeResolverCompartmentRequest;
import com.oracle.bmc.dns.requests.ChangeSteeringPolicyCompartmentRequest;
import com.oracle.bmc.dns.requests.ChangeViewCompartmentRequest;
import com.oracle.bmc.dns.requests.ChangeZoneCompartmentRequest;
import com.oracle.bmc.dns.requests.CreateResolverEndpointRequest;
import com.oracle.bmc.dns.requests.CreateSteeringPolicyAttachmentRequest;
import com.oracle.bmc.dns.requests.CreateSteeringPolicyRequest;
import com.oracle.bmc.dns.requests.CreateTsigKeyRequest;
import com.oracle.bmc.dns.requests.CreateViewRequest;
import com.oracle.bmc.dns.requests.CreateZoneFromZoneFileRequest;
import com.oracle.bmc.dns.requests.CreateZoneRequest;
import com.oracle.bmc.dns.requests.DeleteResolverEndpointRequest;
import com.oracle.bmc.dns.requests.DeleteSteeringPolicyAttachmentRequest;
import com.oracle.bmc.dns.requests.DeleteSteeringPolicyRequest;
import com.oracle.bmc.dns.requests.DeleteTsigKeyRequest;
import com.oracle.bmc.dns.requests.DeleteViewRequest;
import com.oracle.bmc.dns.requests.DeleteZoneRequest;
import com.oracle.bmc.dns.requests.GetResolverEndpointRequest;
import com.oracle.bmc.dns.requests.GetResolverRequest;
import com.oracle.bmc.dns.requests.GetSteeringPolicyAttachmentRequest;
import com.oracle.bmc.dns.requests.GetSteeringPolicyRequest;
import com.oracle.bmc.dns.requests.GetTsigKeyRequest;
import com.oracle.bmc.dns.requests.GetViewRequest;
import com.oracle.bmc.dns.requests.GetZoneRequest;
import com.oracle.bmc.dns.requests.PromoteZoneDnssecKeyVersionRequest;
import com.oracle.bmc.dns.requests.StageZoneDnssecKeyVersionRequest;
import com.oracle.bmc.dns.requests.UpdateResolverEndpointRequest;
import com.oracle.bmc.dns.requests.UpdateResolverRequest;
import com.oracle.bmc.dns.requests.UpdateSteeringPolicyAttachmentRequest;
import com.oracle.bmc.dns.requests.UpdateSteeringPolicyRequest;
import com.oracle.bmc.dns.requests.UpdateTsigKeyRequest;
import com.oracle.bmc.dns.requests.UpdateViewRequest;
import com.oracle.bmc.dns.requests.UpdateZoneRequest;
import com.oracle.bmc.dns.responses.ChangeResolverCompartmentResponse;
import com.oracle.bmc.dns.responses.ChangeSteeringPolicyCompartmentResponse;
import com.oracle.bmc.dns.responses.ChangeViewCompartmentResponse;
import com.oracle.bmc.dns.responses.ChangeZoneCompartmentResponse;
import com.oracle.bmc.dns.responses.CreateResolverEndpointResponse;
import com.oracle.bmc.dns.responses.CreateSteeringPolicyAttachmentResponse;
import com.oracle.bmc.dns.responses.CreateSteeringPolicyResponse;
import com.oracle.bmc.dns.responses.CreateTsigKeyResponse;
import com.oracle.bmc.dns.responses.CreateViewResponse;
import com.oracle.bmc.dns.responses.CreateZoneFromZoneFileResponse;
import com.oracle.bmc.dns.responses.CreateZoneResponse;
import com.oracle.bmc.dns.responses.DeleteResolverEndpointResponse;
import com.oracle.bmc.dns.responses.DeleteSteeringPolicyAttachmentResponse;
import com.oracle.bmc.dns.responses.DeleteSteeringPolicyResponse;
import com.oracle.bmc.dns.responses.DeleteTsigKeyResponse;
import com.oracle.bmc.dns.responses.DeleteViewResponse;
import com.oracle.bmc.dns.responses.DeleteZoneResponse;
import com.oracle.bmc.dns.responses.GetResolverEndpointResponse;
import com.oracle.bmc.dns.responses.GetResolverResponse;
import com.oracle.bmc.dns.responses.GetSteeringPolicyAttachmentResponse;
import com.oracle.bmc.dns.responses.GetSteeringPolicyResponse;
import com.oracle.bmc.dns.responses.GetTsigKeyResponse;
import com.oracle.bmc.dns.responses.GetViewResponse;
import com.oracle.bmc.dns.responses.GetZoneResponse;
import com.oracle.bmc.dns.responses.PromoteZoneDnssecKeyVersionResponse;
import com.oracle.bmc.dns.responses.StageZoneDnssecKeyVersionResponse;
import com.oracle.bmc.dns.responses.UpdateResolverEndpointResponse;
import com.oracle.bmc.dns.responses.UpdateResolverResponse;
import com.oracle.bmc.dns.responses.UpdateSteeringPolicyAttachmentResponse;
import com.oracle.bmc.dns.responses.UpdateSteeringPolicyResponse;
import com.oracle.bmc.dns.responses.UpdateTsigKeyResponse;
import com.oracle.bmc.dns.responses.UpdateViewResponse;
import com.oracle.bmc.dns.responses.UpdateZoneResponse;
import com.oracle.bmc.util.internal.Validate;
import com.oracle.bmc.waiter.BmcGenericWaiter;
import com.oracle.bmc.waiter.DelayStrategy;
import com.oracle.bmc.waiter.TerminationStrategy;
import com.oracle.bmc.waiter.Waiter;
import com.oracle.bmc.waiter.Waiters;
import com.oracle.bmc.waiter.internal.SimpleWaiterImpl;
import com.oracle.bmc.workrequests.WorkRequest;
import com.oracle.bmc.workrequests.requests.GetWorkRequestRequest;
import jakarta.annotation.Nonnull;
import java.util.Arrays;
import java.util.HashSet;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.function.Function;
import java.util.function.Predicate;

public class DnsWaiters {
    @Nonnull
    private final ExecutorService executorService;
    @Nonnull
    private final Dns client;
    private final WorkRequest workRequestClient;

    @Deprecated
    public DnsWaiters(@Nonnull ExecutorService executorService, @Nonnull Dns client) {
        this(executorService, client, null);
    }

    public DnsWaiters(@Nonnull ExecutorService executorService, @Nonnull Dns client, WorkRequest workRequestClient) {
        if (executorService == null) {
            throw new NullPointerException("executorService is marked non-null but is null");
        }
        if (client == null) {
            throw new NullPointerException("client is marked non-null but is null");
        }
        this.executorService = executorService;
        this.client = client;
        this.workRequestClient = workRequestClient;
    }

    public Waiter<ChangeResolverCompartmentRequest, ChangeResolverCompartmentResponse> forChangeResolverCompartment(ChangeResolverCompartmentRequest request) {
        return this.forChangeResolverCompartment(request, Waiters.DEFAULT_POLLING_TERMINATION_STRATEGY, Waiters.DEFAULT_POLLING_DELAY_STRATEGY);
    }

    public Waiter<ChangeResolverCompartmentRequest, ChangeResolverCompartmentResponse> forChangeResolverCompartment(final ChangeResolverCompartmentRequest request, final TerminationStrategy terminationStrategy, final DelayStrategy delayStrategy) {
        if (this.workRequestClient == null) {
            throw new IllegalStateException("A WorkRequestClient must be supplied to this waiter for this operation");
        }
        return new SimpleWaiterImpl(this.executorService, (Callable)new Callable<ChangeResolverCompartmentResponse>(){

            @Override
            public ChangeResolverCompartmentResponse call() throws Exception {
                ChangeResolverCompartmentResponse response = DnsWaiters.this.client.changeResolverCompartment(request);
                if (response.getOpcWorkRequestId() != null) {
                    GetWorkRequestRequest getWorkRequestRequest = GetWorkRequestRequest.builder().workRequestId(response.getOpcWorkRequestId()).build();
                    DnsWaiters.this.workRequestClient.getWaiters().forWorkRequest(getWorkRequestRequest, terminationStrategy, delayStrategy).execute();
                }
                return response;
            }
        }, (Object)request);
    }

    public Waiter<ChangeSteeringPolicyCompartmentRequest, ChangeSteeringPolicyCompartmentResponse> forChangeSteeringPolicyCompartment(ChangeSteeringPolicyCompartmentRequest request) {
        return this.forChangeSteeringPolicyCompartment(request, Waiters.DEFAULT_POLLING_TERMINATION_STRATEGY, Waiters.DEFAULT_POLLING_DELAY_STRATEGY);
    }

    public Waiter<ChangeSteeringPolicyCompartmentRequest, ChangeSteeringPolicyCompartmentResponse> forChangeSteeringPolicyCompartment(final ChangeSteeringPolicyCompartmentRequest request, final TerminationStrategy terminationStrategy, final DelayStrategy delayStrategy) {
        if (this.workRequestClient == null) {
            throw new IllegalStateException("A WorkRequestClient must be supplied to this waiter for this operation");
        }
        return new SimpleWaiterImpl(this.executorService, (Callable)new Callable<ChangeSteeringPolicyCompartmentResponse>(){

            @Override
            public ChangeSteeringPolicyCompartmentResponse call() throws Exception {
                ChangeSteeringPolicyCompartmentResponse response = DnsWaiters.this.client.changeSteeringPolicyCompartment(request);
                if (response.getOpcWorkRequestId() != null) {
                    GetWorkRequestRequest getWorkRequestRequest = GetWorkRequestRequest.builder().workRequestId(response.getOpcWorkRequestId()).build();
                    DnsWaiters.this.workRequestClient.getWaiters().forWorkRequest(getWorkRequestRequest, terminationStrategy, delayStrategy).execute();
                }
                return response;
            }
        }, (Object)request);
    }

    public Waiter<ChangeViewCompartmentRequest, ChangeViewCompartmentResponse> forChangeViewCompartment(ChangeViewCompartmentRequest request) {
        return this.forChangeViewCompartment(request, Waiters.DEFAULT_POLLING_TERMINATION_STRATEGY, Waiters.DEFAULT_POLLING_DELAY_STRATEGY);
    }

    public Waiter<ChangeViewCompartmentRequest, ChangeViewCompartmentResponse> forChangeViewCompartment(final ChangeViewCompartmentRequest request, final TerminationStrategy terminationStrategy, final DelayStrategy delayStrategy) {
        if (this.workRequestClient == null) {
            throw new IllegalStateException("A WorkRequestClient must be supplied to this waiter for this operation");
        }
        return new SimpleWaiterImpl(this.executorService, (Callable)new Callable<ChangeViewCompartmentResponse>(){

            @Override
            public ChangeViewCompartmentResponse call() throws Exception {
                ChangeViewCompartmentResponse response = DnsWaiters.this.client.changeViewCompartment(request);
                if (response.getOpcWorkRequestId() != null) {
                    GetWorkRequestRequest getWorkRequestRequest = GetWorkRequestRequest.builder().workRequestId(response.getOpcWorkRequestId()).build();
                    DnsWaiters.this.workRequestClient.getWaiters().forWorkRequest(getWorkRequestRequest, terminationStrategy, delayStrategy).execute();
                }
                return response;
            }
        }, (Object)request);
    }

    public Waiter<ChangeZoneCompartmentRequest, ChangeZoneCompartmentResponse> forChangeZoneCompartment(ChangeZoneCompartmentRequest request) {
        return this.forChangeZoneCompartment(request, Waiters.DEFAULT_POLLING_TERMINATION_STRATEGY, Waiters.DEFAULT_POLLING_DELAY_STRATEGY);
    }

    public Waiter<ChangeZoneCompartmentRequest, ChangeZoneCompartmentResponse> forChangeZoneCompartment(final ChangeZoneCompartmentRequest request, final TerminationStrategy terminationStrategy, final DelayStrategy delayStrategy) {
        if (this.workRequestClient == null) {
            throw new IllegalStateException("A WorkRequestClient must be supplied to this waiter for this operation");
        }
        return new SimpleWaiterImpl(this.executorService, (Callable)new Callable<ChangeZoneCompartmentResponse>(){

            @Override
            public ChangeZoneCompartmentResponse call() throws Exception {
                ChangeZoneCompartmentResponse response = DnsWaiters.this.client.changeZoneCompartment(request);
                if (response.getOpcWorkRequestId() != null) {
                    GetWorkRequestRequest getWorkRequestRequest = GetWorkRequestRequest.builder().workRequestId(response.getOpcWorkRequestId()).build();
                    DnsWaiters.this.workRequestClient.getWaiters().forWorkRequest(getWorkRequestRequest, terminationStrategy, delayStrategy).execute();
                }
                return response;
            }
        }, (Object)request);
    }

    public Waiter<CreateResolverEndpointRequest, CreateResolverEndpointResponse> forCreateResolverEndpoint(CreateResolverEndpointRequest request) {
        return this.forCreateResolverEndpoint(request, Waiters.DEFAULT_POLLING_TERMINATION_STRATEGY, Waiters.DEFAULT_POLLING_DELAY_STRATEGY);
    }

    public Waiter<CreateResolverEndpointRequest, CreateResolverEndpointResponse> forCreateResolverEndpoint(final CreateResolverEndpointRequest request, final TerminationStrategy terminationStrategy, final DelayStrategy delayStrategy) {
        if (this.workRequestClient == null) {
            throw new IllegalStateException("A WorkRequestClient must be supplied to this waiter for this operation");
        }
        return new SimpleWaiterImpl(this.executorService, (Callable)new Callable<CreateResolverEndpointResponse>(){

            @Override
            public CreateResolverEndpointResponse call() throws Exception {
                CreateResolverEndpointResponse response = DnsWaiters.this.client.createResolverEndpoint(request);
                if (response.getOpcWorkRequestId() != null) {
                    GetWorkRequestRequest getWorkRequestRequest = GetWorkRequestRequest.builder().workRequestId(response.getOpcWorkRequestId()).build();
                    DnsWaiters.this.workRequestClient.getWaiters().forWorkRequest(getWorkRequestRequest, terminationStrategy, delayStrategy).execute();
                }
                return response;
            }
        }, (Object)request);
    }

    public Waiter<CreateSteeringPolicyRequest, CreateSteeringPolicyResponse> forCreateSteeringPolicy(CreateSteeringPolicyRequest request) {
        return this.forCreateSteeringPolicy(request, Waiters.DEFAULT_POLLING_TERMINATION_STRATEGY, Waiters.DEFAULT_POLLING_DELAY_STRATEGY);
    }

    public Waiter<CreateSteeringPolicyRequest, CreateSteeringPolicyResponse> forCreateSteeringPolicy(final CreateSteeringPolicyRequest request, final TerminationStrategy terminationStrategy, final DelayStrategy delayStrategy) {
        if (this.workRequestClient == null) {
            throw new IllegalStateException("A WorkRequestClient must be supplied to this waiter for this operation");
        }
        return new SimpleWaiterImpl(this.executorService, (Callable)new Callable<CreateSteeringPolicyResponse>(){

            @Override
            public CreateSteeringPolicyResponse call() throws Exception {
                CreateSteeringPolicyResponse response = DnsWaiters.this.client.createSteeringPolicy(request);
                if (response.getOpcWorkRequestId() != null) {
                    GetWorkRequestRequest getWorkRequestRequest = GetWorkRequestRequest.builder().workRequestId(response.getOpcWorkRequestId()).build();
                    DnsWaiters.this.workRequestClient.getWaiters().forWorkRequest(getWorkRequestRequest, terminationStrategy, delayStrategy).execute();
                }
                return response;
            }
        }, (Object)request);
    }

    public Waiter<CreateSteeringPolicyAttachmentRequest, CreateSteeringPolicyAttachmentResponse> forCreateSteeringPolicyAttachment(CreateSteeringPolicyAttachmentRequest request) {
        return this.forCreateSteeringPolicyAttachment(request, Waiters.DEFAULT_POLLING_TERMINATION_STRATEGY, Waiters.DEFAULT_POLLING_DELAY_STRATEGY);
    }

    public Waiter<CreateSteeringPolicyAttachmentRequest, CreateSteeringPolicyAttachmentResponse> forCreateSteeringPolicyAttachment(final CreateSteeringPolicyAttachmentRequest request, final TerminationStrategy terminationStrategy, final DelayStrategy delayStrategy) {
        if (this.workRequestClient == null) {
            throw new IllegalStateException("A WorkRequestClient must be supplied to this waiter for this operation");
        }
        return new SimpleWaiterImpl(this.executorService, (Callable)new Callable<CreateSteeringPolicyAttachmentResponse>(){

            @Override
            public CreateSteeringPolicyAttachmentResponse call() throws Exception {
                CreateSteeringPolicyAttachmentResponse response = DnsWaiters.this.client.createSteeringPolicyAttachment(request);
                if (response.getOpcWorkRequestId() != null) {
                    GetWorkRequestRequest getWorkRequestRequest = GetWorkRequestRequest.builder().workRequestId(response.getOpcWorkRequestId()).build();
                    DnsWaiters.this.workRequestClient.getWaiters().forWorkRequest(getWorkRequestRequest, terminationStrategy, delayStrategy).execute();
                }
                return response;
            }
        }, (Object)request);
    }

    public Waiter<CreateTsigKeyRequest, CreateTsigKeyResponse> forCreateTsigKey(CreateTsigKeyRequest request) {
        return this.forCreateTsigKey(request, Waiters.DEFAULT_POLLING_TERMINATION_STRATEGY, Waiters.DEFAULT_POLLING_DELAY_STRATEGY);
    }

    public Waiter<CreateTsigKeyRequest, CreateTsigKeyResponse> forCreateTsigKey(final CreateTsigKeyRequest request, final TerminationStrategy terminationStrategy, final DelayStrategy delayStrategy) {
        if (this.workRequestClient == null) {
            throw new IllegalStateException("A WorkRequestClient must be supplied to this waiter for this operation");
        }
        return new SimpleWaiterImpl(this.executorService, (Callable)new Callable<CreateTsigKeyResponse>(){

            @Override
            public CreateTsigKeyResponse call() throws Exception {
                CreateTsigKeyResponse response = DnsWaiters.this.client.createTsigKey(request);
                if (response.getOpcWorkRequestId() != null) {
                    GetWorkRequestRequest getWorkRequestRequest = GetWorkRequestRequest.builder().workRequestId(response.getOpcWorkRequestId()).build();
                    DnsWaiters.this.workRequestClient.getWaiters().forWorkRequest(getWorkRequestRequest, terminationStrategy, delayStrategy).execute();
                }
                return response;
            }
        }, (Object)request);
    }

    public Waiter<CreateViewRequest, CreateViewResponse> forCreateView(CreateViewRequest request) {
        return this.forCreateView(request, Waiters.DEFAULT_POLLING_TERMINATION_STRATEGY, Waiters.DEFAULT_POLLING_DELAY_STRATEGY);
    }

    public Waiter<CreateViewRequest, CreateViewResponse> forCreateView(final CreateViewRequest request, final TerminationStrategy terminationStrategy, final DelayStrategy delayStrategy) {
        if (this.workRequestClient == null) {
            throw new IllegalStateException("A WorkRequestClient must be supplied to this waiter for this operation");
        }
        return new SimpleWaiterImpl(this.executorService, (Callable)new Callable<CreateViewResponse>(){

            @Override
            public CreateViewResponse call() throws Exception {
                CreateViewResponse response = DnsWaiters.this.client.createView(request);
                if (response.getOpcWorkRequestId() != null) {
                    GetWorkRequestRequest getWorkRequestRequest = GetWorkRequestRequest.builder().workRequestId(response.getOpcWorkRequestId()).build();
                    DnsWaiters.this.workRequestClient.getWaiters().forWorkRequest(getWorkRequestRequest, terminationStrategy, delayStrategy).execute();
                }
                return response;
            }
        }, (Object)request);
    }

    public Waiter<CreateZoneRequest, CreateZoneResponse> forCreateZone(CreateZoneRequest request) {
        return this.forCreateZone(request, Waiters.DEFAULT_POLLING_TERMINATION_STRATEGY, Waiters.DEFAULT_POLLING_DELAY_STRATEGY);
    }

    public Waiter<CreateZoneRequest, CreateZoneResponse> forCreateZone(final CreateZoneRequest request, final TerminationStrategy terminationStrategy, final DelayStrategy delayStrategy) {
        if (this.workRequestClient == null) {
            throw new IllegalStateException("A WorkRequestClient must be supplied to this waiter for this operation");
        }
        return new SimpleWaiterImpl(this.executorService, (Callable)new Callable<CreateZoneResponse>(){

            @Override
            public CreateZoneResponse call() throws Exception {
                CreateZoneResponse response = DnsWaiters.this.client.createZone(request);
                if (response.getOpcWorkRequestId() != null) {
                    GetWorkRequestRequest getWorkRequestRequest = GetWorkRequestRequest.builder().workRequestId(response.getOpcWorkRequestId()).build();
                    DnsWaiters.this.workRequestClient.getWaiters().forWorkRequest(getWorkRequestRequest, terminationStrategy, delayStrategy).execute();
                }
                return response;
            }
        }, (Object)request);
    }

    public Waiter<CreateZoneFromZoneFileRequest, CreateZoneFromZoneFileResponse> forCreateZoneFromZoneFile(CreateZoneFromZoneFileRequest request) {
        return this.forCreateZoneFromZoneFile(request, Waiters.DEFAULT_POLLING_TERMINATION_STRATEGY, Waiters.DEFAULT_POLLING_DELAY_STRATEGY);
    }

    public Waiter<CreateZoneFromZoneFileRequest, CreateZoneFromZoneFileResponse> forCreateZoneFromZoneFile(final CreateZoneFromZoneFileRequest request, final TerminationStrategy terminationStrategy, final DelayStrategy delayStrategy) {
        if (this.workRequestClient == null) {
            throw new IllegalStateException("A WorkRequestClient must be supplied to this waiter for this operation");
        }
        return new SimpleWaiterImpl(this.executorService, (Callable)new Callable<CreateZoneFromZoneFileResponse>(){

            @Override
            public CreateZoneFromZoneFileResponse call() throws Exception {
                CreateZoneFromZoneFileResponse response = DnsWaiters.this.client.createZoneFromZoneFile(request);
                if (response.getOpcWorkRequestId() != null) {
                    GetWorkRequestRequest getWorkRequestRequest = GetWorkRequestRequest.builder().workRequestId(response.getOpcWorkRequestId()).build();
                    DnsWaiters.this.workRequestClient.getWaiters().forWorkRequest(getWorkRequestRequest, terminationStrategy, delayStrategy).execute();
                }
                return response;
            }
        }, (Object)request);
    }

    public Waiter<DeleteResolverEndpointRequest, DeleteResolverEndpointResponse> forDeleteResolverEndpoint(DeleteResolverEndpointRequest request) {
        return this.forDeleteResolverEndpoint(request, Waiters.DEFAULT_POLLING_TERMINATION_STRATEGY, Waiters.DEFAULT_POLLING_DELAY_STRATEGY);
    }

    public Waiter<DeleteResolverEndpointRequest, DeleteResolverEndpointResponse> forDeleteResolverEndpoint(final DeleteResolverEndpointRequest request, final TerminationStrategy terminationStrategy, final DelayStrategy delayStrategy) {
        if (this.workRequestClient == null) {
            throw new IllegalStateException("A WorkRequestClient must be supplied to this waiter for this operation");
        }
        return new SimpleWaiterImpl(this.executorService, (Callable)new Callable<DeleteResolverEndpointResponse>(){

            @Override
            public DeleteResolverEndpointResponse call() throws Exception {
                DeleteResolverEndpointResponse response = DnsWaiters.this.client.deleteResolverEndpoint(request);
                if (response.getOpcWorkRequestId() != null) {
                    GetWorkRequestRequest getWorkRequestRequest = GetWorkRequestRequest.builder().workRequestId(response.getOpcWorkRequestId()).build();
                    DnsWaiters.this.workRequestClient.getWaiters().forWorkRequest(getWorkRequestRequest, terminationStrategy, delayStrategy).execute();
                }
                return response;
            }
        }, (Object)request);
    }

    public Waiter<DeleteSteeringPolicyRequest, DeleteSteeringPolicyResponse> forDeleteSteeringPolicy(DeleteSteeringPolicyRequest request) {
        return this.forDeleteSteeringPolicy(request, Waiters.DEFAULT_POLLING_TERMINATION_STRATEGY, Waiters.DEFAULT_POLLING_DELAY_STRATEGY);
    }

    public Waiter<DeleteSteeringPolicyRequest, DeleteSteeringPolicyResponse> forDeleteSteeringPolicy(final DeleteSteeringPolicyRequest request, final TerminationStrategy terminationStrategy, final DelayStrategy delayStrategy) {
        if (this.workRequestClient == null) {
            throw new IllegalStateException("A WorkRequestClient must be supplied to this waiter for this operation");
        }
        return new SimpleWaiterImpl(this.executorService, (Callable)new Callable<DeleteSteeringPolicyResponse>(){

            @Override
            public DeleteSteeringPolicyResponse call() throws Exception {
                DeleteSteeringPolicyResponse response = DnsWaiters.this.client.deleteSteeringPolicy(request);
                if (response.getOpcWorkRequestId() != null) {
                    GetWorkRequestRequest getWorkRequestRequest = GetWorkRequestRequest.builder().workRequestId(response.getOpcWorkRequestId()).build();
                    DnsWaiters.this.workRequestClient.getWaiters().forWorkRequest(getWorkRequestRequest, terminationStrategy, delayStrategy).execute();
                }
                return response;
            }
        }, (Object)request);
    }

    public Waiter<DeleteSteeringPolicyAttachmentRequest, DeleteSteeringPolicyAttachmentResponse> forDeleteSteeringPolicyAttachment(DeleteSteeringPolicyAttachmentRequest request) {
        return this.forDeleteSteeringPolicyAttachment(request, Waiters.DEFAULT_POLLING_TERMINATION_STRATEGY, Waiters.DEFAULT_POLLING_DELAY_STRATEGY);
    }

    public Waiter<DeleteSteeringPolicyAttachmentRequest, DeleteSteeringPolicyAttachmentResponse> forDeleteSteeringPolicyAttachment(final DeleteSteeringPolicyAttachmentRequest request, final TerminationStrategy terminationStrategy, final DelayStrategy delayStrategy) {
        if (this.workRequestClient == null) {
            throw new IllegalStateException("A WorkRequestClient must be supplied to this waiter for this operation");
        }
        return new SimpleWaiterImpl(this.executorService, (Callable)new Callable<DeleteSteeringPolicyAttachmentResponse>(){

            @Override
            public DeleteSteeringPolicyAttachmentResponse call() throws Exception {
                DeleteSteeringPolicyAttachmentResponse response = DnsWaiters.this.client.deleteSteeringPolicyAttachment(request);
                if (response.getOpcWorkRequestId() != null) {
                    GetWorkRequestRequest getWorkRequestRequest = GetWorkRequestRequest.builder().workRequestId(response.getOpcWorkRequestId()).build();
                    DnsWaiters.this.workRequestClient.getWaiters().forWorkRequest(getWorkRequestRequest, terminationStrategy, delayStrategy).execute();
                }
                return response;
            }
        }, (Object)request);
    }

    public Waiter<DeleteTsigKeyRequest, DeleteTsigKeyResponse> forDeleteTsigKey(DeleteTsigKeyRequest request) {
        return this.forDeleteTsigKey(request, Waiters.DEFAULT_POLLING_TERMINATION_STRATEGY, Waiters.DEFAULT_POLLING_DELAY_STRATEGY);
    }

    public Waiter<DeleteTsigKeyRequest, DeleteTsigKeyResponse> forDeleteTsigKey(final DeleteTsigKeyRequest request, final TerminationStrategy terminationStrategy, final DelayStrategy delayStrategy) {
        if (this.workRequestClient == null) {
            throw new IllegalStateException("A WorkRequestClient must be supplied to this waiter for this operation");
        }
        return new SimpleWaiterImpl(this.executorService, (Callable)new Callable<DeleteTsigKeyResponse>(){

            @Override
            public DeleteTsigKeyResponse call() throws Exception {
                DeleteTsigKeyResponse response = DnsWaiters.this.client.deleteTsigKey(request);
                if (response.getOpcWorkRequestId() != null) {
                    GetWorkRequestRequest getWorkRequestRequest = GetWorkRequestRequest.builder().workRequestId(response.getOpcWorkRequestId()).build();
                    DnsWaiters.this.workRequestClient.getWaiters().forWorkRequest(getWorkRequestRequest, terminationStrategy, delayStrategy).execute();
                }
                return response;
            }
        }, (Object)request);
    }

    public Waiter<DeleteViewRequest, DeleteViewResponse> forDeleteView(DeleteViewRequest request) {
        return this.forDeleteView(request, Waiters.DEFAULT_POLLING_TERMINATION_STRATEGY, Waiters.DEFAULT_POLLING_DELAY_STRATEGY);
    }

    public Waiter<DeleteViewRequest, DeleteViewResponse> forDeleteView(final DeleteViewRequest request, final TerminationStrategy terminationStrategy, final DelayStrategy delayStrategy) {
        if (this.workRequestClient == null) {
            throw new IllegalStateException("A WorkRequestClient must be supplied to this waiter for this operation");
        }
        return new SimpleWaiterImpl(this.executorService, (Callable)new Callable<DeleteViewResponse>(){

            @Override
            public DeleteViewResponse call() throws Exception {
                DeleteViewResponse response = DnsWaiters.this.client.deleteView(request);
                if (response.getOpcWorkRequestId() != null) {
                    GetWorkRequestRequest getWorkRequestRequest = GetWorkRequestRequest.builder().workRequestId(response.getOpcWorkRequestId()).build();
                    DnsWaiters.this.workRequestClient.getWaiters().forWorkRequest(getWorkRequestRequest, terminationStrategy, delayStrategy).execute();
                }
                return response;
            }
        }, (Object)request);
    }

    public Waiter<DeleteZoneRequest, DeleteZoneResponse> forDeleteZone(DeleteZoneRequest request) {
        return this.forDeleteZone(request, Waiters.DEFAULT_POLLING_TERMINATION_STRATEGY, Waiters.DEFAULT_POLLING_DELAY_STRATEGY);
    }

    public Waiter<DeleteZoneRequest, DeleteZoneResponse> forDeleteZone(final DeleteZoneRequest request, final TerminationStrategy terminationStrategy, final DelayStrategy delayStrategy) {
        if (this.workRequestClient == null) {
            throw new IllegalStateException("A WorkRequestClient must be supplied to this waiter for this operation");
        }
        return new SimpleWaiterImpl(this.executorService, (Callable)new Callable<DeleteZoneResponse>(){

            @Override
            public DeleteZoneResponse call() throws Exception {
                DeleteZoneResponse response = DnsWaiters.this.client.deleteZone(request);
                if (response.getOpcWorkRequestId() != null) {
                    GetWorkRequestRequest getWorkRequestRequest = GetWorkRequestRequest.builder().workRequestId(response.getOpcWorkRequestId()).build();
                    DnsWaiters.this.workRequestClient.getWaiters().forWorkRequest(getWorkRequestRequest, terminationStrategy, delayStrategy).execute();
                }
                return response;
            }
        }, (Object)request);
    }

    public Waiter<GetResolverRequest, GetResolverResponse> forResolver(GetResolverRequest request, Resolver.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forResolver(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetResolverRequest, GetResolverResponse> forResolver(GetResolverRequest request, Resolver.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forResolver(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetResolverRequest, GetResolverResponse> forResolver(GetResolverRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, Resolver.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forResolver(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetResolverRequest, GetResolverResponse> forResolver(BmcGenericWaiter waiter, GetResolverRequest request, Resolver.LifecycleState ... targetStates) {
        final HashSet<Resolver.LifecycleState> targetStatesSet = new HashSet<Resolver.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetResolverRequest, GetResolverResponse>(){

            @Override
            public GetResolverResponse apply(GetResolverRequest request) {
                return DnsWaiters.this.client.getResolver(request);
            }
        }, (Predicate)new Predicate<GetResolverResponse>(){

            @Override
            public boolean test(GetResolverResponse response) {
                return targetStatesSet.contains((Object)response.getResolver().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)Resolver.LifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetResolverEndpointRequest, GetResolverEndpointResponse> forResolverEndpoint(GetResolverEndpointRequest request, ResolverEndpoint.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forResolverEndpoint(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetResolverEndpointRequest, GetResolverEndpointResponse> forResolverEndpoint(GetResolverEndpointRequest request, ResolverEndpoint.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forResolverEndpoint(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetResolverEndpointRequest, GetResolverEndpointResponse> forResolverEndpoint(GetResolverEndpointRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, ResolverEndpoint.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forResolverEndpoint(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetResolverEndpointRequest, GetResolverEndpointResponse> forResolverEndpoint(BmcGenericWaiter waiter, GetResolverEndpointRequest request, ResolverEndpoint.LifecycleState ... targetStates) {
        final HashSet<ResolverEndpoint.LifecycleState> targetStatesSet = new HashSet<ResolverEndpoint.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetResolverEndpointRequest, GetResolverEndpointResponse>(){

            @Override
            public GetResolverEndpointResponse apply(GetResolverEndpointRequest request) {
                return DnsWaiters.this.client.getResolverEndpoint(request);
            }
        }, (Predicate)new Predicate<GetResolverEndpointResponse>(){

            @Override
            public boolean test(GetResolverEndpointResponse response) {
                return targetStatesSet.contains((Object)response.getResolverEndpoint().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)ResolverEndpoint.LifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetSteeringPolicyRequest, GetSteeringPolicyResponse> forSteeringPolicy(GetSteeringPolicyRequest request, SteeringPolicy.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forSteeringPolicy(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetSteeringPolicyRequest, GetSteeringPolicyResponse> forSteeringPolicy(GetSteeringPolicyRequest request, SteeringPolicy.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forSteeringPolicy(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetSteeringPolicyRequest, GetSteeringPolicyResponse> forSteeringPolicy(GetSteeringPolicyRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, SteeringPolicy.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forSteeringPolicy(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetSteeringPolicyRequest, GetSteeringPolicyResponse> forSteeringPolicy(BmcGenericWaiter waiter, GetSteeringPolicyRequest request, SteeringPolicy.LifecycleState ... targetStates) {
        final HashSet<SteeringPolicy.LifecycleState> targetStatesSet = new HashSet<SteeringPolicy.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetSteeringPolicyRequest, GetSteeringPolicyResponse>(){

            @Override
            public GetSteeringPolicyResponse apply(GetSteeringPolicyRequest request) {
                return DnsWaiters.this.client.getSteeringPolicy(request);
            }
        }, (Predicate)new Predicate<GetSteeringPolicyResponse>(){

            @Override
            public boolean test(GetSteeringPolicyResponse response) {
                return targetStatesSet.contains((Object)response.getSteeringPolicy().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)SteeringPolicy.LifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetSteeringPolicyAttachmentRequest, GetSteeringPolicyAttachmentResponse> forSteeringPolicyAttachment(GetSteeringPolicyAttachmentRequest request, SteeringPolicyAttachment.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forSteeringPolicyAttachment(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetSteeringPolicyAttachmentRequest, GetSteeringPolicyAttachmentResponse> forSteeringPolicyAttachment(GetSteeringPolicyAttachmentRequest request, SteeringPolicyAttachment.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forSteeringPolicyAttachment(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetSteeringPolicyAttachmentRequest, GetSteeringPolicyAttachmentResponse> forSteeringPolicyAttachment(GetSteeringPolicyAttachmentRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, SteeringPolicyAttachment.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forSteeringPolicyAttachment(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetSteeringPolicyAttachmentRequest, GetSteeringPolicyAttachmentResponse> forSteeringPolicyAttachment(BmcGenericWaiter waiter, GetSteeringPolicyAttachmentRequest request, SteeringPolicyAttachment.LifecycleState ... targetStates) {
        final HashSet<SteeringPolicyAttachment.LifecycleState> targetStatesSet = new HashSet<SteeringPolicyAttachment.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetSteeringPolicyAttachmentRequest, GetSteeringPolicyAttachmentResponse>(){

            @Override
            public GetSteeringPolicyAttachmentResponse apply(GetSteeringPolicyAttachmentRequest request) {
                return DnsWaiters.this.client.getSteeringPolicyAttachment(request);
            }
        }, (Predicate)new Predicate<GetSteeringPolicyAttachmentResponse>(){

            @Override
            public boolean test(GetSteeringPolicyAttachmentResponse response) {
                return targetStatesSet.contains((Object)response.getSteeringPolicyAttachment().getLifecycleState());
            }
        }, false), (Object)request);
    }

    public Waiter<GetTsigKeyRequest, GetTsigKeyResponse> forTsigKey(GetTsigKeyRequest request, TsigKey.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forTsigKey(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetTsigKeyRequest, GetTsigKeyResponse> forTsigKey(GetTsigKeyRequest request, TsigKey.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forTsigKey(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetTsigKeyRequest, GetTsigKeyResponse> forTsigKey(GetTsigKeyRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, TsigKey.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forTsigKey(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetTsigKeyRequest, GetTsigKeyResponse> forTsigKey(BmcGenericWaiter waiter, GetTsigKeyRequest request, TsigKey.LifecycleState ... targetStates) {
        final HashSet<TsigKey.LifecycleState> targetStatesSet = new HashSet<TsigKey.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetTsigKeyRequest, GetTsigKeyResponse>(){

            @Override
            public GetTsigKeyResponse apply(GetTsigKeyRequest request) {
                return DnsWaiters.this.client.getTsigKey(request);
            }
        }, (Predicate)new Predicate<GetTsigKeyResponse>(){

            @Override
            public boolean test(GetTsigKeyResponse response) {
                return targetStatesSet.contains((Object)response.getTsigKey().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)TsigKey.LifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetViewRequest, GetViewResponse> forView(GetViewRequest request, View.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forView(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetViewRequest, GetViewResponse> forView(GetViewRequest request, View.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forView(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetViewRequest, GetViewResponse> forView(GetViewRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, View.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forView(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetViewRequest, GetViewResponse> forView(BmcGenericWaiter waiter, GetViewRequest request, View.LifecycleState ... targetStates) {
        final HashSet<View.LifecycleState> targetStatesSet = new HashSet<View.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetViewRequest, GetViewResponse>(){

            @Override
            public GetViewResponse apply(GetViewRequest request) {
                return DnsWaiters.this.client.getView(request);
            }
        }, (Predicate)new Predicate<GetViewResponse>(){

            @Override
            public boolean test(GetViewResponse response) {
                return targetStatesSet.contains((Object)response.getView().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)View.LifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetZoneRequest, GetZoneResponse> forZone(GetZoneRequest request, Zone.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forZone(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetZoneRequest, GetZoneResponse> forZone(GetZoneRequest request, Zone.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forZone(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetZoneRequest, GetZoneResponse> forZone(GetZoneRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, Zone.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forZone(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetZoneRequest, GetZoneResponse> forZone(BmcGenericWaiter waiter, GetZoneRequest request, Zone.LifecycleState ... targetStates) {
        final HashSet<Zone.LifecycleState> targetStatesSet = new HashSet<Zone.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetZoneRequest, GetZoneResponse>(){

            @Override
            public GetZoneResponse apply(GetZoneRequest request) {
                return DnsWaiters.this.client.getZone(request);
            }
        }, (Predicate)new Predicate<GetZoneResponse>(){

            @Override
            public boolean test(GetZoneResponse response) {
                return targetStatesSet.contains((Object)response.getZone().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)Zone.LifecycleState.Deleted)), (Object)request);
    }

    public Waiter<PromoteZoneDnssecKeyVersionRequest, PromoteZoneDnssecKeyVersionResponse> forPromoteZoneDnssecKeyVersion(PromoteZoneDnssecKeyVersionRequest request) {
        return this.forPromoteZoneDnssecKeyVersion(request, Waiters.DEFAULT_POLLING_TERMINATION_STRATEGY, Waiters.DEFAULT_POLLING_DELAY_STRATEGY);
    }

    public Waiter<PromoteZoneDnssecKeyVersionRequest, PromoteZoneDnssecKeyVersionResponse> forPromoteZoneDnssecKeyVersion(final PromoteZoneDnssecKeyVersionRequest request, final TerminationStrategy terminationStrategy, final DelayStrategy delayStrategy) {
        if (this.workRequestClient == null) {
            throw new IllegalStateException("A WorkRequestClient must be supplied to this waiter for this operation");
        }
        return new SimpleWaiterImpl(this.executorService, (Callable)new Callable<PromoteZoneDnssecKeyVersionResponse>(){

            @Override
            public PromoteZoneDnssecKeyVersionResponse call() throws Exception {
                PromoteZoneDnssecKeyVersionResponse response = DnsWaiters.this.client.promoteZoneDnssecKeyVersion(request);
                if (response.getOpcWorkRequestId() != null) {
                    GetWorkRequestRequest getWorkRequestRequest = GetWorkRequestRequest.builder().workRequestId(response.getOpcWorkRequestId()).build();
                    DnsWaiters.this.workRequestClient.getWaiters().forWorkRequest(getWorkRequestRequest, terminationStrategy, delayStrategy).execute();
                }
                return response;
            }
        }, (Object)request);
    }

    public Waiter<StageZoneDnssecKeyVersionRequest, StageZoneDnssecKeyVersionResponse> forStageZoneDnssecKeyVersion(StageZoneDnssecKeyVersionRequest request) {
        return this.forStageZoneDnssecKeyVersion(request, Waiters.DEFAULT_POLLING_TERMINATION_STRATEGY, Waiters.DEFAULT_POLLING_DELAY_STRATEGY);
    }

    public Waiter<StageZoneDnssecKeyVersionRequest, StageZoneDnssecKeyVersionResponse> forStageZoneDnssecKeyVersion(final StageZoneDnssecKeyVersionRequest request, final TerminationStrategy terminationStrategy, final DelayStrategy delayStrategy) {
        if (this.workRequestClient == null) {
            throw new IllegalStateException("A WorkRequestClient must be supplied to this waiter for this operation");
        }
        return new SimpleWaiterImpl(this.executorService, (Callable)new Callable<StageZoneDnssecKeyVersionResponse>(){

            @Override
            public StageZoneDnssecKeyVersionResponse call() throws Exception {
                StageZoneDnssecKeyVersionResponse response = DnsWaiters.this.client.stageZoneDnssecKeyVersion(request);
                if (response.getOpcWorkRequestId() != null) {
                    GetWorkRequestRequest getWorkRequestRequest = GetWorkRequestRequest.builder().workRequestId(response.getOpcWorkRequestId()).build();
                    DnsWaiters.this.workRequestClient.getWaiters().forWorkRequest(getWorkRequestRequest, terminationStrategy, delayStrategy).execute();
                }
                return response;
            }
        }, (Object)request);
    }

    public Waiter<UpdateResolverRequest, UpdateResolverResponse> forUpdateResolver(UpdateResolverRequest request) {
        return this.forUpdateResolver(request, Waiters.DEFAULT_POLLING_TERMINATION_STRATEGY, Waiters.DEFAULT_POLLING_DELAY_STRATEGY);
    }

    public Waiter<UpdateResolverRequest, UpdateResolverResponse> forUpdateResolver(final UpdateResolverRequest request, final TerminationStrategy terminationStrategy, final DelayStrategy delayStrategy) {
        if (this.workRequestClient == null) {
            throw new IllegalStateException("A WorkRequestClient must be supplied to this waiter for this operation");
        }
        return new SimpleWaiterImpl(this.executorService, (Callable)new Callable<UpdateResolverResponse>(){

            @Override
            public UpdateResolverResponse call() throws Exception {
                UpdateResolverResponse response = DnsWaiters.this.client.updateResolver(request);
                if (response.getOpcWorkRequestId() != null) {
                    GetWorkRequestRequest getWorkRequestRequest = GetWorkRequestRequest.builder().workRequestId(response.getOpcWorkRequestId()).build();
                    DnsWaiters.this.workRequestClient.getWaiters().forWorkRequest(getWorkRequestRequest, terminationStrategy, delayStrategy).execute();
                }
                return response;
            }
        }, (Object)request);
    }

    public Waiter<UpdateResolverEndpointRequest, UpdateResolverEndpointResponse> forUpdateResolverEndpoint(UpdateResolverEndpointRequest request) {
        return this.forUpdateResolverEndpoint(request, Waiters.DEFAULT_POLLING_TERMINATION_STRATEGY, Waiters.DEFAULT_POLLING_DELAY_STRATEGY);
    }

    public Waiter<UpdateResolverEndpointRequest, UpdateResolverEndpointResponse> forUpdateResolverEndpoint(final UpdateResolverEndpointRequest request, final TerminationStrategy terminationStrategy, final DelayStrategy delayStrategy) {
        if (this.workRequestClient == null) {
            throw new IllegalStateException("A WorkRequestClient must be supplied to this waiter for this operation");
        }
        return new SimpleWaiterImpl(this.executorService, (Callable)new Callable<UpdateResolverEndpointResponse>(){

            @Override
            public UpdateResolverEndpointResponse call() throws Exception {
                UpdateResolverEndpointResponse response = DnsWaiters.this.client.updateResolverEndpoint(request);
                if (response.getOpcWorkRequestId() != null) {
                    GetWorkRequestRequest getWorkRequestRequest = GetWorkRequestRequest.builder().workRequestId(response.getOpcWorkRequestId()).build();
                    DnsWaiters.this.workRequestClient.getWaiters().forWorkRequest(getWorkRequestRequest, terminationStrategy, delayStrategy).execute();
                }
                return response;
            }
        }, (Object)request);
    }

    public Waiter<UpdateSteeringPolicyRequest, UpdateSteeringPolicyResponse> forUpdateSteeringPolicy(UpdateSteeringPolicyRequest request) {
        return this.forUpdateSteeringPolicy(request, Waiters.DEFAULT_POLLING_TERMINATION_STRATEGY, Waiters.DEFAULT_POLLING_DELAY_STRATEGY);
    }

    public Waiter<UpdateSteeringPolicyRequest, UpdateSteeringPolicyResponse> forUpdateSteeringPolicy(final UpdateSteeringPolicyRequest request, final TerminationStrategy terminationStrategy, final DelayStrategy delayStrategy) {
        if (this.workRequestClient == null) {
            throw new IllegalStateException("A WorkRequestClient must be supplied to this waiter for this operation");
        }
        return new SimpleWaiterImpl(this.executorService, (Callable)new Callable<UpdateSteeringPolicyResponse>(){

            @Override
            public UpdateSteeringPolicyResponse call() throws Exception {
                UpdateSteeringPolicyResponse response = DnsWaiters.this.client.updateSteeringPolicy(request);
                if (response.getOpcWorkRequestId() != null) {
                    GetWorkRequestRequest getWorkRequestRequest = GetWorkRequestRequest.builder().workRequestId(response.getOpcWorkRequestId()).build();
                    DnsWaiters.this.workRequestClient.getWaiters().forWorkRequest(getWorkRequestRequest, terminationStrategy, delayStrategy).execute();
                }
                return response;
            }
        }, (Object)request);
    }

    public Waiter<UpdateSteeringPolicyAttachmentRequest, UpdateSteeringPolicyAttachmentResponse> forUpdateSteeringPolicyAttachment(UpdateSteeringPolicyAttachmentRequest request) {
        return this.forUpdateSteeringPolicyAttachment(request, Waiters.DEFAULT_POLLING_TERMINATION_STRATEGY, Waiters.DEFAULT_POLLING_DELAY_STRATEGY);
    }

    public Waiter<UpdateSteeringPolicyAttachmentRequest, UpdateSteeringPolicyAttachmentResponse> forUpdateSteeringPolicyAttachment(final UpdateSteeringPolicyAttachmentRequest request, final TerminationStrategy terminationStrategy, final DelayStrategy delayStrategy) {
        if (this.workRequestClient == null) {
            throw new IllegalStateException("A WorkRequestClient must be supplied to this waiter for this operation");
        }
        return new SimpleWaiterImpl(this.executorService, (Callable)new Callable<UpdateSteeringPolicyAttachmentResponse>(){

            @Override
            public UpdateSteeringPolicyAttachmentResponse call() throws Exception {
                UpdateSteeringPolicyAttachmentResponse response = DnsWaiters.this.client.updateSteeringPolicyAttachment(request);
                if (response.getOpcWorkRequestId() != null) {
                    GetWorkRequestRequest getWorkRequestRequest = GetWorkRequestRequest.builder().workRequestId(response.getOpcWorkRequestId()).build();
                    DnsWaiters.this.workRequestClient.getWaiters().forWorkRequest(getWorkRequestRequest, terminationStrategy, delayStrategy).execute();
                }
                return response;
            }
        }, (Object)request);
    }

    public Waiter<UpdateTsigKeyRequest, UpdateTsigKeyResponse> forUpdateTsigKey(UpdateTsigKeyRequest request) {
        return this.forUpdateTsigKey(request, Waiters.DEFAULT_POLLING_TERMINATION_STRATEGY, Waiters.DEFAULT_POLLING_DELAY_STRATEGY);
    }

    public Waiter<UpdateTsigKeyRequest, UpdateTsigKeyResponse> forUpdateTsigKey(final UpdateTsigKeyRequest request, final TerminationStrategy terminationStrategy, final DelayStrategy delayStrategy) {
        if (this.workRequestClient == null) {
            throw new IllegalStateException("A WorkRequestClient must be supplied to this waiter for this operation");
        }
        return new SimpleWaiterImpl(this.executorService, (Callable)new Callable<UpdateTsigKeyResponse>(){

            @Override
            public UpdateTsigKeyResponse call() throws Exception {
                UpdateTsigKeyResponse response = DnsWaiters.this.client.updateTsigKey(request);
                if (response.getOpcWorkRequestId() != null) {
                    GetWorkRequestRequest getWorkRequestRequest = GetWorkRequestRequest.builder().workRequestId(response.getOpcWorkRequestId()).build();
                    DnsWaiters.this.workRequestClient.getWaiters().forWorkRequest(getWorkRequestRequest, terminationStrategy, delayStrategy).execute();
                }
                return response;
            }
        }, (Object)request);
    }

    public Waiter<UpdateViewRequest, UpdateViewResponse> forUpdateView(UpdateViewRequest request) {
        return this.forUpdateView(request, Waiters.DEFAULT_POLLING_TERMINATION_STRATEGY, Waiters.DEFAULT_POLLING_DELAY_STRATEGY);
    }

    public Waiter<UpdateViewRequest, UpdateViewResponse> forUpdateView(final UpdateViewRequest request, final TerminationStrategy terminationStrategy, final DelayStrategy delayStrategy) {
        if (this.workRequestClient == null) {
            throw new IllegalStateException("A WorkRequestClient must be supplied to this waiter for this operation");
        }
        return new SimpleWaiterImpl(this.executorService, (Callable)new Callable<UpdateViewResponse>(){

            @Override
            public UpdateViewResponse call() throws Exception {
                UpdateViewResponse response = DnsWaiters.this.client.updateView(request);
                if (response.getOpcWorkRequestId() != null) {
                    GetWorkRequestRequest getWorkRequestRequest = GetWorkRequestRequest.builder().workRequestId(response.getOpcWorkRequestId()).build();
                    DnsWaiters.this.workRequestClient.getWaiters().forWorkRequest(getWorkRequestRequest, terminationStrategy, delayStrategy).execute();
                }
                return response;
            }
        }, (Object)request);
    }

    public Waiter<UpdateZoneRequest, UpdateZoneResponse> forUpdateZone(UpdateZoneRequest request) {
        return this.forUpdateZone(request, Waiters.DEFAULT_POLLING_TERMINATION_STRATEGY, Waiters.DEFAULT_POLLING_DELAY_STRATEGY);
    }

    public Waiter<UpdateZoneRequest, UpdateZoneResponse> forUpdateZone(final UpdateZoneRequest request, final TerminationStrategy terminationStrategy, final DelayStrategy delayStrategy) {
        if (this.workRequestClient == null) {
            throw new IllegalStateException("A WorkRequestClient must be supplied to this waiter for this operation");
        }
        return new SimpleWaiterImpl(this.executorService, (Callable)new Callable<UpdateZoneResponse>(){

            @Override
            public UpdateZoneResponse call() throws Exception {
                UpdateZoneResponse response = DnsWaiters.this.client.updateZone(request);
                if (response.getOpcWorkRequestId() != null) {
                    GetWorkRequestRequest getWorkRequestRequest = GetWorkRequestRequest.builder().workRequestId(response.getOpcWorkRequestId()).build();
                    DnsWaiters.this.workRequestClient.getWaiters().forWorkRequest(getWorkRequestRequest, terminationStrategy, delayStrategy).execute();
                }
                return response;
            }
        }, (Object)request);
    }
}

