/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dns.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.dns.model.DnssecConfig;
import com.oracle.bmc.dns.model.Scope;
import com.oracle.bmc.dns.model.ZoneDnssecState;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class ZoneSummary
extends ExplicitlySetBmcModel {
    @JsonProperty(value="name")
    private final String name;
    @JsonProperty(value="zoneType")
    private final ZoneType zoneType;
    @JsonProperty(value="compartmentId")
    private final String compartmentId;
    @JsonProperty(value="viewId")
    private final String viewId;
    @JsonProperty(value="scope")
    private final Scope scope;
    @JsonProperty(value="freeformTags")
    private final Map<String, String> freeformTags;
    @JsonProperty(value="definedTags")
    private final Map<String, Map<String, Object>> definedTags;
    @JsonProperty(value="dnssecState")
    private final ZoneDnssecState dnssecState;
    @JsonProperty(value="self")
    private final String self;
    @JsonProperty(value="id")
    private final String id;
    @JsonProperty(value="timeCreated")
    private final Date timeCreated;
    @JsonProperty(value="version")
    private final String version;
    @JsonProperty(value="serial")
    private final Long serial;
    @JsonProperty(value="lifecycleState")
    private final LifecycleState lifecycleState;
    @JsonProperty(value="isProtected")
    private final Boolean isProtected;
    @JsonProperty(value="dnssecConfig")
    private final DnssecConfig dnssecConfig;

    @Deprecated
    @ConstructorProperties(value={"name", "zoneType", "compartmentId", "viewId", "scope", "freeformTags", "definedTags", "dnssecState", "self", "id", "timeCreated", "version", "serial", "lifecycleState", "isProtected", "dnssecConfig"})
    public ZoneSummary(String name, ZoneType zoneType, String compartmentId, String viewId, Scope scope, Map<String, String> freeformTags, Map<String, Map<String, Object>> definedTags, ZoneDnssecState dnssecState, String self, String id, Date timeCreated, String version, Long serial, LifecycleState lifecycleState, Boolean isProtected, DnssecConfig dnssecConfig) {
        this.name = name;
        this.zoneType = zoneType;
        this.compartmentId = compartmentId;
        this.viewId = viewId;
        this.scope = scope;
        this.freeformTags = freeformTags;
        this.definedTags = definedTags;
        this.dnssecState = dnssecState;
        this.self = self;
        this.id = id;
        this.timeCreated = timeCreated;
        this.version = version;
        this.serial = serial;
        this.lifecycleState = lifecycleState;
        this.isProtected = isProtected;
        this.dnssecConfig = dnssecConfig;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getName() {
        return this.name;
    }

    public ZoneType getZoneType() {
        return this.zoneType;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getViewId() {
        return this.viewId;
    }

    public Scope getScope() {
        return this.scope;
    }

    public Map<String, String> getFreeformTags() {
        return this.freeformTags;
    }

    public Map<String, Map<String, Object>> getDefinedTags() {
        return this.definedTags;
    }

    public ZoneDnssecState getDnssecState() {
        return this.dnssecState;
    }

    public String getSelf() {
        return this.self;
    }

    public String getId() {
        return this.id;
    }

    public Date getTimeCreated() {
        return this.timeCreated;
    }

    public String getVersion() {
        return this.version;
    }

    public Long getSerial() {
        return this.serial;
    }

    public LifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public Boolean getIsProtected() {
        return this.isProtected;
    }

    public DnssecConfig getDnssecConfig() {
        return this.dnssecConfig;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("ZoneSummary(");
        sb.append("super=").append(super.toString());
        sb.append("name=").append(String.valueOf(this.name));
        sb.append(", zoneType=").append(String.valueOf((Object)this.zoneType));
        sb.append(", compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(", viewId=").append(String.valueOf(this.viewId));
        sb.append(", scope=").append(String.valueOf((Object)this.scope));
        sb.append(", freeformTags=").append(String.valueOf(this.freeformTags));
        sb.append(", definedTags=").append(String.valueOf(this.definedTags));
        sb.append(", dnssecState=").append(String.valueOf((Object)this.dnssecState));
        sb.append(", self=").append(String.valueOf(this.self));
        sb.append(", id=").append(String.valueOf(this.id));
        sb.append(", timeCreated=").append(String.valueOf(this.timeCreated));
        sb.append(", version=").append(String.valueOf(this.version));
        sb.append(", serial=").append(String.valueOf(this.serial));
        sb.append(", lifecycleState=").append(String.valueOf((Object)this.lifecycleState));
        sb.append(", isProtected=").append(String.valueOf(this.isProtected));
        sb.append(", dnssecConfig=").append(String.valueOf((Object)this.dnssecConfig));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ZoneSummary)) {
            return false;
        }
        ZoneSummary other = (ZoneSummary)((Object)o);
        return Objects.equals(this.name, other.name) && Objects.equals((Object)this.zoneType, (Object)other.zoneType) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.viewId, other.viewId) && Objects.equals((Object)this.scope, (Object)other.scope) && Objects.equals(this.freeformTags, other.freeformTags) && Objects.equals(this.definedTags, other.definedTags) && Objects.equals((Object)this.dnssecState, (Object)other.dnssecState) && Objects.equals(this.self, other.self) && Objects.equals(this.id, other.id) && Objects.equals(this.timeCreated, other.timeCreated) && Objects.equals(this.version, other.version) && Objects.equals(this.serial, other.serial) && Objects.equals((Object)this.lifecycleState, (Object)other.lifecycleState) && Objects.equals(this.isProtected, other.isProtected) && Objects.equals((Object)this.dnssecConfig, (Object)other.dnssecConfig) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.name == null ? 43 : this.name.hashCode());
        result = result * 59 + (this.zoneType == null ? 43 : this.zoneType.hashCode());
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.viewId == null ? 43 : this.viewId.hashCode());
        result = result * 59 + (this.scope == null ? 43 : this.scope.hashCode());
        result = result * 59 + (this.freeformTags == null ? 43 : this.freeformTags.hashCode());
        result = result * 59 + (this.definedTags == null ? 43 : this.definedTags.hashCode());
        result = result * 59 + (this.dnssecState == null ? 43 : this.dnssecState.hashCode());
        result = result * 59 + (this.self == null ? 43 : this.self.hashCode());
        result = result * 59 + (this.id == null ? 43 : this.id.hashCode());
        result = result * 59 + (this.timeCreated == null ? 43 : this.timeCreated.hashCode());
        result = result * 59 + (this.version == null ? 43 : this.version.hashCode());
        result = result * 59 + (this.serial == null ? 43 : this.serial.hashCode());
        result = result * 59 + (this.lifecycleState == null ? 43 : this.lifecycleState.hashCode());
        result = result * 59 + (this.isProtected == null ? 43 : this.isProtected.hashCode());
        result = result * 59 + (this.dnssecConfig == null ? 43 : this.dnssecConfig.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum LifecycleState implements BmcEnum
    {
        Active("ACTIVE"),
        Creating("CREATING"),
        Deleted("DELETED"),
        Deleting("DELETING"),
        Failed("FAILED"),
        Updating("UPDATING"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, LifecycleState> map;

        private LifecycleState(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static LifecycleState create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'LifecycleState', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(LifecycleState.class);
            map = new HashMap<String, LifecycleState>();
            for (LifecycleState v : LifecycleState.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum ZoneType implements BmcEnum
    {
        Primary("PRIMARY"),
        Secondary("SECONDARY"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, ZoneType> map;

        private ZoneType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static ZoneType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'ZoneType', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(ZoneType.class);
            map = new HashMap<String, ZoneType>();
            for (ZoneType v : ZoneType.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="name")
        private String name;
        @JsonProperty(value="zoneType")
        private ZoneType zoneType;
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="viewId")
        private String viewId;
        @JsonProperty(value="scope")
        private Scope scope;
        @JsonProperty(value="freeformTags")
        private Map<String, String> freeformTags;
        @JsonProperty(value="definedTags")
        private Map<String, Map<String, Object>> definedTags;
        @JsonProperty(value="dnssecState")
        private ZoneDnssecState dnssecState;
        @JsonProperty(value="self")
        private String self;
        @JsonProperty(value="id")
        private String id;
        @JsonProperty(value="timeCreated")
        private Date timeCreated;
        @JsonProperty(value="version")
        private String version;
        @JsonProperty(value="serial")
        private Long serial;
        @JsonProperty(value="lifecycleState")
        private LifecycleState lifecycleState;
        @JsonProperty(value="isProtected")
        private Boolean isProtected;
        @JsonProperty(value="dnssecConfig")
        private DnssecConfig dnssecConfig;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder name(String name) {
            this.name = name;
            this.__explicitlySet__.add("name");
            return this;
        }

        public Builder zoneType(ZoneType zoneType) {
            this.zoneType = zoneType;
            this.__explicitlySet__.add("zoneType");
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder viewId(String viewId) {
            this.viewId = viewId;
            this.__explicitlySet__.add("viewId");
            return this;
        }

        public Builder scope(Scope scope) {
            this.scope = scope;
            this.__explicitlySet__.add("scope");
            return this;
        }

        public Builder freeformTags(Map<String, String> freeformTags) {
            this.freeformTags = freeformTags;
            this.__explicitlySet__.add("freeformTags");
            return this;
        }

        public Builder definedTags(Map<String, Map<String, Object>> definedTags) {
            this.definedTags = definedTags;
            this.__explicitlySet__.add("definedTags");
            return this;
        }

        public Builder dnssecState(ZoneDnssecState dnssecState) {
            this.dnssecState = dnssecState;
            this.__explicitlySet__.add("dnssecState");
            return this;
        }

        public Builder self(String self) {
            this.self = self;
            this.__explicitlySet__.add("self");
            return this;
        }

        public Builder id(String id) {
            this.id = id;
            this.__explicitlySet__.add("id");
            return this;
        }

        public Builder timeCreated(Date timeCreated) {
            this.timeCreated = timeCreated;
            this.__explicitlySet__.add("timeCreated");
            return this;
        }

        public Builder version(String version) {
            this.version = version;
            this.__explicitlySet__.add("version");
            return this;
        }

        public Builder serial(Long serial) {
            this.serial = serial;
            this.__explicitlySet__.add("serial");
            return this;
        }

        public Builder lifecycleState(LifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            this.__explicitlySet__.add("lifecycleState");
            return this;
        }

        public Builder isProtected(Boolean isProtected) {
            this.isProtected = isProtected;
            this.__explicitlySet__.add("isProtected");
            return this;
        }

        public Builder dnssecConfig(DnssecConfig dnssecConfig) {
            this.dnssecConfig = dnssecConfig;
            this.__explicitlySet__.add("dnssecConfig");
            return this;
        }

        public ZoneSummary build() {
            ZoneSummary model = new ZoneSummary(this.name, this.zoneType, this.compartmentId, this.viewId, this.scope, this.freeformTags, this.definedTags, this.dnssecState, this.self, this.id, this.timeCreated, this.version, this.serial, this.lifecycleState, this.isProtected, this.dnssecConfig);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(ZoneSummary model) {
            if (model.wasPropertyExplicitlySet("name")) {
                this.name(model.getName());
            }
            if (model.wasPropertyExplicitlySet("zoneType")) {
                this.zoneType(model.getZoneType());
            }
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("viewId")) {
                this.viewId(model.getViewId());
            }
            if (model.wasPropertyExplicitlySet("scope")) {
                this.scope(model.getScope());
            }
            if (model.wasPropertyExplicitlySet("freeformTags")) {
                this.freeformTags(model.getFreeformTags());
            }
            if (model.wasPropertyExplicitlySet("definedTags")) {
                this.definedTags(model.getDefinedTags());
            }
            if (model.wasPropertyExplicitlySet("dnssecState")) {
                this.dnssecState(model.getDnssecState());
            }
            if (model.wasPropertyExplicitlySet("self")) {
                this.self(model.getSelf());
            }
            if (model.wasPropertyExplicitlySet("id")) {
                this.id(model.getId());
            }
            if (model.wasPropertyExplicitlySet("timeCreated")) {
                this.timeCreated(model.getTimeCreated());
            }
            if (model.wasPropertyExplicitlySet("version")) {
                this.version(model.getVersion());
            }
            if (model.wasPropertyExplicitlySet("serial")) {
                this.serial(model.getSerial());
            }
            if (model.wasPropertyExplicitlySet("lifecycleState")) {
                this.lifecycleState(model.getLifecycleState());
            }
            if (model.wasPropertyExplicitlySet("isProtected")) {
                this.isProtected(model.getIsProtected());
            }
            if (model.wasPropertyExplicitlySet("dnssecConfig")) {
                this.dnssecConfig(model.getDnssecConfig());
            }
            return this;
        }
    }
}

