/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dns.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.dns.model.DnssecSigningAlgorithm;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class ZskDnssecKeyVersion
extends ExplicitlySetBmcModel {
    @JsonProperty(value="uuid")
    private final String uuid;
    @JsonProperty(value="algorithm")
    private final DnssecSigningAlgorithm algorithm;
    @JsonProperty(value="lengthInBytes")
    private final Integer lengthInBytes;
    @JsonProperty(value="timeCreated")
    private final Date timeCreated;
    @JsonProperty(value="timePublished")
    private final Date timePublished;
    @JsonProperty(value="timeActivated")
    private final Date timeActivated;
    @JsonProperty(value="timeInactivated")
    private final Date timeInactivated;
    @JsonProperty(value="timeUnpublished")
    private final Date timeUnpublished;
    @JsonProperty(value="timeExpired")
    private final Date timeExpired;
    @JsonProperty(value="timePromoted")
    private final Date timePromoted;
    @JsonProperty(value="predecessorDnssecKeyVersionUuid")
    private final String predecessorDnssecKeyVersionUuid;
    @JsonProperty(value="successorDnssecKeyVersionUuid")
    private final String successorDnssecKeyVersionUuid;
    @JsonProperty(value="keyTag")
    private final Integer keyTag;

    @Deprecated
    @ConstructorProperties(value={"uuid", "algorithm", "lengthInBytes", "timeCreated", "timePublished", "timeActivated", "timeInactivated", "timeUnpublished", "timeExpired", "timePromoted", "predecessorDnssecKeyVersionUuid", "successorDnssecKeyVersionUuid", "keyTag"})
    public ZskDnssecKeyVersion(String uuid, DnssecSigningAlgorithm algorithm, Integer lengthInBytes, Date timeCreated, Date timePublished, Date timeActivated, Date timeInactivated, Date timeUnpublished, Date timeExpired, Date timePromoted, String predecessorDnssecKeyVersionUuid, String successorDnssecKeyVersionUuid, Integer keyTag) {
        this.uuid = uuid;
        this.algorithm = algorithm;
        this.lengthInBytes = lengthInBytes;
        this.timeCreated = timeCreated;
        this.timePublished = timePublished;
        this.timeActivated = timeActivated;
        this.timeInactivated = timeInactivated;
        this.timeUnpublished = timeUnpublished;
        this.timeExpired = timeExpired;
        this.timePromoted = timePromoted;
        this.predecessorDnssecKeyVersionUuid = predecessorDnssecKeyVersionUuid;
        this.successorDnssecKeyVersionUuid = successorDnssecKeyVersionUuid;
        this.keyTag = keyTag;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getUuid() {
        return this.uuid;
    }

    public DnssecSigningAlgorithm getAlgorithm() {
        return this.algorithm;
    }

    public Integer getLengthInBytes() {
        return this.lengthInBytes;
    }

    public Date getTimeCreated() {
        return this.timeCreated;
    }

    public Date getTimePublished() {
        return this.timePublished;
    }

    public Date getTimeActivated() {
        return this.timeActivated;
    }

    public Date getTimeInactivated() {
        return this.timeInactivated;
    }

    public Date getTimeUnpublished() {
        return this.timeUnpublished;
    }

    public Date getTimeExpired() {
        return this.timeExpired;
    }

    public Date getTimePromoted() {
        return this.timePromoted;
    }

    public String getPredecessorDnssecKeyVersionUuid() {
        return this.predecessorDnssecKeyVersionUuid;
    }

    public String getSuccessorDnssecKeyVersionUuid() {
        return this.successorDnssecKeyVersionUuid;
    }

    public Integer getKeyTag() {
        return this.keyTag;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("ZskDnssecKeyVersion(");
        sb.append("super=").append(super.toString());
        sb.append("uuid=").append(String.valueOf(this.uuid));
        sb.append(", algorithm=").append(String.valueOf((Object)this.algorithm));
        sb.append(", lengthInBytes=").append(String.valueOf(this.lengthInBytes));
        sb.append(", timeCreated=").append(String.valueOf(this.timeCreated));
        sb.append(", timePublished=").append(String.valueOf(this.timePublished));
        sb.append(", timeActivated=").append(String.valueOf(this.timeActivated));
        sb.append(", timeInactivated=").append(String.valueOf(this.timeInactivated));
        sb.append(", timeUnpublished=").append(String.valueOf(this.timeUnpublished));
        sb.append(", timeExpired=").append(String.valueOf(this.timeExpired));
        sb.append(", timePromoted=").append(String.valueOf(this.timePromoted));
        sb.append(", predecessorDnssecKeyVersionUuid=").append(String.valueOf(this.predecessorDnssecKeyVersionUuid));
        sb.append(", successorDnssecKeyVersionUuid=").append(String.valueOf(this.successorDnssecKeyVersionUuid));
        sb.append(", keyTag=").append(String.valueOf(this.keyTag));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ZskDnssecKeyVersion)) {
            return false;
        }
        ZskDnssecKeyVersion other = (ZskDnssecKeyVersion)((Object)o);
        return Objects.equals(this.uuid, other.uuid) && Objects.equals((Object)this.algorithm, (Object)other.algorithm) && Objects.equals(this.lengthInBytes, other.lengthInBytes) && Objects.equals(this.timeCreated, other.timeCreated) && Objects.equals(this.timePublished, other.timePublished) && Objects.equals(this.timeActivated, other.timeActivated) && Objects.equals(this.timeInactivated, other.timeInactivated) && Objects.equals(this.timeUnpublished, other.timeUnpublished) && Objects.equals(this.timeExpired, other.timeExpired) && Objects.equals(this.timePromoted, other.timePromoted) && Objects.equals(this.predecessorDnssecKeyVersionUuid, other.predecessorDnssecKeyVersionUuid) && Objects.equals(this.successorDnssecKeyVersionUuid, other.successorDnssecKeyVersionUuid) && Objects.equals(this.keyTag, other.keyTag) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.uuid == null ? 43 : this.uuid.hashCode());
        result = result * 59 + (this.algorithm == null ? 43 : this.algorithm.hashCode());
        result = result * 59 + (this.lengthInBytes == null ? 43 : this.lengthInBytes.hashCode());
        result = result * 59 + (this.timeCreated == null ? 43 : this.timeCreated.hashCode());
        result = result * 59 + (this.timePublished == null ? 43 : this.timePublished.hashCode());
        result = result * 59 + (this.timeActivated == null ? 43 : this.timeActivated.hashCode());
        result = result * 59 + (this.timeInactivated == null ? 43 : this.timeInactivated.hashCode());
        result = result * 59 + (this.timeUnpublished == null ? 43 : this.timeUnpublished.hashCode());
        result = result * 59 + (this.timeExpired == null ? 43 : this.timeExpired.hashCode());
        result = result * 59 + (this.timePromoted == null ? 43 : this.timePromoted.hashCode());
        result = result * 59 + (this.predecessorDnssecKeyVersionUuid == null ? 43 : this.predecessorDnssecKeyVersionUuid.hashCode());
        result = result * 59 + (this.successorDnssecKeyVersionUuid == null ? 43 : this.successorDnssecKeyVersionUuid.hashCode());
        result = result * 59 + (this.keyTag == null ? 43 : this.keyTag.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="uuid")
        private String uuid;
        @JsonProperty(value="algorithm")
        private DnssecSigningAlgorithm algorithm;
        @JsonProperty(value="lengthInBytes")
        private Integer lengthInBytes;
        @JsonProperty(value="timeCreated")
        private Date timeCreated;
        @JsonProperty(value="timePublished")
        private Date timePublished;
        @JsonProperty(value="timeActivated")
        private Date timeActivated;
        @JsonProperty(value="timeInactivated")
        private Date timeInactivated;
        @JsonProperty(value="timeUnpublished")
        private Date timeUnpublished;
        @JsonProperty(value="timeExpired")
        private Date timeExpired;
        @JsonProperty(value="timePromoted")
        private Date timePromoted;
        @JsonProperty(value="predecessorDnssecKeyVersionUuid")
        private String predecessorDnssecKeyVersionUuid;
        @JsonProperty(value="successorDnssecKeyVersionUuid")
        private String successorDnssecKeyVersionUuid;
        @JsonProperty(value="keyTag")
        private Integer keyTag;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder uuid(String uuid) {
            this.uuid = uuid;
            this.__explicitlySet__.add("uuid");
            return this;
        }

        public Builder algorithm(DnssecSigningAlgorithm algorithm) {
            this.algorithm = algorithm;
            this.__explicitlySet__.add("algorithm");
            return this;
        }

        public Builder lengthInBytes(Integer lengthInBytes) {
            this.lengthInBytes = lengthInBytes;
            this.__explicitlySet__.add("lengthInBytes");
            return this;
        }

        public Builder timeCreated(Date timeCreated) {
            this.timeCreated = timeCreated;
            this.__explicitlySet__.add("timeCreated");
            return this;
        }

        public Builder timePublished(Date timePublished) {
            this.timePublished = timePublished;
            this.__explicitlySet__.add("timePublished");
            return this;
        }

        public Builder timeActivated(Date timeActivated) {
            this.timeActivated = timeActivated;
            this.__explicitlySet__.add("timeActivated");
            return this;
        }

        public Builder timeInactivated(Date timeInactivated) {
            this.timeInactivated = timeInactivated;
            this.__explicitlySet__.add("timeInactivated");
            return this;
        }

        public Builder timeUnpublished(Date timeUnpublished) {
            this.timeUnpublished = timeUnpublished;
            this.__explicitlySet__.add("timeUnpublished");
            return this;
        }

        public Builder timeExpired(Date timeExpired) {
            this.timeExpired = timeExpired;
            this.__explicitlySet__.add("timeExpired");
            return this;
        }

        public Builder timePromoted(Date timePromoted) {
            this.timePromoted = timePromoted;
            this.__explicitlySet__.add("timePromoted");
            return this;
        }

        public Builder predecessorDnssecKeyVersionUuid(String predecessorDnssecKeyVersionUuid) {
            this.predecessorDnssecKeyVersionUuid = predecessorDnssecKeyVersionUuid;
            this.__explicitlySet__.add("predecessorDnssecKeyVersionUuid");
            return this;
        }

        public Builder successorDnssecKeyVersionUuid(String successorDnssecKeyVersionUuid) {
            this.successorDnssecKeyVersionUuid = successorDnssecKeyVersionUuid;
            this.__explicitlySet__.add("successorDnssecKeyVersionUuid");
            return this;
        }

        public Builder keyTag(Integer keyTag) {
            this.keyTag = keyTag;
            this.__explicitlySet__.add("keyTag");
            return this;
        }

        public ZskDnssecKeyVersion build() {
            ZskDnssecKeyVersion model = new ZskDnssecKeyVersion(this.uuid, this.algorithm, this.lengthInBytes, this.timeCreated, this.timePublished, this.timeActivated, this.timeInactivated, this.timeUnpublished, this.timeExpired, this.timePromoted, this.predecessorDnssecKeyVersionUuid, this.successorDnssecKeyVersionUuid, this.keyTag);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(ZskDnssecKeyVersion model) {
            if (model.wasPropertyExplicitlySet("uuid")) {
                this.uuid(model.getUuid());
            }
            if (model.wasPropertyExplicitlySet("algorithm")) {
                this.algorithm(model.getAlgorithm());
            }
            if (model.wasPropertyExplicitlySet("lengthInBytes")) {
                this.lengthInBytes(model.getLengthInBytes());
            }
            if (model.wasPropertyExplicitlySet("timeCreated")) {
                this.timeCreated(model.getTimeCreated());
            }
            if (model.wasPropertyExplicitlySet("timePublished")) {
                this.timePublished(model.getTimePublished());
            }
            if (model.wasPropertyExplicitlySet("timeActivated")) {
                this.timeActivated(model.getTimeActivated());
            }
            if (model.wasPropertyExplicitlySet("timeInactivated")) {
                this.timeInactivated(model.getTimeInactivated());
            }
            if (model.wasPropertyExplicitlySet("timeUnpublished")) {
                this.timeUnpublished(model.getTimeUnpublished());
            }
            if (model.wasPropertyExplicitlySet("timeExpired")) {
                this.timeExpired(model.getTimeExpired());
            }
            if (model.wasPropertyExplicitlySet("timePromoted")) {
                this.timePromoted(model.getTimePromoted());
            }
            if (model.wasPropertyExplicitlySet("predecessorDnssecKeyVersionUuid")) {
                this.predecessorDnssecKeyVersionUuid(model.getPredecessorDnssecKeyVersionUuid());
            }
            if (model.wasPropertyExplicitlySet("successorDnssecKeyVersionUuid")) {
                this.successorDnssecKeyVersionUuid(model.getSuccessorDnssecKeyVersionUuid());
            }
            if (model.wasPropertyExplicitlySet("keyTag")) {
                this.keyTag(model.getKeyTag());
            }
            return this;
        }
    }
}

