/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dns.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.dns.model.Scope;
import com.oracle.bmc.dns.model.UpdateViewDetails;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class UpdateViewRequest
extends BmcRequest<UpdateViewDetails> {
    private String viewId;
    private UpdateViewDetails updateViewDetails;
    private String ifMatch;
    private String ifUnmodifiedSince;
    private String opcRequestId;
    private Scope scope;

    public String getViewId() {
        return this.viewId;
    }

    public UpdateViewDetails getUpdateViewDetails() {
        return this.updateViewDetails;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public String getIfUnmodifiedSince() {
        return this.ifUnmodifiedSince;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Scope getScope() {
        return this.scope;
    }

    @InternalSdk
    public UpdateViewDetails getBody$() {
        return this.updateViewDetails;
    }

    public Builder toBuilder() {
        return new Builder().viewId(this.viewId).updateViewDetails(this.updateViewDetails).ifMatch(this.ifMatch).ifUnmodifiedSince(this.ifUnmodifiedSince).opcRequestId(this.opcRequestId).scope(this.scope);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",viewId=").append(String.valueOf(this.viewId));
        sb.append(",updateViewDetails=").append(String.valueOf((Object)this.updateViewDetails));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(",ifUnmodifiedSince=").append(String.valueOf(this.ifUnmodifiedSince));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",scope=").append(String.valueOf((Object)this.scope));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UpdateViewRequest)) {
            return false;
        }
        UpdateViewRequest other = (UpdateViewRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.viewId, other.viewId) && Objects.equals((Object)this.updateViewDetails, (Object)other.updateViewDetails) && Objects.equals(this.ifMatch, other.ifMatch) && Objects.equals(this.ifUnmodifiedSince, other.ifUnmodifiedSince) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals((Object)this.scope, (Object)other.scope);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.viewId == null ? 43 : this.viewId.hashCode());
        result = result * 59 + (this.updateViewDetails == null ? 43 : this.updateViewDetails.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        result = result * 59 + (this.ifUnmodifiedSince == null ? 43 : this.ifUnmodifiedSince.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.scope == null ? 43 : this.scope.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<UpdateViewRequest, UpdateViewDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String viewId = null;
        private UpdateViewDetails updateViewDetails = null;
        private String ifMatch = null;
        private String ifUnmodifiedSince = null;
        private String opcRequestId = null;
        private Scope scope = null;

        public Builder viewId(String viewId) {
            this.viewId = viewId;
            return this;
        }

        public Builder updateViewDetails(UpdateViewDetails updateViewDetails) {
            this.updateViewDetails = updateViewDetails;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder ifUnmodifiedSince(String ifUnmodifiedSince) {
            this.ifUnmodifiedSince = ifUnmodifiedSince;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder scope(Scope scope) {
            this.scope = scope;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(UpdateViewRequest o) {
            this.viewId(o.getViewId());
            this.updateViewDetails(o.getUpdateViewDetails());
            this.ifMatch(o.getIfMatch());
            this.ifUnmodifiedSince(o.getIfUnmodifiedSince());
            this.opcRequestId(o.getOpcRequestId());
            this.scope(o.getScope());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public UpdateViewRequest build() {
            UpdateViewRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(UpdateViewDetails body) {
            this.updateViewDetails(body);
            return this;
        }

        public UpdateViewRequest buildWithoutInvocationCallback() {
            UpdateViewRequest request = new UpdateViewRequest();
            request.viewId = this.viewId;
            request.updateViewDetails = this.updateViewDetails;
            request.ifMatch = this.ifMatch;
            request.ifUnmodifiedSince = this.ifUnmodifiedSince;
            request.opcRequestId = this.opcRequestId;
            request.scope = this.scope;
            return request;
        }
    }
}

