/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dns.responses;

import com.oracle.bmc.dns.model.RRSet;
import com.oracle.bmc.responses.BmcResponse;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class GetRRSetResponse
extends BmcResponse {
    private String opcNextPage;
    private Integer opcTotalItems;
    private String opcRequestId;
    private String eTag;
    private RRSet rRSet;

    public String getOpcNextPage() {
        return this.opcNextPage;
    }

    public Integer getOpcTotalItems() {
        return this.opcTotalItems;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getETag() {
        return this.eTag;
    }

    public RRSet getRRSet() {
        return this.rRSet;
    }

    @ConstructorProperties(value={"__httpStatusCode__", "headers", "opcNextPage", "opcTotalItems", "opcRequestId", "eTag", "rRSet"})
    private GetRRSetResponse(int __httpStatusCode__, Map<String, List<String>> headers, String opcNextPage, Integer opcTotalItems, String opcRequestId, String eTag, RRSet rRSet) {
        super(__httpStatusCode__, headers);
        this.opcNextPage = opcNextPage;
        this.opcTotalItems = opcTotalItems;
        this.opcRequestId = opcRequestId;
        this.eTag = eTag;
        this.rRSet = rRSet;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",opcNextPage=").append(String.valueOf(this.opcNextPage));
        sb.append(",opcTotalItems=").append(String.valueOf(this.opcTotalItems));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",eTag=").append(String.valueOf(this.eTag));
        sb.append(",rRSet=").append(String.valueOf((Object)this.rRSet));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetRRSetResponse)) {
            return false;
        }
        GetRRSetResponse other = (GetRRSetResponse)((Object)o);
        return super.equals(o) && Objects.equals(this.opcNextPage, other.opcNextPage) && Objects.equals(this.opcTotalItems, other.opcTotalItems) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.eTag, other.eTag) && Objects.equals((Object)this.rRSet, (Object)other.rRSet);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.opcNextPage == null ? 43 : this.opcNextPage.hashCode());
        result = result * 59 + (this.opcTotalItems == null ? 43 : this.opcTotalItems.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.eTag == null ? 43 : this.eTag.hashCode());
        result = result * 59 + (this.rRSet == null ? 43 : this.rRSet.hashCode());
        return result;
    }

    public static class Builder
    implements BmcResponse.Builder<GetRRSetResponse> {
        private int __httpStatusCode__;
        private Map<String, List<String>> headers;
        private String opcNextPage;
        private Integer opcTotalItems;
        private String opcRequestId;
        private String eTag;
        private RRSet rRSet;

        public Builder __httpStatusCode__(int __httpStatusCode__) {
            this.__httpStatusCode__ = __httpStatusCode__;
            return this;
        }

        public Builder headers(Map<String, List<String>> headers) {
            this.headers = headers;
            return this;
        }

        public Builder opcNextPage(String opcNextPage) {
            this.opcNextPage = opcNextPage;
            return this;
        }

        public Builder opcTotalItems(Integer opcTotalItems) {
            this.opcTotalItems = opcTotalItems;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder eTag(String eTag) {
            this.eTag = eTag;
            return this;
        }

        public Builder rRSet(RRSet rRSet) {
            this.rRSet = rRSet;
            return this;
        }

        public Builder copy(GetRRSetResponse o) {
            this.__httpStatusCode__(o.get__httpStatusCode__());
            this.headers(o.getHeaders());
            this.opcNextPage(o.getOpcNextPage());
            this.opcTotalItems(o.getOpcTotalItems());
            this.opcRequestId(o.getOpcRequestId());
            this.eTag(o.getETag());
            this.rRSet(o.getRRSet());
            return this;
        }

        public GetRRSetResponse build() {
            return new GetRRSetResponse(this.__httpStatusCode__, this.headers, this.opcNextPage, this.opcTotalItems, this.opcRequestId, this.eTag, this.rRSet);
        }
    }
}

